/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.cli;

import org.apache.commons.cli.CommandLine;
import org.apache.gravitino.cli.CommandContext;
import org.apache.gravitino.cli.CommandHandler;
import org.apache.gravitino.cli.FullName;
import org.apache.gravitino.cli.GravitinoCommandLine;
import org.apache.gravitino.cli.Main;
import org.apache.gravitino.cli.commands.Command;

public class GroupCommandHandler
extends CommandHandler {
    private final GravitinoCommandLine gravitinoCommandLine;
    private final CommandLine line;
    private final String command;
    private final CommandContext context;
    private final FullName name;
    private final String metalake;
    private String group;

    public GroupCommandHandler(GravitinoCommandLine gravitinoCommandLine, CommandLine line, String command, CommandContext context) {
        this.gravitinoCommandLine = gravitinoCommandLine;
        this.line = line;
        this.command = command;
        this.context = context;
        this.name = new FullName(line);
        this.metalake = this.name.getMetalakeName();
    }

    @Override
    protected void handle() {
        String userName = this.line.getOptionValue("login");
        Command.setAuthenticationMode(this.context.auth(), userName);
        if ("list".equals(this.command)) {
            this.handleListCommand();
            return;
        }
        this.group = this.line.getOptionValue("group");
        if (this.group == null) {
            System.err.println("Missing --group option.");
            Main.exit(-1);
        }
        if (!this.executeCommand()) {
            System.err.println("Unsupported or unknown command.");
            Main.exit(-1);
        }
    }

    private boolean executeCommand() {
        switch (this.command) {
            case "details": {
                this.handleDetailsCommand();
                return true;
            }
            case "create": {
                this.handleCreateCommand();
                return true;
            }
            case "delete": {
                this.handleDeleteCommand();
                return true;
            }
            case "revoke": {
                this.handleRevokeCommand();
                return true;
            }
            case "grant": {
                this.handleGrantCommand();
                return true;
            }
        }
        return false;
    }

    private void handleDetailsCommand() {
        if (this.line.hasOption("audit")) {
            this.gravitinoCommandLine.newGroupAudit(this.context, this.metalake, this.group).validate().handle();
        } else {
            this.gravitinoCommandLine.newGroupDetails(this.context, this.metalake, this.group).validate().handle();
        }
    }

    private void handleCreateCommand() {
        this.gravitinoCommandLine.newCreateGroup(this.context, this.metalake, this.group).validate().handle();
    }

    private void handleDeleteCommand() {
        this.gravitinoCommandLine.newDeleteGroup(this.context, this.metalake, this.group).validate().handle();
    }

    private void handleRevokeCommand() {
        boolean revokeAll = this.line.hasOption("all");
        if (revokeAll) {
            this.gravitinoCommandLine.newRemoveAllRoles(this.context, this.metalake, this.group, "group").validate().handle();
            System.out.printf("Removed all roles from group %s%n", this.group);
        } else {
            Object[] revokeRoles;
            for (String string : revokeRoles = this.line.getOptionValues("role")) {
                this.gravitinoCommandLine.newRemoveRoleFromGroup(this.context, this.metalake, this.group, string).validate().handle();
            }
            System.out.printf("Removed roles %s from group %s%n", COMMA_JOINER.join(revokeRoles), this.group);
        }
    }

    private void handleGrantCommand() {
        Object[] grantRoles;
        for (String string : grantRoles = this.line.getOptionValues("role")) {
            this.gravitinoCommandLine.newAddRoleToGroup(this.context, this.metalake, this.group, string).validate().handle();
        }
        System.out.printf("Grant roles %s to group %s%n", COMMA_JOINER.join(grantRoles), this.group);
    }

    private void handleListCommand() {
        this.gravitinoCommandLine.newListGroups(this.context, this.metalake).validate().handle();
    }
}

