/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.casting;

import org.apache.paimon.casting.AbstractCastRule;
import org.apache.paimon.casting.CastExecutor;
import org.apache.paimon.casting.CastRulePredicate;
import org.apache.paimon.data.BinaryString;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.DataTypeRoot;
import org.apache.paimon.types.VarCharType;
import org.apache.paimon.utils.DateTimeUtils;

class DateToStringCastRule
extends AbstractCastRule<Integer, BinaryString> {
    static final DateToStringCastRule INSTANCE = new DateToStringCastRule();

    private DateToStringCastRule() {
        super(CastRulePredicate.builder().input(DataTypeRoot.DATE).target((DataType)VarCharType.STRING_TYPE).build());
    }

    @Override
    public CastExecutor<Integer, BinaryString> create(DataType inputType, DataType targetType) {
        return value -> BinaryString.fromString((String)DateTimeUtils.formatDate((int)value));
    }
}

