/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.listener.api.event;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.apache.gravitino.annotation.DeveloperApi;
import org.apache.gravitino.listener.api.event.GroupEvent;
import org.apache.gravitino.listener.api.event.OperationType;
import org.apache.gravitino.listener.api.info.GroupInfo;
import org.apache.gravitino.utils.NameIdentifierUtil;

@DeveloperApi
public class GrantGroupRolesEvent
extends GroupEvent {
    private final GroupInfo grantedGroupInfo;
    private final List<String> roles;

    public GrantGroupRolesEvent(String initiator, String metalake, GroupInfo grantedGroupInfo, List<String> roles) {
        super(initiator, NameIdentifierUtil.ofGroup(metalake, grantedGroupInfo.name()));
        this.grantedGroupInfo = grantedGroupInfo;
        this.roles = roles == null ? null : ImmutableList.copyOf(roles);
    }

    public GroupInfo grantedGroupInfo() {
        return this.grantedGroupInfo;
    }

    public List<String> roles() {
        return this.roles;
    }

    @Override
    public OperationType operationType() {
        return OperationType.GRANT_GROUP_ROLES;
    }
}

