/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.storage.relational.mapper;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.apache.gravitino.storage.relational.JDBCBackend;
import org.apache.gravitino.storage.relational.mapper.provider.base.RoleMetaBaseSQLProvider;
import org.apache.gravitino.storage.relational.mapper.provider.postgresql.RoleMetaPostgreSQLProvider;
import org.apache.gravitino.storage.relational.po.RolePO;
import org.apache.gravitino.storage.relational.session.SqlSessionFactoryHelper;
import org.apache.ibatis.annotations.Param;

public class RoleMetaSQLProviderFactory {
    private static final Map<JDBCBackend.JDBCBackendType, RoleMetaBaseSQLProvider> ROLE_META_SQL_PROVIDER_MAP = ImmutableMap.of((Object)((Object)JDBCBackend.JDBCBackendType.MYSQL), (Object)new RoleMetaMySQLProvider(), (Object)((Object)JDBCBackend.JDBCBackendType.H2), (Object)new RoleMetaH2Provider(), (Object)((Object)JDBCBackend.JDBCBackendType.POSTGRESQL), (Object)new RoleMetaPostgreSQLProvider());

    public static RoleMetaBaseSQLProvider getProvider() {
        String databaseId = SqlSessionFactoryHelper.getInstance().getSqlSessionFactory().getConfiguration().getDatabaseId();
        JDBCBackend.JDBCBackendType jdbcBackendType = JDBCBackend.JDBCBackendType.fromString(databaseId);
        return ROLE_META_SQL_PROVIDER_MAP.get((Object)jdbcBackendType);
    }

    public static String selectRoleMetaByMetalakeIdAndName(@Param(value="metalakeId") Long metalakeId, @Param(value="roleName") String roleName) {
        return RoleMetaSQLProviderFactory.getProvider().selectRoleMetaByMetalakeIdAndName(metalakeId, roleName);
    }

    public static String selectRoleIdByMetalakeIdAndName(@Param(value="metalakeId") Long metalakeId, @Param(value="roleName") String name) {
        return RoleMetaSQLProviderFactory.getProvider().selectRoleIdByMetalakeIdAndName(metalakeId, name);
    }

    public static String listRolesByUserId(@Param(value="userId") Long userId) {
        return RoleMetaSQLProviderFactory.getProvider().listRolesByUserId(userId);
    }

    public static String listRolesByGroupId(Long groupId) {
        return RoleMetaSQLProviderFactory.getProvider().listRolesByGroupId(groupId);
    }

    public static String listRolesByMetadataObjectIdAndType(@Param(value="metadataObjectId") Long metadataObjectId, @Param(value="metadataObjectType") String type) {
        return RoleMetaSQLProviderFactory.getProvider().listRolesByMetadataObjectIdAndType(metadataObjectId, type);
    }

    public static String listRolePOsByMetalake(@Param(value="metalakeName") String metalakeName) {
        return RoleMetaSQLProviderFactory.getProvider().listRolePOsByMetalake(metalakeName);
    }

    public static String insertRoleMeta(@Param(value="roleMeta") RolePO rolePO) {
        return RoleMetaSQLProviderFactory.getProvider().insertRoleMeta(rolePO);
    }

    public static String insertRoleMetaOnDuplicateKeyUpdate(@Param(value="roleMeta") RolePO rolePO) {
        return RoleMetaSQLProviderFactory.getProvider().insertRoleMetaOnDuplicateKeyUpdate(rolePO);
    }

    public static String updateRoleMeta(@Param(value="newRoleMeta") RolePO newRolePO, @Param(value="oldRoleMeta") RolePO oldRolePO) {
        return RoleMetaSQLProviderFactory.getProvider().updateRoleMeta(newRolePO, oldRolePO);
    }

    public static String softDeleteRoleMetaByRoleId(Long roleId) {
        return RoleMetaSQLProviderFactory.getProvider().softDeleteRoleMetaByRoleId(roleId);
    }

    public static String softDeleteRoleMetasByMetalakeId(@Param(value="metalakeId") Long metalakeId) {
        return RoleMetaSQLProviderFactory.getProvider().softDeleteRoleMetasByMetalakeId(metalakeId);
    }

    public static String deleteRoleMetasByLegacyTimeline(@Param(value="legacyTimeline") Long legacyTimeline, @Param(value="limit") int limit) {
        return RoleMetaSQLProviderFactory.getProvider().deleteRoleMetasByLegacyTimeline(legacyTimeline, limit);
    }

    static class RoleMetaH2Provider
    extends RoleMetaBaseSQLProvider {
        RoleMetaH2Provider() {
        }
    }

    static class RoleMetaMySQLProvider
    extends RoleMetaBaseSQLProvider {
        RoleMetaMySQLProvider() {
        }
    }
}

