/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.server.authentication;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.Principal;
import java.util.Enumeration;
import java.util.List;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.gravitino.auth.AuthConstants;
import org.apache.gravitino.exceptions.UnauthorizedException;
import org.apache.gravitino.server.authentication.Authenticator;
import org.apache.gravitino.server.authentication.ServerAuthenticator;

public class AuthenticationFilter
implements Filter {
    private final List<Authenticator> filterAuthenticators;

    public AuthenticationFilter() {
        this.filterAuthenticators = null;
    }

    @VisibleForTesting
    AuthenticationFilter(List<Authenticator> authenticators) {
        this.filterAuthenticators = authenticators;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        try {
            List<Authenticator> authenticators = this.filterAuthenticators == null || this.filterAuthenticators.isEmpty() ? ServerAuthenticator.getInstance().authenticators() : this.filterAuthenticators;
            HttpServletRequest req = (HttpServletRequest)request;
            Enumeration headerData = req.getHeaders("Authorization");
            byte[] authData = null;
            if (headerData.hasMoreElements()) {
                authData = ((String)headerData.nextElement()).getBytes(StandardCharsets.UTF_8);
            }
            Principal principal = null;
            for (Authenticator authenticator : authenticators) {
                if (!authenticator.supportsToken(authData) || !authenticator.isDataFromToken() || (principal = authenticator.authenticateToken(authData)) == null) continue;
                request.setAttribute(AuthConstants.AUTHENTICATED_PRINCIPAL_ATTRIBUTE_NAME, (Object)principal);
                break;
            }
            if (principal == null) {
                throw new UnauthorizedException("The provided credentials did not support", new Object[0]);
            }
            chain.doFilter(request, response);
        }
        catch (UnauthorizedException ue) {
            HttpServletResponse resp = (HttpServletResponse)response;
            if (!ue.getChallenges().isEmpty()) {
                for (String challenge : ue.getChallenges()) {
                    resp.setHeader("WWW-Authenticate", challenge);
                }
            }
            resp.sendError(401, ue.getMessage());
        }
    }

    public void destroy() {
    }
}

