/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.catalog.hive.dyn;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;
import org.apache.gravitino.catalog.hive.dyn.DynConstructors;

public class DynMethods {
    private DynMethods() {
    }

    public static Builder builder(String methodName) {
        return new Builder(methodName);
    }

    private static class MakeAccessible
    implements PrivilegedAction<Void> {
        private final Method hidden;

        MakeAccessible(Method hidden) {
            this.hidden = hidden;
        }

        @Override
        public Void run() {
            this.hidden.setAccessible(true);
            return null;
        }
    }

    public static class Builder {
        private final String name;
        private ClassLoader loader = Thread.currentThread().getContextClassLoader();
        private UnboundMethod method = null;

        public Builder(String methodName) {
            this.name = methodName;
        }

        public Builder loader(ClassLoader newLoader) {
            this.loader = newLoader;
            return this;
        }

        public Builder orNoop() {
            if (this.method == null) {
                this.method = UnboundMethod.NOOP;
            }
            return this;
        }

        public Builder impl(String className, String methodName, Class<?> ... argClasses) {
            if (this.method != null) {
                return this;
            }
            try {
                Class<?> targetClass = Class.forName(className, true, this.loader);
                this.impl(targetClass, methodName, argClasses);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            return this;
        }

        public Builder impl(String className, Class<?> ... argClasses) {
            this.impl(className, this.name, argClasses);
            return this;
        }

        public Builder impl(Class<?> targetClass, String methodName, Class<?> ... argClasses) {
            if (this.method != null) {
                return this;
            }
            try {
                this.method = new UnboundMethod(targetClass.getMethod(methodName, argClasses), this.name);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            return this;
        }

        public Builder impl(Class<?> targetClass, Class<?> ... argClasses) {
            this.impl(targetClass, this.name, argClasses);
            return this;
        }

        public Builder ctorImpl(Class<?> targetClass, Class<?> ... argClasses) {
            if (this.method != null) {
                return this;
            }
            try {
                this.method = DynConstructors.builder().impl(targetClass, argClasses).buildChecked();
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            return this;
        }

        public Builder ctorImpl(String className, Class<?> ... argClasses) {
            if (this.method != null) {
                return this;
            }
            try {
                this.method = DynConstructors.builder().impl(className, argClasses).buildChecked();
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            return this;
        }

        public Builder hiddenImpl(String className, String methodName, Class<?> ... argClasses) {
            if (this.method != null) {
                return this;
            }
            try {
                Class<?> targetClass = Class.forName(className, true, this.loader);
                this.hiddenImpl(targetClass, methodName, argClasses);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            return this;
        }

        public Builder hiddenImpl(String className, Class<?> ... argClasses) {
            this.hiddenImpl(className, this.name, argClasses);
            return this;
        }

        public Builder hiddenImpl(Class<?> targetClass, String methodName, Class<?> ... argClasses) {
            if (this.method != null) {
                return this;
            }
            try {
                Method hidden = targetClass.getDeclaredMethod(methodName, argClasses);
                AccessController.doPrivileged(new MakeAccessible(hidden));
                this.method = new UnboundMethod(hidden, this.name);
            }
            catch (NoSuchMethodException | SecurityException exception) {
                // empty catch block
            }
            return this;
        }

        public Builder hiddenImpl(Class<?> targetClass, Class<?> ... argClasses) {
            this.hiddenImpl(targetClass, this.name, argClasses);
            return this;
        }

        public UnboundMethod build() {
            if (this.method != null) {
                return this.method;
            }
            throw new RuntimeException("Cannot find method: " + this.name);
        }

        public BoundMethod build(Object receiver) {
            return this.build().bind(receiver);
        }

        public UnboundMethod buildChecked() throws NoSuchMethodException {
            if (this.method != null) {
                return this.method;
            }
            throw new NoSuchMethodException("Cannot find method: " + this.name);
        }

        public BoundMethod buildChecked(Object receiver) throws NoSuchMethodException {
            return this.buildChecked().bind(receiver);
        }

        public StaticMethod buildStaticChecked() throws NoSuchMethodException {
            return this.buildChecked().asStatic();
        }

        public StaticMethod buildStatic() {
            return this.build().asStatic();
        }
    }

    public static class StaticMethod {
        private final UnboundMethod method;

        private StaticMethod(UnboundMethod method) {
            this.method = method;
        }

        public <R> R invokeChecked(Object ... args) throws Exception {
            return this.method.invokeChecked(null, args);
        }

        public <R> R invoke(Object ... args) {
            return this.method.invoke(null, args);
        }
    }

    public static class BoundMethod {
        private final UnboundMethod method;
        private final Object receiver;

        private BoundMethod(UnboundMethod method, Object receiver) {
            this.method = method;
            this.receiver = receiver;
        }

        public <R> R invokeChecked(Object ... args) throws Exception {
            return this.method.invokeChecked(this.receiver, args);
        }

        public <R> R invoke(Object ... args) {
            return this.method.invoke(this.receiver, args);
        }
    }

    public static class UnboundMethod {
        private static final UnboundMethod NOOP = new UnboundMethod(null, "NOOP"){

            @Override
            public <R> R invokeChecked(Object target, Object ... args) throws Exception {
                return null;
            }

            @Override
            public BoundMethod bind(Object receiver) {
                return new BoundMethod(this, receiver);
            }

            @Override
            public StaticMethod asStatic() {
                return new StaticMethod(this);
            }

            @Override
            public boolean isStatic() {
                return true;
            }

            @Override
            public String toString() {
                return "DynMethods.UnboundMethod(NOOP)";
            }
        };
        private final Method method;
        private final String name;
        private final int argLength;

        UnboundMethod(Method method, String name) {
            this.method = method;
            this.name = name;
            this.argLength = method == null || method.isVarArgs() ? -1 : method.getParameterTypes().length;
        }

        public <R> R invokeChecked(Object target, Object ... args) throws Exception {
            try {
                if (this.argLength < 0) {
                    return (R)this.method.invoke(target, args);
                }
                return (R)this.method.invoke(target, Arrays.copyOfRange(args, 0, this.argLength));
            }
            catch (InvocationTargetException e) {
                Throwables.throwIfInstanceOf((Throwable)e.getCause(), Exception.class);
                Throwables.throwIfInstanceOf((Throwable)e.getCause(), RuntimeException.class);
                throw new RuntimeException(e.getCause());
            }
        }

        public <R> R invoke(Object target, Object ... args) {
            try {
                return this.invokeChecked(target, args);
            }
            catch (Exception e) {
                Throwables.throwIfInstanceOf((Throwable)e, RuntimeException.class);
                throw new RuntimeException(e);
            }
        }

        public BoundMethod bind(Object receiver) {
            Preconditions.checkState((!this.isStatic() ? 1 : 0) != 0, (String)"Cannot bind static method %s", (Object)this.method.toGenericString());
            Preconditions.checkArgument((boolean)this.method.getDeclaringClass().isAssignableFrom(receiver.getClass()), (String)"Cannot bind %s to instance of %s", (Object)this.method.toGenericString(), receiver.getClass());
            return new BoundMethod(this, receiver);
        }

        public boolean isStatic() {
            return Modifier.isStatic(this.method.getModifiers());
        }

        public boolean isNoop() {
            return this == NOOP;
        }

        public StaticMethod asStatic() {
            Preconditions.checkState((boolean)this.isStatic(), (Object)"Method is not static");
            return new StaticMethod(this);
        }

        public String toString() {
            return "DynMethods.UnboundMethod(name=" + this.name + " method=" + this.method.toGenericString() + ")";
        }
    }
}

