/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.catalog.hive.converter;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.gravitino.connector.DataTypeConverter;
import org.apache.gravitino.rel.types.Type;
import org.apache.gravitino.rel.types.Types;
import org.apache.hadoop.hive.serde2.typeinfo.CharTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.DecimalTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.ListTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.MapTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.StructTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.hadoop.hive.serde2.typeinfo.UnionTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.VarcharTypeInfo;

public class HiveDataTypeConverter
implements DataTypeConverter<TypeInfo, String> {
    public static final HiveDataTypeConverter CONVERTER = new HiveDataTypeConverter();

    public TypeInfo fromGravitino(Type type) {
        switch (type.name()) {
            case BOOLEAN: {
                return TypeInfoFactory.getPrimitiveTypeInfo((String)"boolean");
            }
            case BYTE: {
                return TypeInfoFactory.getPrimitiveTypeInfo((String)"tinyint");
            }
            case SHORT: {
                return TypeInfoFactory.getPrimitiveTypeInfo((String)"smallint");
            }
            case INTEGER: {
                return TypeInfoFactory.getPrimitiveTypeInfo((String)"int");
            }
            case LONG: {
                return TypeInfoFactory.getPrimitiveTypeInfo((String)"bigint");
            }
            case FLOAT: {
                return TypeInfoFactory.getPrimitiveTypeInfo((String)"float");
            }
            case DOUBLE: {
                return TypeInfoFactory.getPrimitiveTypeInfo((String)"double");
            }
            case STRING: {
                return TypeInfoFactory.getPrimitiveTypeInfo((String)"string");
            }
            case VARCHAR: {
                return TypeInfoFactory.getVarcharTypeInfo((int)((Types.VarCharType)type).length());
            }
            case FIXEDCHAR: {
                return TypeInfoFactory.getCharTypeInfo((int)((Types.FixedCharType)type).length());
            }
            case DATE: {
                return TypeInfoFactory.getPrimitiveTypeInfo((String)"date");
            }
            case TIMESTAMP: {
                return TypeInfoFactory.getPrimitiveTypeInfo((String)"timestamp");
            }
            case DECIMAL: {
                Types.DecimalType decimalType = (Types.DecimalType)type;
                return TypeInfoFactory.getDecimalTypeInfo((int)decimalType.precision(), (int)decimalType.scale());
            }
            case BINARY: {
                return TypeInfoFactory.getPrimitiveTypeInfo((String)"binary");
            }
            case INTERVAL_YEAR: {
                return TypeInfoFactory.getPrimitiveTypeInfo((String)"interval_year_month");
            }
            case INTERVAL_DAY: {
                return TypeInfoFactory.getPrimitiveTypeInfo((String)"interval_day_time");
            }
            case LIST: {
                return TypeInfoFactory.getListTypeInfo((TypeInfo)this.fromGravitino(((Types.ListType)type).elementType()));
            }
            case MAP: {
                Types.MapType mapType = (Types.MapType)type;
                return TypeInfoFactory.getMapTypeInfo((TypeInfo)this.fromGravitino(mapType.keyType()), (TypeInfo)this.fromGravitino(mapType.valueType()));
            }
            case STRUCT: {
                Types.StructType structType = (Types.StructType)type;
                List typeInfos = Arrays.stream(structType.fields()).map(t -> this.fromGravitino(t.type())).collect(Collectors.toList());
                List names = Arrays.stream(structType.fields()).map(Types.StructType.Field::name).collect(Collectors.toList());
                return TypeInfoFactory.getStructTypeInfo(names, typeInfos);
            }
            case UNION: {
                return TypeInfoFactory.getUnionTypeInfo(Arrays.stream(((Types.UnionType)type).types()).map(this::fromGravitino).collect(Collectors.toList()));
            }
        }
        throw new UnsupportedOperationException("Unsupported conversion to Hive type: " + type);
    }

    public Type toGravitino(String hiveType) {
        return this.toGravitino(TypeInfoUtils.getTypeInfoFromTypeString((String)hiveType));
    }

    private Type toGravitino(TypeInfo hiveTypeInfo) {
        switch (hiveTypeInfo.getCategory()) {
            case PRIMITIVE: {
                switch (hiveTypeInfo.getTypeName()) {
                    case "boolean": {
                        return Types.BooleanType.get();
                    }
                    case "tinyint": {
                        return Types.ByteType.get();
                    }
                    case "smallint": {
                        return Types.ShortType.get();
                    }
                    case "int": {
                        return Types.IntegerType.get();
                    }
                    case "bigint": {
                        return Types.LongType.get();
                    }
                    case "float": {
                        return Types.FloatType.get();
                    }
                    case "double": {
                        return Types.DoubleType.get();
                    }
                    case "string": {
                        return Types.StringType.get();
                    }
                    case "date": {
                        return Types.DateType.get();
                    }
                    case "timestamp": {
                        return Types.TimestampType.withoutTimeZone();
                    }
                    case "binary": {
                        return Types.BinaryType.get();
                    }
                    case "interval_year_month": {
                        return Types.IntervalYearType.get();
                    }
                    case "interval_day_time": {
                        return Types.IntervalDayType.get();
                    }
                }
                if (hiveTypeInfo instanceof CharTypeInfo) {
                    return Types.FixedCharType.of((int)((CharTypeInfo)hiveTypeInfo).getLength());
                }
                if (hiveTypeInfo instanceof VarcharTypeInfo) {
                    return Types.VarCharType.of((int)((VarcharTypeInfo)hiveTypeInfo).getLength());
                }
                if (hiveTypeInfo instanceof DecimalTypeInfo) {
                    DecimalTypeInfo decimalTypeInfo = (DecimalTypeInfo)hiveTypeInfo;
                    return Types.DecimalType.of((int)decimalTypeInfo.precision(), (int)decimalTypeInfo.scale());
                }
                return Types.ExternalType.of((String)hiveTypeInfo.getQualifiedName());
            }
            case LIST: {
                return Types.ListType.nullable((Type)this.toGravitino(((ListTypeInfo)hiveTypeInfo).getListElementTypeInfo()));
            }
            case MAP: {
                MapTypeInfo mapTypeInfo = (MapTypeInfo)hiveTypeInfo;
                return Types.MapType.valueNullable((Type)this.toGravitino(mapTypeInfo.getMapKeyTypeInfo()), (Type)this.toGravitino(mapTypeInfo.getMapValueTypeInfo()));
            }
            case STRUCT: {
                StructTypeInfo structTypeInfo = (StructTypeInfo)hiveTypeInfo;
                ArrayList fieldNames = structTypeInfo.getAllStructFieldNames();
                ArrayList typeInfos = structTypeInfo.getAllStructFieldTypeInfos();
                Types.StructType.Field[] fields = (Types.StructType.Field[])IntStream.range(0, fieldNames.size()).mapToObj(i -> Types.StructType.Field.nullableField((String)((String)fieldNames.get(i)), (Type)this.toGravitino((TypeInfo)typeInfos.get(i)))).toArray(Types.StructType.Field[]::new);
                return Types.StructType.of((Types.StructType.Field[])fields);
            }
            case UNION: {
                UnionTypeInfo unionTypeInfo = (UnionTypeInfo)hiveTypeInfo;
                return Types.UnionType.of((Type[])((Type[])unionTypeInfo.getAllUnionObjectTypeInfos().stream().map(this::toGravitino).toArray(Type[]::new)));
            }
        }
        return Types.ExternalType.of((String)hiveTypeInfo.getQualifiedName());
    }
}

