/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.catalog.hive;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.gravitino.catalog.hive.CachedClientPool;
import org.apache.gravitino.catalog.hive.HiveColumn;
import org.apache.gravitino.catalog.hive.HiveTableOperations;
import org.apache.gravitino.catalog.hive.StorageFormat;
import org.apache.gravitino.catalog.hive.TableType;
import org.apache.gravitino.catalog.hive.converter.HiveDataTypeConverter;
import org.apache.gravitino.connector.BaseTable;
import org.apache.gravitino.connector.PropertiesMetadata;
import org.apache.gravitino.connector.TableOperations;
import org.apache.gravitino.meta.AuditInfo;
import org.apache.gravitino.rel.Column;
import org.apache.gravitino.rel.SupportsPartitions;
import org.apache.gravitino.rel.expressions.Expression;
import org.apache.gravitino.rel.expressions.NamedReference;
import org.apache.gravitino.rel.expressions.distributions.Distribution;
import org.apache.gravitino.rel.expressions.distributions.Distributions;
import org.apache.gravitino.rel.expressions.sorts.SortDirection;
import org.apache.gravitino.rel.expressions.sorts.SortOrder;
import org.apache.gravitino.rel.expressions.sorts.SortOrders;
import org.apache.gravitino.rel.expressions.transforms.Transform;
import org.apache.gravitino.rel.expressions.transforms.Transforms;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.Order;
import org.apache.hadoop.hive.metastore.api.SerDeInfo;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.metastore.api.Table;

public class HiveTable
extends BaseTable {
    public static final Set<String> SUPPORT_TABLE_TYPES = Sets.newHashSet((Object[])new String[]{TableType.MANAGED_TABLE.name(), TableType.EXTERNAL_TABLE.name()});
    public static final String ICEBERG_TABLE_TYPE_VALUE = "ICEBERG";
    public static final String TABLE_TYPE_PROP = "table_type";
    private String schemaName;
    private CachedClientPool clientPool;
    private StorageDescriptor sd;

    private HiveTable() {
    }

    public static Builder fromHiveTable(Table table) {
        AuditInfo.Builder auditInfoBuilder = AuditInfo.builder();
        Optional.ofNullable(table.getOwner()).ifPresent(arg_0 -> ((AuditInfo.Builder)auditInfoBuilder).withCreator(arg_0));
        if (table.isSetCreateTime()) {
            auditInfoBuilder.withCreateTime(Instant.ofEpochSecond(table.getCreateTime()));
        }
        StorageDescriptor sd = table.getSd();
        Distribution distribution = Distributions.NONE;
        if (CollectionUtils.isNotEmpty((Collection)sd.getBucketCols())) {
            distribution = Distributions.hash((int)sd.getNumBuckets(), (Expression[])((Expression[])sd.getBucketCols().stream().map(NamedReference::field).toArray(Expression[]::new)));
        }
        SortOrder[] sortOrders = new SortOrder[]{};
        if (CollectionUtils.isNotEmpty((Collection)sd.getSortCols())) {
            sortOrders = (SortOrder[])sd.getSortCols().stream().map(f -> SortOrders.of((Expression)NamedReference.field((String)f.getCol()), (SortDirection)(f.getOrder() == 1 ? SortDirection.ASCENDING : SortDirection.DESCENDING))).toArray(SortOrder[]::new);
        }
        Column[] columns = (Column[])Stream.concat(sd.getCols().stream().map(f -> (HiveColumn)((HiveColumn.Builder)((HiveColumn.Builder)((HiveColumn.Builder)HiveColumn.builder().withName(f.getName())).withType(HiveDataTypeConverter.CONVERTER.toGravitino(f.getType()))).withComment(f.getComment())).build()), table.getPartitionKeys().stream().map(p -> (HiveColumn)((HiveColumn.Builder)((HiveColumn.Builder)((HiveColumn.Builder)HiveColumn.builder().withName(p.getName())).withType(HiveDataTypeConverter.CONVERTER.toGravitino(p.getType()))).withComment(p.getComment())).build())).toArray(Column[]::new);
        return ((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)HiveTable.builder().withName(table.getTableName())).withComment((String)table.getParameters().get("comment"))).withProperties(HiveTable.buildTableProperties(table))).withColumns(columns)).withDistribution(distribution)).withSortOrders(sortOrders)).withAuditInfo(auditInfoBuilder.build())).withPartitioning((Transform[])table.getPartitionKeys().stream().map(p -> Transforms.identity((String)p.getName())).toArray(Transform[]::new))).withSchemaName(table.getDbName()).withStorageDescriptor(table.getSd());
    }

    public CachedClientPool clientPool() {
        return this.clientPool;
    }

    public void close() {
        if (this.clientPool != null) {
            this.clientPool = null;
        }
    }

    public String schemaName() {
        return this.schemaName;
    }

    public StorageDescriptor storageDescriptor() {
        return this.sd;
    }

    private static Map<String, String> buildTableProperties(Table table) {
        HashMap properties = Maps.newHashMap((Map)table.getParameters());
        Optional.ofNullable(table.getTableType()).ifPresent(t -> properties.put("table-type", t));
        StorageDescriptor sd = table.getSd();
        properties.put("location", sd.getLocation());
        properties.put("input-format", sd.getInputFormat());
        properties.put("output-format", sd.getOutputFormat());
        SerDeInfo serdeInfo = sd.getSerdeInfo();
        Optional.ofNullable(serdeInfo.getName()).ifPresent(name -> properties.put("serde-name", name));
        Optional.ofNullable(serdeInfo.getSerializationLib()).ifPresent(lib -> properties.put("serde-lib", lib));
        Optional.ofNullable(serdeInfo.getParameters()).ifPresent(p -> p.forEach((k, v) -> properties.put("serde.parameter." + k, v)));
        return properties;
    }

    public Table toHiveTable(PropertiesMetadata tablePropertiesMetadata) {
        Table hiveTable = new Table();
        hiveTable.setTableName(this.name);
        hiveTable.setDbName(this.schemaName);
        hiveTable.setTableType(((TableType)tablePropertiesMetadata.getOrDefault(this.properties(), "table-type")).name());
        List<FieldSchema> partitionFields = this.buildPartitionKeys();
        hiveTable.setSd(this.buildStorageDescriptor(tablePropertiesMetadata, partitionFields));
        hiveTable.setParameters(this.buildTableParameters());
        hiveTable.setPartitionKeys(partitionFields);
        hiveTable.setOwner(this.auditInfo.creator());
        hiveTable.setCreateTime(Math.toIntExact(this.auditInfo.createTime().getEpochSecond()));
        return hiveTable;
    }

    private Map<String, String> buildTableParameters() {
        HashMap parameters = Maps.newHashMap((Map)this.properties());
        Optional.ofNullable(this.comment).ifPresent(c -> parameters.put("comment", c));
        if (TableType.EXTERNAL_TABLE.name().equalsIgnoreCase((String)this.properties().get("table-type"))) {
            parameters.put("EXTERNAL", "TRUE");
        } else {
            parameters.put("EXTERNAL", "FALSE");
        }
        parameters.remove("location");
        parameters.remove("table-type");
        parameters.remove("input-format");
        parameters.remove("output-format");
        parameters.remove("serde-name");
        parameters.remove("serde-lib");
        parameters.remove("format");
        parameters.keySet().removeIf(k -> k.startsWith("serde.parameter."));
        return parameters;
    }

    public List<FieldSchema> buildPartitionKeys() {
        return Arrays.stream(this.partitioning).map(p -> this.getPartitionKey(((Transforms.IdentityTransform)p).fieldName())).collect(Collectors.toList());
    }

    private FieldSchema getPartitionKey(String[] fieldName) {
        List partitionColumns = Arrays.stream(this.columns).filter(c -> c.name().equals(fieldName[0])).collect(Collectors.toList());
        return new FieldSchema(((Column)partitionColumns.get(0)).name(), HiveDataTypeConverter.CONVERTER.fromGravitino(((Column)partitionColumns.get(0)).dataType()).getQualifiedName(), ((Column)partitionColumns.get(0)).comment());
    }

    private StorageDescriptor buildStorageDescriptor(PropertiesMetadata tablePropertiesMetadata, List<FieldSchema> partitionFields) {
        StorageDescriptor strgDesc = new StorageDescriptor();
        List partitionKeys = partitionFields.stream().map(FieldSchema::getName).collect(Collectors.toList());
        strgDesc.setCols(Arrays.stream(this.columns).filter(c -> !partitionKeys.contains(c.name())).map(c -> new FieldSchema(c.name(), HiveDataTypeConverter.CONVERTER.fromGravitino(c.dataType()).getQualifiedName(), c.comment())).collect(Collectors.toList()));
        Optional.ofNullable((String)this.properties().get("location")).ifPresent(l -> strgDesc.setLocation((String)this.properties().get("location")));
        strgDesc.setSerdeInfo(this.buildSerDeInfo(tablePropertiesMetadata));
        StorageFormat storageFormat = (StorageFormat)tablePropertiesMetadata.getOrDefault(this.properties(), "format");
        strgDesc.setInputFormat(storageFormat.getInputFormat());
        strgDesc.setOutputFormat(storageFormat.getOutputFormat());
        Optional.ofNullable((String)this.properties().get("input-format")).ifPresent(arg_0 -> ((StorageDescriptor)strgDesc).setInputFormat(arg_0));
        Optional.ofNullable((String)this.properties().get("output-format")).ifPresent(arg_0 -> ((StorageDescriptor)strgDesc).setOutputFormat(arg_0));
        if (ArrayUtils.isNotEmpty((Object[])this.sortOrders)) {
            for (SortOrder sortOrder : this.sortOrders) {
                String columnName = ((NamedReference.FieldReference)sortOrder.expression()).fieldName()[0];
                strgDesc.addToSortCols(new Order(columnName, sortOrder.direction() == SortDirection.ASCENDING ? 1 : 0));
            }
        }
        if (!Distributions.NONE.equals(this.distribution)) {
            strgDesc.setBucketCols(Arrays.stream(this.distribution.expressions()).map(t -> ((NamedReference.FieldReference)t).fieldName()[0]).collect(Collectors.toList()));
            strgDesc.setNumBuckets(this.distribution.number());
        }
        return strgDesc;
    }

    private SerDeInfo buildSerDeInfo(PropertiesMetadata tablePropertiesMetadata) {
        SerDeInfo serDeInfo = new SerDeInfo();
        serDeInfo.setName(this.properties().getOrDefault("serde-name", this.name()));
        StorageFormat storageFormat = (StorageFormat)tablePropertiesMetadata.getOrDefault(this.properties(), "format");
        serDeInfo.setSerializationLib(storageFormat.getSerde());
        Optional.ofNullable((String)this.properties().get("serde-lib")).ifPresent(arg_0 -> ((SerDeInfo)serDeInfo).setSerializationLib(arg_0));
        this.properties().entrySet().stream().filter(e -> ((String)e.getKey()).startsWith("serde.parameter.")).forEach(e -> serDeInfo.putToParameters(((String)e.getKey()).substring("serde.parameter.".length()), (String)e.getValue()));
        return serDeInfo;
    }

    protected TableOperations newOps() {
        return new HiveTableOperations(this);
    }

    public SupportsPartitions supportPartitions() throws UnsupportedOperationException {
        return (SupportsPartitions)this.ops();
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        return "HiveTable(schemaName=" + this.schemaName + ", clientPool=" + this.clientPool + ", sd=" + this.sd + ")";
    }

    static /* synthetic */ Column[] access$502(HiveTable x0, Column[] x1) {
        x0.columns = x1;
        return x1;
    }

    static /* synthetic */ SortOrder[] access$702(HiveTable x0, SortOrder[] x1) {
        x0.sortOrders = x1;
        return x1;
    }

    static /* synthetic */ Transform[] access$802(HiveTable x0, Transform[] x1) {
        x0.partitioning = x1;
        return x1;
    }

    public static class Builder
    extends BaseTable.BaseTableBuilder<Builder, HiveTable> {
        private String schemaName;
        private CachedClientPool clientPool;
        private StorageDescriptor sd;

        public Builder withSchemaName(String schemaName) {
            this.schemaName = schemaName;
            return this;
        }

        public Builder withStorageDescriptor(StorageDescriptor sd) {
            this.sd = sd;
            return this;
        }

        public Builder withClientPool(CachedClientPool clientPool) {
            this.clientPool = clientPool;
            return this;
        }

        private Builder() {
        }

        protected HiveTable internalBuild() {
            HiveTable hiveTable = new HiveTable();
            hiveTable.name = this.name;
            hiveTable.comment = this.comment;
            hiveTable.properties = this.properties != null ? Maps.newHashMap((Map)this.properties) : Maps.newHashMap();
            hiveTable.auditInfo = this.auditInfo;
            HiveTable.access$502(hiveTable, this.columns);
            hiveTable.distribution = this.distribution;
            HiveTable.access$702(hiveTable, this.sortOrders);
            HiveTable.access$802(hiveTable, this.partitioning);
            hiveTable.schemaName = this.schemaName;
            hiveTable.clientPool = this.clientPool;
            hiveTable.sd = this.sd;
            hiveTable.proxyPlugin = this.proxyPlugin;
            if (this.comment != null) {
                hiveTable.properties.put("comment", this.comment);
            }
            return hiveTable;
        }
    }
}

