/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.catalog.hive;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.gravitino.connector.BaseSchema;
import org.apache.gravitino.meta.AuditInfo;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.PrincipalType;

public class HiveSchema
extends BaseSchema {
    private Configuration conf;

    private HiveSchema() {
    }

    public static HiveSchema fromHiveDB(Database db, Configuration hiveConf) {
        Map<String, String> properties = HiveSchema.buildSchemaProperties(db);
        AuditInfo.Builder auditInfoBuilder = AuditInfo.builder();
        Optional.ofNullable(db.getOwnerName()).ifPresent(arg_0 -> ((AuditInfo.Builder)auditInfoBuilder).withCreator(arg_0));
        return (HiveSchema)((Builder)((Builder)((Builder)((Builder)HiveSchema.builder().withName(db.getName())).withComment(db.getDescription())).withProperties(properties)).withAuditInfo(auditInfoBuilder.build())).withConf(hiveConf).build();
    }

    public static Map<String, String> buildSchemaProperties(Database database) {
        HashMap properties = Maps.newHashMap((Map)database.getParameters());
        properties.put("location", database.getLocationUri());
        return properties;
    }

    public Database toHiveDB() {
        Database hiveDb = new Database();
        hiveDb.setName(this.name());
        Optional.ofNullable((String)this.properties().get("location")).ifPresent(arg_0 -> ((Database)hiveDb).setLocationUri(arg_0));
        Optional.ofNullable(this.comment()).ifPresent(arg_0 -> ((Database)hiveDb).setDescription(arg_0));
        hiveDb.setOwnerName(this.auditInfo().creator());
        hiveDb.setOwnerType(PrincipalType.USER);
        HashMap parameters = Maps.newHashMap((Map)this.properties());
        parameters.remove("location");
        hiveDb.setParameters((Map)parameters);
        return hiveDb;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        return "HiveSchema(conf=" + this.conf + ")";
    }

    public static class Builder
    extends BaseSchema.BaseSchemaBuilder<Builder, HiveSchema> {
        protected Configuration conf;

        public Builder withConf(Configuration conf) {
            this.conf = conf;
            return this;
        }

        private Builder() {
        }

        protected HiveSchema internalBuild() {
            HiveSchema hiveSchema = new HiveSchema();
            hiveSchema.name = this.name;
            hiveSchema.comment = this.comment;
            hiveSchema.properties = this.properties;
            hiveSchema.auditInfo = this.auditInfo;
            hiveSchema.conf = this.conf;
            return hiveSchema;
        }
    }
}

