/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.catalog.hive;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.UndeclaredThrowableException;
import java.security.Principal;
import java.security.PrivilegedActionException;
import java.util.Map;
import org.apache.gravitino.catalog.hive.HiveCatalogOperations;
import org.apache.gravitino.connector.CatalogOperations;
import org.apache.gravitino.connector.ProxyPlugin;
import org.apache.gravitino.utils.Executable;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;

class HiveProxyPlugin
implements ProxyPlugin {
    private final UserGroupInformation realUser;
    private HiveCatalogOperations ops;

    HiveProxyPlugin() {
        try {
            this.realUser = UserGroupInformation.getCurrentUser();
        }
        catch (IOException ioe) {
            throw new IllegalStateException("Fail to init HiveCatalogProxyPlugin");
        }
    }

    public Object doAs(Principal principal, Executable<Object, Exception> action, Map<String, String> properties) throws Throwable {
        try {
            UserGroupInformation proxyUser;
            if (UserGroupInformation.isSecurityEnabled() && this.ops != null) {
                String proxyKerberosPrincipalName = principal.getName();
                if (!proxyKerberosPrincipalName.contains("@")) {
                    proxyKerberosPrincipalName = String.format("%s@%s", proxyKerberosPrincipalName, this.ops.getKerberosRealm());
                }
                proxyUser = UserGroupInformation.createProxyUser((String)proxyKerberosPrincipalName, (UserGroupInformation)this.realUser);
                String token = (String)this.ops.getClientPool().run(client -> client.getDelegationToken(principal.getName(), this.realUser.getUserName()));
                Token delegationToken = new Token();
                delegationToken.decodeFromUrlString(token);
                delegationToken.setService(new Text(this.ops.getHiveConf().getVar(HiveConf.ConfVars.METASTORE_TOKEN_SIGNATURE)));
                proxyUser.addToken(delegationToken);
            } else {
                proxyUser = UserGroupInformation.createProxyUser((String)principal.getName(), (UserGroupInformation)this.realUser);
            }
            return proxyUser.doAs(() -> action.execute());
        }
        catch (UndeclaredThrowableException e) {
            Throwable innerException = e.getCause();
            if (innerException instanceof PrivilegedActionException) {
                throw innerException.getCause();
            }
            if (innerException instanceof InvocationTargetException) {
                throw innerException.getCause();
            }
            throw innerException;
        }
    }

    public void bindCatalogOperation(CatalogOperations ops) {
        this.ops = (HiveCatalogOperations)ops;
        this.ops.setProxyPlugin(this);
    }
}

