/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.catalog.hive;

import com.google.common.annotations.VisibleForTesting;
import org.apache.gravitino.catalog.hive.dyn.DynMethods;
import org.apache.gravitino.utils.ClientPoolImpl;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.HiveMetaHookLoader;
import org.apache.hadoop.hive.metastore.HiveMetaStoreClient;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.RetryingMetaStoreClient;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.thrift.TException;
import org.apache.thrift.transport.TTransportException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveClientPool
extends ClientPoolImpl<IMetaStoreClient, TException> {
    private static final Logger LOG = LoggerFactory.getLogger(HiveClientPool.class);
    private static final DynMethods.StaticMethod GET_CLIENT = DynMethods.builder("getProxy").impl(RetryingMetaStoreClient.class, HiveConf.class, HiveMetaHookLoader.class, String.class).impl(RetryingMetaStoreClient.class, Configuration.class, HiveMetaHookLoader.class, String.class).buildStatic();
    private final HiveConf hiveConf;

    public HiveClientPool(int poolSize, Configuration conf) {
        super(poolSize, TTransportException.class, false);
        this.hiveConf = new HiveConf(conf, HiveClientPool.class);
        this.hiveConf.addResource(conf);
    }

    protected IMetaStoreClient newClient() {
        try {
            try {
                return (IMetaStoreClient)GET_CLIENT.invoke(this.hiveConf, tbl -> null, HiveMetaStoreClient.class.getName());
            }
            catch (RuntimeException e) {
                if (e.getCause() instanceof MetaException) {
                    throw (MetaException)e.getCause();
                }
                throw e;
            }
        }
        catch (MetaException e) {
            throw new RuntimeException("Failed to connect to Hive Metastore", e);
        }
        catch (Exception e) {
            if (e.getMessage().contains("Another instance of Derby may have already booted")) {
                throw new RuntimeException("Failed to start an embedded metastore because embedded Derby supports only one client at a time. To fix this, use a metastore that supports multiple clients.", e);
            }
            throw new RuntimeException("Failed to connect to Hive Metastore", e);
        }
    }

    protected IMetaStoreClient reconnect(IMetaStoreClient client) {
        LOG.warn("Reconnecting to Hive Metastore");
        try {
            client.close();
            client.reconnect();
        }
        catch (MetaException e) {
            throw new RuntimeException("Failed to reconnect to Hive Metastore", e);
        }
        return client;
    }

    protected boolean isConnectionException(Exception e) {
        return super.isConnectionException(e) || e instanceof MetaException && e.getMessage().contains("Got exception: org.apache.thrift.transport.TTransportException");
    }

    protected void close(IMetaStoreClient client) {
        LOG.info("Closing Hive Metastore client");
        client.close();
    }

    @VisibleForTesting
    HiveConf hiveConf() {
        return this.hiveConf;
    }
}

