/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.catalog.hive;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.lang.reflect.Method;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.time.Instant;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.gravitino.Catalog;
import org.apache.gravitino.NameIdentifier;
import org.apache.gravitino.Namespace;
import org.apache.gravitino.SchemaChange;
import org.apache.gravitino.catalog.hive.CachedClientPool;
import org.apache.gravitino.catalog.hive.FetchFileUtils;
import org.apache.gravitino.catalog.hive.HiveProxyPlugin;
import org.apache.gravitino.catalog.hive.HiveSchema;
import org.apache.gravitino.catalog.hive.HiveTable;
import org.apache.gravitino.catalog.hive.TableType;
import org.apache.gravitino.catalog.hive.converter.HiveDataTypeConverter;
import org.apache.gravitino.connector.CatalogInfo;
import org.apache.gravitino.connector.CatalogOperations;
import org.apache.gravitino.connector.HasPropertyMetadata;
import org.apache.gravitino.connector.ProxyPlugin;
import org.apache.gravitino.connector.SupportsSchemas;
import org.apache.gravitino.exceptions.ConnectionFailedException;
import org.apache.gravitino.exceptions.NoSuchCatalogException;
import org.apache.gravitino.exceptions.NoSuchSchemaException;
import org.apache.gravitino.exceptions.NoSuchTableException;
import org.apache.gravitino.exceptions.NonEmptySchemaException;
import org.apache.gravitino.exceptions.SchemaAlreadyExistsException;
import org.apache.gravitino.exceptions.TableAlreadyExistsException;
import org.apache.gravitino.meta.AuditInfo;
import org.apache.gravitino.rel.Column;
import org.apache.gravitino.rel.TableCatalog;
import org.apache.gravitino.rel.TableChange;
import org.apache.gravitino.rel.expressions.NamedReference;
import org.apache.gravitino.rel.expressions.distributions.Distribution;
import org.apache.gravitino.rel.expressions.distributions.Distributions;
import org.apache.gravitino.rel.expressions.sorts.SortOrder;
import org.apache.gravitino.rel.expressions.transforms.Transform;
import org.apache.gravitino.rel.expressions.transforms.Transforms;
import org.apache.gravitino.rel.indexes.Index;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.api.AlreadyExistsException;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.InvalidOperationException;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.api.UnknownDBException;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveCatalogOperations
implements CatalogOperations,
SupportsSchemas,
TableCatalog {
    public static final Logger LOG = LoggerFactory.getLogger(HiveCatalogOperations.class);
    public static final String GRAVITINO_KEYTAB_FORMAT = "keytabs/gravitino-hive-%s-keytab";
    @VisibleForTesting
    CachedClientPool clientPool;
    @VisibleForTesting
    HiveConf hiveConf;
    private CatalogInfo info;
    private HasPropertyMetadata propertiesMetadata;
    private ScheduledThreadPoolExecutor checkTgtExecutor;
    private String kerberosRealm;
    private ProxyPlugin proxyPlugin;
    boolean listAllTables = true;
    public static final Map<String, String> GRAVITINO_CONFIG_TO_HIVE = ImmutableMap.of((Object)"metastore.uris", (Object)HiveConf.ConfVars.METASTOREURIS.varname);

    public void initialize(Map<String, String> conf, CatalogInfo info, HasPropertyMetadata propertiesMetadata) throws RuntimeException {
        this.info = info;
        this.propertiesMetadata = propertiesMetadata;
        HashMap byPassConfig = Maps.newHashMap();
        HashMap gravitinoConfig = Maps.newHashMap();
        conf.forEach((key, value) -> {
            if (key.startsWith("gravitino.bypass.")) {
                byPassConfig.put(key.substring("gravitino.bypass.".length()), value);
            } else if (GRAVITINO_CONFIG_TO_HIVE.containsKey(key)) {
                gravitinoConfig.put(GRAVITINO_CONFIG_TO_HIVE.get(key), value);
            }
        });
        HashMap mergeConfig = Maps.newHashMap((Map)byPassConfig);
        mergeConfig.putAll(gravitinoConfig);
        Configuration hadoopConf = new Configuration();
        mergeConfig.forEach((arg_0, arg_1) -> ((Configuration)hadoopConf).set(arg_0, arg_1));
        this.hiveConf = new HiveConf(hadoopConf, HiveCatalogOperations.class);
        this.initKerberosIfNecessary(conf, hadoopConf);
        this.clientPool = new CachedClientPool(this.getClientPoolSize(conf), (Configuration)this.hiveConf, this.getCacheEvictionInterval(conf));
        this.listAllTables = this.enableListAllTables(conf);
    }

    private void initKerberosIfNecessary(Map<String, String> conf, Configuration hadoopConf) {
        if (UserGroupInformation.AuthenticationMethod.KERBEROS == SecurityUtil.getAuthenticationMethod((Configuration)hadoopConf)) {
            try {
                Path keytabsPath = Paths.get("keytabs", new String[0]);
                if (!Files.exists(keytabsPath, new LinkOption[0])) {
                    Files.createDirectory(keytabsPath, new FileAttribute[0]);
                }
                Path keytabPath = Paths.get(String.format(GRAVITINO_KEYTAB_FORMAT, this.info.id()), new String[0]);
                keytabPath.toFile().deleteOnExit();
                if (Files.exists(keytabPath, new LinkOption[0])) {
                    try {
                        Files.delete(keytabPath);
                    }
                    catch (IOException e) {
                        throw new IllegalStateException(String.format("Fail to delete keytab file %s", keytabPath.toAbsolutePath()), e);
                    }
                }
                String keytabUri = (String)this.propertiesMetadata.catalogPropertiesMetadata().getOrDefault(conf, "kerberos.keytab-uri");
                Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)keytabUri), (Object)"Keytab uri can't be blank");
                Preconditions.checkArgument((!keytabUri.trim().startsWith("hdfs") ? 1 : 0) != 0, (Object)"Keytab uri doesn't support to use HDFS");
                int fetchKeytabFileTimeout = (Integer)this.propertiesMetadata.catalogPropertiesMetadata().getOrDefault(conf, "kerberos.keytab-fetch-timeout-sec");
                FetchFileUtils.fetchFileFromUri(keytabUri, keytabPath.toFile(), fetchKeytabFileTimeout, hadoopConf);
                this.hiveConf.setVar(HiveConf.ConfVars.METASTORE_KERBEROS_KEYTAB_FILE, keytabPath.toAbsolutePath().toString());
                String catalogPrincipal = (String)this.propertiesMetadata.catalogPropertiesMetadata().getOrDefault(conf, "kerberos.principal");
                Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)catalogPrincipal), (Object)"The principal can't be blank");
                List principalComponents = Splitter.on((char)'@').splitToList((CharSequence)catalogPrincipal);
                Preconditions.checkArgument((principalComponents.size() == 2 ? 1 : 0) != 0, (Object)"The principal has the wrong format");
                this.kerberosRealm = (String)principalComponents.get(1);
                this.checkTgtExecutor = new ScheduledThreadPoolExecutor(1, HiveCatalogOperations.getThreadFactory(String.format("Kerberos-check-%s", this.info.id())));
                LOG.info("krb5 path: {}", (Object)System.getProperty("java.security.krb5.conf"));
                this.refreshKerberosConfig();
                UserGroupInformation.setConfiguration((Configuration)hadoopConf);
                UserGroupInformation.loginUserFromKeytab((String)catalogPrincipal, (String)keytabPath.toAbsolutePath().toString());
                UserGroupInformation kerberosLoginUgi = UserGroupInformation.getCurrentUser();
                int checkInterval = (Integer)this.propertiesMetadata.catalogPropertiesMetadata().getOrDefault(conf, "kerberos.check-interval-sec");
                this.checkTgtExecutor.scheduleAtFixedRate(() -> {
                    try {
                        kerberosLoginUgi.checkTGTAndReloginFromKeytab();
                    }
                    catch (Exception e) {
                        LOG.error("Fail to refresh ugi token: ", (Throwable)e);
                    }
                }, checkInterval, checkInterval, TimeUnit.SECONDS);
            }
            catch (IOException ioe) {
                throw new UncheckedIOException(ioe);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    private void refreshKerberosConfig() {
        try {
            Class<?> classRef = System.getProperty("java.vendor").contains("IBM") ? Class.forName("com.ibm.security.krb5.internal.Config") : Class.forName("sun.security.krb5.Config");
            Method refershMethod = classRef.getMethod("refresh", new Class[0]);
            refershMethod.invoke(null, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @VisibleForTesting
    int getClientPoolSize(Map<String, String> conf) {
        return (Integer)this.propertiesMetadata.catalogPropertiesMetadata().getOrDefault(conf, "client.pool-size");
    }

    long getCacheEvictionInterval(Map<String, String> conf) {
        return (Long)this.propertiesMetadata.catalogPropertiesMetadata().getOrDefault(conf, "client.pool-cache.eviction-interval-ms");
    }

    boolean enableListAllTables(Map<String, String> conf) {
        return (Boolean)this.propertiesMetadata.catalogPropertiesMetadata().getOrDefault(conf, "list-all-tables");
    }

    public void close() {
        Path keytabPath;
        if (this.clientPool != null) {
            this.clientPool.close();
            this.clientPool = null;
        }
        if (this.checkTgtExecutor != null) {
            this.checkTgtExecutor.shutdown();
            this.checkTgtExecutor = null;
        }
        if (Files.exists(keytabPath = Paths.get(String.format(GRAVITINO_KEYTAB_FORMAT, this.info.id()), new String[0]), new LinkOption[0])) {
            try {
                Files.delete(keytabPath);
            }
            catch (IOException e) {
                LOG.error("Fail to delete key tab file {}", (Object)keytabPath.toAbsolutePath(), (Object)e);
            }
        }
    }

    public NameIdentifier[] listSchemas(Namespace namespace) throws NoSuchCatalogException {
        try {
            NameIdentifier[] schemas = (NameIdentifier[])this.clientPool.run(c -> (NameIdentifier[])c.getAllDatabases().stream().map(db -> NameIdentifier.of((Namespace)namespace, (String)db)).toArray(NameIdentifier[]::new));
            return schemas;
        }
        catch (TException e) {
            throw new RuntimeException("Failed to list all schemas (database) under namespace : " + namespace + " in Hive Metastore", e);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public HiveSchema createSchema(NameIdentifier ident, String comment, Map<String, String> properties) throws NoSuchCatalogException, SchemaAlreadyExistsException {
        try {
            HiveSchema hiveSchema = (HiveSchema)((HiveSchema.Builder)((HiveSchema.Builder)((HiveSchema.Builder)((HiveSchema.Builder)HiveSchema.builder().withName(ident.name())).withComment(comment)).withProperties(properties)).withConf((Configuration)this.hiveConf).withAuditInfo(AuditInfo.builder().withCreator(UserGroupInformation.getCurrentUser().getUserName()).withCreateTime(Instant.now()).build())).build();
            this.clientPool.run(client -> {
                client.createDatabase(hiveSchema.toHiveDB());
                return null;
            });
            LOG.info("Created Hive schema (database) {} in Hive Metastore", (Object)ident.name());
            return hiveSchema;
        }
        catch (AlreadyExistsException e) {
            throw new SchemaAlreadyExistsException((Throwable)e, "Hive schema (database) '%s' already exists in Hive Metastore", new Object[]{ident.name()});
        }
        catch (TException e) {
            throw new RuntimeException("Failed to create Hive schema (database) " + ident.name() + " in Hive Metastore", e);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public HiveSchema loadSchema(NameIdentifier ident) throws NoSuchSchemaException {
        try {
            Database database = (Database)this.clientPool.run(client -> client.getDatabase(ident.name()));
            HiveSchema hiveSchema = HiveSchema.fromHiveDB(database, (Configuration)this.hiveConf);
            LOG.info("Loaded Hive schema (database) {} from Hive Metastore ", (Object)ident.name());
            return hiveSchema;
        }
        catch (NoSuchObjectException | UnknownDBException e) {
            throw new NoSuchSchemaException(e, "Hive schema (database) does not exist: %s in Hive Metastore", new Object[]{ident.name()});
        }
        catch (TException e) {
            throw new RuntimeException("Failed to load Hive schema (database) " + ident.name() + " from Hive Metastore", e);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public HiveSchema alterSchema(NameIdentifier ident, SchemaChange ... changes) throws NoSuchSchemaException {
        try {
            Database database = (Database)this.clientPool.run(client -> client.getDatabase(ident.name()));
            Map<String, String> properties = HiveSchema.buildSchemaProperties(database);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Loaded properties for Hive schema (database) {} found {}", (Object)ident.name(), properties.keySet());
            }
            for (SchemaChange change : changes) {
                if (change instanceof SchemaChange.SetProperty) {
                    properties.put(((SchemaChange.SetProperty)change).getProperty(), ((SchemaChange.SetProperty)change).getValue());
                    continue;
                }
                if (change instanceof SchemaChange.RemoveProperty) {
                    properties.remove(((SchemaChange.RemoveProperty)change).getProperty());
                    continue;
                }
                throw new IllegalArgumentException("Unsupported schema change type: " + change.getClass().getSimpleName());
            }
            Database alteredDatabase = database.deepCopy();
            alteredDatabase.setParameters(properties);
            this.clientPool.run(client -> {
                client.alterDatabase(ident.name(), alteredDatabase);
                return null;
            });
            LOG.info("Altered Hive schema (database) {} in Hive Metastore", (Object)ident.name());
            return HiveSchema.fromHiveDB(alteredDatabase, (Configuration)this.hiveConf);
        }
        catch (NoSuchObjectException e) {
            throw new NoSuchSchemaException((Throwable)e, "Hive schema (database) %s does not exist in Hive Metastore", new Object[]{ident.name()});
        }
        catch (InterruptedException | TException e) {
            throw new RuntimeException("Failed to alter Hive schema (database) " + ident.name() + " in Hive metastore", e);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public boolean dropSchema(NameIdentifier ident, boolean cascade) throws NonEmptySchemaException {
        try {
            this.clientPool.run(client -> {
                client.dropDatabase(ident.name(), false, false, cascade);
                return null;
            });
            LOG.info("Dropped Hive schema (database) {}", (Object)ident.name());
            return true;
        }
        catch (InvalidOperationException e) {
            throw new NonEmptySchemaException((Throwable)e, "Hive schema (database) %s is not empty. One or more tables exist.", new Object[]{ident.name()});
        }
        catch (NoSuchObjectException e) {
            LOG.warn("Hive schema (database) {} does not exist in Hive Metastore", (Object)ident.name());
            return false;
        }
        catch (TException e) {
            throw new RuntimeException("Failed to drop Hive schema (database) " + ident.name() + " in Hive Metastore", e);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public NameIdentifier[] listTables(Namespace namespace) throws NoSuchSchemaException {
        NameIdentifier schemaIdent = NameIdentifier.of((String[])namespace.levels());
        if (!this.schemaExists(schemaIdent)) {
            throw new NoSuchSchemaException("Schema (database) does not exist %s", new Object[]{namespace});
        }
        try {
            List allTables = (List)this.clientPool.run(c -> c.getAllTables(schemaIdent.name()));
            return (NameIdentifier[])this.clientPool.run(c -> (NameIdentifier[])c.getTableObjectsByName(schemaIdent.name(), allTables).stream().filter(tb -> {
                boolean isSupportTable = HiveTable.SUPPORT_TABLE_TYPES.contains(tb.getTableType());
                if (!isSupportTable) {
                    return false;
                }
                if (!this.listAllTables) {
                    Map parameters = tb.getParameters();
                    return this.isHiveTable(parameters);
                }
                return true;
            }).map(tb -> NameIdentifier.of((Namespace)namespace, (String)tb.getTableName())).toArray(NameIdentifier[]::new));
        }
        catch (UnknownDBException e) {
            throw new NoSuchSchemaException("Schema (database) does not exist %s in Hive Metastore", new Object[]{namespace});
        }
        catch (TException e) {
            throw new RuntimeException("Failed to list all tables under the namespace : " + namespace + " in Hive Metastore", e);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    boolean isHiveTable(Map<String, String> tableParameters) {
        return !this.isIcebergTable(tableParameters);
    }

    boolean isIcebergTable(Map<String, String> tableParameters) {
        boolean isIcebergTable;
        return tableParameters != null && (isIcebergTable = "ICEBERG".equalsIgnoreCase(tableParameters.get("table_type")));
    }

    public org.apache.gravitino.rel.Table loadTable(NameIdentifier tableIdent) throws NoSuchTableException {
        Table table = this.loadHiveTable(tableIdent);
        HiveTable hiveTable = (HiveTable)((HiveTable.Builder)HiveTable.fromHiveTable(table).withProxyPlugin(this.proxyPlugin)).withClientPool(this.clientPool).build();
        LOG.info("Loaded Hive table {} from Hive Metastore ", (Object)tableIdent.name());
        return hiveTable;
    }

    private Table loadHiveTable(NameIdentifier tableIdent) {
        NameIdentifier schemaIdent = NameIdentifier.of((String[])tableIdent.namespace().levels());
        try {
            Table table = (Table)this.clientPool.run(c -> c.getTable(schemaIdent.name(), tableIdent.name()));
            return table;
        }
        catch (NoSuchObjectException e) {
            throw new NoSuchTableException((Throwable)e, "Hive table does not exist: %s in Hive Metastore", new Object[]{tableIdent.name()});
        }
        catch (InterruptedException | TException e) {
            throw new RuntimeException("Failed to load Hive table " + tableIdent.name() + " from Hive metastore", e);
        }
    }

    private void validatePartitionForCreate(Column[] columns, Transform[] partitioning) {
        int partitionStartIndex = columns.length - partitioning.length;
        for (int i = 0; i < partitioning.length; ++i) {
            Preconditions.checkArgument((boolean)(partitioning[i] instanceof Transforms.IdentityTransform), (Object)"Hive partition only supports identity transform");
            Transforms.IdentityTransform identity = (Transforms.IdentityTransform)partitioning[i];
            Preconditions.checkArgument((identity.fieldName().length == 1 ? 1 : 0) != 0, (Object)"Hive partition does not support nested field");
            Preconditions.checkArgument((boolean)columns[partitionStartIndex + i].name().equals(identity.fieldName()[0]), (Object)"The partition field must be placed at the end of the columns in order");
        }
    }

    private void validateColumnChangeForAlter(TableChange[] changes, Table hiveTable) {
        Set partitionFields = hiveTable.getPartitionKeys().stream().map(FieldSchema::getName).collect(Collectors.toSet());
        Set existingFields = hiveTable.getSd().getCols().stream().map(FieldSchema::getName).collect(Collectors.toSet());
        existingFields.addAll(partitionFields);
        Arrays.stream(changes).filter(c -> c instanceof TableChange.ColumnChange).forEach(c -> {
            String fieldName = String.join((CharSequence)".", ((TableChange.ColumnChange)c).fieldName());
            Preconditions.checkArgument((c instanceof TableChange.UpdateColumnComment || !partitionFields.contains(fieldName) ? 1 : 0) != 0, (Object)("Cannot alter partition column: " + fieldName));
            if (c instanceof TableChange.UpdateColumnPosition && this.afterPartitionColumn(partitionFields, ((TableChange.UpdateColumnPosition)c).getPosition())) {
                throw new IllegalArgumentException("Cannot alter column position to after partition column");
            }
            if (c instanceof TableChange.DeleteColumn) {
                existingFields.remove(fieldName);
            }
            if (c instanceof TableChange.AddColumn) {
                TableChange.AddColumn addColumn = (TableChange.AddColumn)c;
                if (existingFields.contains(fieldName)) {
                    throw new IllegalArgumentException("Cannot add column with duplicate name: " + fieldName);
                }
                if (addColumn.getPosition() == null) {
                    return;
                }
                if (this.afterPartitionColumn(partitionFields, addColumn.getPosition())) {
                    throw new IllegalArgumentException("Cannot add column after partition column");
                }
            }
        });
    }

    private boolean afterPartitionColumn(Set<String> partitionFields, TableChange.ColumnPosition columnPosition) {
        Preconditions.checkArgument((columnPosition != null ? 1 : 0) != 0, (Object)"Column position cannot be null");
        if (columnPosition instanceof TableChange.After) {
            return partitionFields.contains(((TableChange.After)columnPosition).getColumn());
        }
        return false;
    }

    private void validateDistributionAndSort(Distribution distribution, SortOrder[] sortOrder) {
        boolean allNameReference;
        if (distribution != Distributions.NONE) {
            allNameReference = Arrays.stream(distribution.expressions()).allMatch(t -> t instanceof NamedReference.FieldReference);
            Preconditions.checkArgument((boolean)allNameReference, (Object)"Hive distribution only supports field reference");
        }
        if (ArrayUtils.isNotEmpty((Object[])sortOrder)) {
            allNameReference = Arrays.stream(sortOrder).allMatch(t -> t.expression() instanceof NamedReference.FieldReference);
            Preconditions.checkArgument((boolean)allNameReference, (Object)"Hive sort order only supports name reference");
        }
    }

    public org.apache.gravitino.rel.Table createTable(NameIdentifier tableIdent, Column[] columns, String comment, Map<String, String> properties, Transform[] partitioning, Distribution distribution, SortOrder[] sortOrders, Index[] indexes) throws NoSuchSchemaException, TableAlreadyExistsException {
        Preconditions.checkArgument((indexes.length == 0 ? 1 : 0) != 0, (Object)"Hive-catalog does not support indexes, since indexing was removed since 3.0");
        NameIdentifier schemaIdent = NameIdentifier.of((String[])tableIdent.namespace().levels());
        this.validatePartitionForCreate(columns, partitioning);
        this.validateDistributionAndSort(distribution, sortOrders);
        TableType tableType = (TableType)this.propertiesMetadata.tablePropertiesMetadata().getOrDefault(properties, "table-type");
        Preconditions.checkArgument((boolean)HiveTable.SUPPORT_TABLE_TYPES.contains(tableType.name()), (Object)("Unsupported table type: " + tableType.name()));
        try {
            if (!this.schemaExists(schemaIdent)) {
                LOG.warn("Hive schema (database) does not exist: {}", (Object)schemaIdent);
                throw new NoSuchSchemaException("Hive Schema (database) does not exist: %s ", new Object[]{schemaIdent});
            }
            HiveTable hiveTable = (HiveTable)((HiveTable.Builder)((HiveTable.Builder)((HiveTable.Builder)((HiveTable.Builder)((HiveTable.Builder)((HiveTable.Builder)((HiveTable.Builder)((HiveTable.Builder)((HiveTable.Builder)HiveTable.builder().withName(tableIdent.name())).withSchemaName(schemaIdent.name()).withClientPool(this.clientPool).withComment(comment)).withColumns(columns)).withProperties(properties)).withDistribution(distribution)).withSortOrders(sortOrders)).withProxyPlugin(this.proxyPlugin)).withAuditInfo(AuditInfo.builder().withCreator(UserGroupInformation.getCurrentUser().getUserName()).withCreateTime(Instant.now()).build())).withPartitioning(partitioning)).build();
            this.clientPool.run(c -> {
                c.createTable(hiveTable.toHiveTable(this.propertiesMetadata.tablePropertiesMetadata()));
                return null;
            });
            LOG.info("Created Hive table {} in Hive Metastore", (Object)tableIdent.name());
            return hiveTable;
        }
        catch (AlreadyExistsException e) {
            throw new TableAlreadyExistsException((Throwable)e, "Table already exists: %s", new Object[]{tableIdent.name()});
        }
        catch (InterruptedException | TException e) {
            throw new RuntimeException("Failed to create Hive table " + tableIdent.name() + " in Hive Metastore", e);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public org.apache.gravitino.rel.Table alterTable(NameIdentifier tableIdent, TableChange ... changes) throws NoSuchTableException, IllegalArgumentException {
        NameIdentifier schemaIdent = NameIdentifier.of((String[])tableIdent.namespace().levels());
        try {
            HiveTable table = (HiveTable)this.loadTable(tableIdent);
            Table alteredHiveTable = table.toHiveTable(this.propertiesMetadata.tablePropertiesMetadata());
            this.validateColumnChangeForAlter(changes, alteredHiveTable);
            for (TableChange change : changes) {
                if (change instanceof TableChange.RenameTable) {
                    this.doRenameTable(alteredHiveTable, (TableChange.RenameTable)change);
                    continue;
                }
                if (change instanceof TableChange.UpdateComment) {
                    this.doUpdateComment(alteredHiveTable, (TableChange.UpdateComment)change);
                    continue;
                }
                if (change instanceof TableChange.SetProperty) {
                    this.doSetProperty(alteredHiveTable, (TableChange.SetProperty)change);
                    continue;
                }
                if (change instanceof TableChange.RemoveProperty) {
                    this.doRemoveProperty(alteredHiveTable, (TableChange.RemoveProperty)change);
                    continue;
                }
                if (change instanceof TableChange.ColumnChange) {
                    StorageDescriptor sd = alteredHiveTable.getSd();
                    List cols = sd.getCols();
                    if (change instanceof TableChange.AddColumn) {
                        TableChange.AddColumn addColumn = (TableChange.AddColumn)change;
                        this.doAddColumn(cols, addColumn);
                        continue;
                    }
                    if (change instanceof TableChange.DeleteColumn) {
                        this.doDeleteColumn(cols, (TableChange.DeleteColumn)change);
                        continue;
                    }
                    if (change instanceof TableChange.RenameColumn) {
                        this.doRenameColumn(cols, (TableChange.RenameColumn)change);
                        continue;
                    }
                    if (change instanceof TableChange.UpdateColumnComment) {
                        this.doUpdateColumnComment(cols, (TableChange.UpdateColumnComment)change);
                        continue;
                    }
                    if (change instanceof TableChange.UpdateColumnPosition) {
                        this.doUpdateColumnPosition(cols, (TableChange.UpdateColumnPosition)change);
                        continue;
                    }
                    if (change instanceof TableChange.UpdateColumnType) {
                        this.doUpdateColumnType(cols, (TableChange.UpdateColumnType)change);
                        continue;
                    }
                    if (change instanceof TableChange.UpdateColumnAutoIncrement) {
                        throw new IllegalArgumentException("Hive does not support altering column auto increment");
                    }
                    throw new IllegalArgumentException("Unsupported column change type: " + change.getClass().getSimpleName());
                }
                throw new IllegalArgumentException("Unsupported table change type: " + (change == null ? "null" : change.getClass().getSimpleName()));
            }
            this.clientPool.run(c -> {
                c.alter_table(schemaIdent.name(), tableIdent.name(), alteredHiveTable);
                return null;
            });
            LOG.info("Altered Hive table {} in Hive Metastore", (Object)tableIdent.name());
            return ((HiveTable.Builder)HiveTable.fromHiveTable(alteredHiveTable).withProxyPlugin(this.proxyPlugin)).withClientPool(this.clientPool).build();
        }
        catch (InterruptedException | TException e) {
            if (e.getMessage() != null && e.getMessage().contains("types incompatible with the existing columns")) {
                throw new IllegalArgumentException("Failed to alter Hive table [" + tableIdent.name() + "] in Hive metastore, since Hive metastore will check the compatibility of column type between the old and new column positions, please ensure that the type of the new column position is compatible with the old one, otherwise the alter operation will fail in Hive metastore.", e);
            }
            throw new RuntimeException("Failed to alter Hive table " + tableIdent.name() + " in Hive metastore", e);
        }
        catch (IllegalArgumentException | NoSuchTableException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private int columnPosition(List<FieldSchema> columns, TableChange.ColumnPosition position) {
        Preconditions.checkArgument((position != null ? 1 : 0) != 0, (Object)"Column position cannot be null");
        if (position instanceof TableChange.After) {
            String afterColumn = ((TableChange.After)position).getColumn();
            int indexOfColumn = this.indexOfColumn(columns, afterColumn);
            Preconditions.checkArgument((indexOfColumn != -1 ? 1 : 0) != 0, (Object)("Column does not exist: " + afterColumn));
            return indexOfColumn + 1;
        }
        if (position instanceof TableChange.First) {
            return 0;
        }
        throw new UnsupportedOperationException("Unsupported column position type: " + position.getClass().getSimpleName());
    }

    private int indexOfColumn(List<FieldSchema> columns, String fieldName) {
        return columns.stream().map(FieldSchema::getName).collect(Collectors.toList()).indexOf(fieldName);
    }

    private void doRenameTable(Table hiveTable, TableChange.RenameTable change) {
        hiveTable.setTableName(change.getNewName());
    }

    private void doUpdateComment(Table hiveTable, TableChange.UpdateComment change) {
        Map parameters = hiveTable.getParameters();
        parameters.put("comment", change.getNewComment());
    }

    private void doSetProperty(Table hiveTable, TableChange.SetProperty change) {
        Map parameters = hiveTable.getParameters();
        parameters.put(change.getProperty(), change.getValue());
    }

    private void doRemoveProperty(Table hiveTable, TableChange.RemoveProperty change) {
        Map parameters = hiveTable.getParameters();
        parameters.remove(change.getProperty());
    }

    private void doAddColumn(List<FieldSchema> cols, TableChange.AddColumn change) {
        int targetPosition;
        if (change.isAutoIncrement()) {
            throw new IllegalArgumentException("Hive catalog does not support auto-increment column");
        }
        if (change.getPosition() instanceof TableChange.Default) {
            targetPosition = cols.size();
            LOG.info("Hive catalog add column {} to the end of non-partition columns by default", (Object)change.fieldName()[0]);
        } else {
            targetPosition = this.columnPosition(cols, change.getPosition());
        }
        cols.add(targetPosition, new FieldSchema(change.fieldName()[0], HiveDataTypeConverter.CONVERTER.fromGravitino(change.getDataType()).getQualifiedName(), change.getComment()));
    }

    private void doDeleteColumn(List<FieldSchema> cols, TableChange.DeleteColumn change) {
        String columnName = change.fieldName()[0];
        if (!cols.removeIf(c -> c.getName().equals(columnName)) && !change.getIfExists().booleanValue()) {
            throw new IllegalArgumentException("DeleteColumn does not exist: " + columnName);
        }
    }

    private void doRenameColumn(List<FieldSchema> cols, TableChange.RenameColumn change) {
        String columnName = change.fieldName()[0];
        if (this.indexOfColumn(cols, columnName) == -1) {
            throw new IllegalArgumentException("RenameColumn does not exist: " + columnName);
        }
        String newName = change.getNewName();
        if (this.indexOfColumn(cols, newName) != -1) {
            throw new IllegalArgumentException("Column already exists: " + newName);
        }
        cols.get(this.indexOfColumn(cols, columnName)).setName(newName);
    }

    private void doUpdateColumnComment(List<FieldSchema> cols, TableChange.UpdateColumnComment change) {
        cols.get(this.indexOfColumn(cols, change.fieldName()[0])).setComment(change.getNewComment());
    }

    private void doUpdateColumnPosition(List<FieldSchema> cols, TableChange.UpdateColumnPosition change) {
        String columnName = change.fieldName()[0];
        int sourceIndex = this.indexOfColumn(cols, columnName);
        if (sourceIndex == -1) {
            throw new IllegalArgumentException("UpdateColumnPosition does not exist: " + columnName);
        }
        FieldSchema hiveColumn = cols.remove(sourceIndex);
        cols.add(this.columnPosition(cols, change.getPosition()), hiveColumn);
    }

    private void doUpdateColumnType(List<FieldSchema> cols, TableChange.UpdateColumnType change) {
        String columnName = change.fieldName()[0];
        int indexOfColumn = this.indexOfColumn(cols, columnName);
        if (indexOfColumn == -1) {
            throw new IllegalArgumentException("UpdateColumnType does not exist: " + columnName);
        }
        cols.get(indexOfColumn).setType(HiveDataTypeConverter.CONVERTER.fromGravitino(change.getNewDataType()).getQualifiedName());
    }

    public boolean dropTable(NameIdentifier tableIdent) {
        try {
            if (this.isExternalTable(tableIdent)) {
                return this.dropHiveTable(tableIdent, false, false);
            }
            return this.dropHiveTable(tableIdent, true, false);
        }
        catch (NoSuchTableException e) {
            return false;
        }
    }

    public boolean purgeTable(NameIdentifier tableIdent) throws UnsupportedOperationException {
        try {
            if (this.isExternalTable(tableIdent)) {
                throw new UnsupportedOperationException("Can't purge a external hive table");
            }
            return this.dropHiveTable(tableIdent, true, true);
        }
        catch (NoSuchTableException e) {
            return false;
        }
    }

    public void testConnection(NameIdentifier catalogIdent, Catalog.Type type, String provider, String comment, Map<String, String> properties) {
        try {
            this.clientPool.run(IMetaStoreClient::getAllDatabases);
        }
        catch (Exception e) {
            throw new ConnectionFailedException((Throwable)e, "Failed to run getAllDatabases in Hive Metastore: %s", new Object[]{e.getMessage()});
        }
    }

    private boolean dropHiveTable(NameIdentifier tableIdent, boolean deleteData, boolean ifPurge) {
        NameIdentifier schemaIdent = NameIdentifier.of((String[])tableIdent.namespace().levels());
        try {
            this.clientPool.run(c -> {
                c.dropTable(schemaIdent.name(), tableIdent.name(), deleteData, false, ifPurge);
                return null;
            });
            LOG.info("Dropped Hive table {}", (Object)tableIdent.name());
            return true;
        }
        catch (NoSuchObjectException e) {
            LOG.warn("Hive table {} does not exist in Hive Metastore", (Object)tableIdent.name());
            return false;
        }
        catch (InterruptedException | TException e) {
            throw new RuntimeException("Failed to drop Hive table " + tableIdent.name() + " in Hive Metastore", e);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    CachedClientPool getClientPool() {
        return this.clientPool;
    }

    HiveConf getHiveConf() {
        return this.hiveConf;
    }

    private boolean isExternalTable(NameIdentifier tableIdent) {
        Table hiveTable = this.loadHiveTable(tableIdent);
        return org.apache.hadoop.hive.metastore.TableType.EXTERNAL_TABLE.name().equalsIgnoreCase(hiveTable.getTableType());
    }

    private static ThreadFactory getThreadFactory(String factoryName) {
        return new ThreadFactoryBuilder().setDaemon(true).setNameFormat(factoryName + "-%d").build();
    }

    public String getKerberosRealm() {
        return this.kerberosRealm;
    }

    void setProxyPlugin(HiveProxyPlugin hiveProxyPlugin) {
        this.proxyPlugin = hiveProxyPlugin;
    }
}

