/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.catalog.hive;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.Scheduler;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.apache.gravitino.catalog.hive.HiveClientPool;
import org.apache.gravitino.catalog.hive.ImmutableConfElement;
import org.apache.gravitino.catalog.hive.ImmutableKey;
import org.apache.gravitino.utils.ClientPool;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.thrift.TException;
import org.immutables.value.Value;

public class CachedClientPool
implements ClientPool<IMetaStoreClient, TException> {
    private final Cache<Key, HiveClientPool> clientPoolCache;
    private final Configuration conf;
    private final int clientPoolSize;
    private final ScheduledThreadPoolExecutor scheduler;

    CachedClientPool(int clientPoolSize, Configuration conf, long evictionInterval) {
        this.conf = conf;
        this.clientPoolSize = clientPoolSize;
        this.scheduler = new ScheduledThreadPoolExecutor(1, CachedClientPool.newDaemonThreadFactory());
        this.clientPoolCache = Caffeine.newBuilder().expireAfterAccess(evictionInterval, TimeUnit.MILLISECONDS).removalListener((ignored, value, cause) -> ((HiveClientPool)((Object)((Object)value))).close()).scheduler(Scheduler.forScheduledExecutorService((ScheduledExecutorService)this.scheduler)).build();
    }

    @VisibleForTesting
    HiveClientPool clientPool() {
        Key key = CachedClientPool.extractKey();
        return (HiveClientPool)((Object)this.clientPoolCache.get((Object)key, k -> new HiveClientPool(this.clientPoolSize, this.conf)));
    }

    @VisibleForTesting
    Cache<Key, HiveClientPool> clientPoolCache() {
        return this.clientPoolCache;
    }

    public <R> R run(ClientPool.Action<R, IMetaStoreClient, TException> action) throws TException, InterruptedException {
        return (R)this.clientPool().run(action);
    }

    public <R> R run(ClientPool.Action<R, IMetaStoreClient, TException> action, boolean retry) throws TException, InterruptedException {
        return (R)this.clientPool().run(action, retry);
    }

    @VisibleForTesting
    static Key extractKey() {
        ArrayList elements = Lists.newArrayList();
        try {
            elements.add(UserGroupInformation.getCurrentUser().getUserName());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return Key.of(elements);
    }

    private static ThreadFactory newDaemonThreadFactory() {
        return new ThreadFactoryBuilder().setDaemon(true).setNameFormat("hive-metastore-cleaner-%d").build();
    }

    public void close() {
        this.clientPoolCache.asMap().forEach((key, value) -> value.close());
        this.clientPoolCache.invalidateAll();
        this.scheduler.shutdownNow();
    }

    @Value.Immutable
    static abstract class ConfElement {
        ConfElement() {
        }

        abstract String key();

        @Nullable
        abstract String value();

        static ConfElement of(String key, String value) {
            return ImmutableConfElement.builder().key(key).value(value).build();
        }
    }

    @Value.Immutable
    static abstract class Key {
        Key() {
        }

        abstract List<Object> elements();

        private static Key of(Iterable<?> elements) {
            return ImmutableKey.builder().elements(elements).build();
        }
    }
}

