/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.catalog.doris.converter;

import org.apache.gravitino.catalog.jdbc.converter.JdbcTypeConverter;
import org.apache.gravitino.rel.types.Type;
import org.apache.gravitino.rel.types.Types;

public class DorisTypeConverter
extends JdbcTypeConverter {
    static final String BOOLEAN = "boolean";
    static final String TINYINT = "tinyint";
    static final String SMALLINT = "smallint";
    static final String INT = "int";
    static final String BIGINT = "bigint";
    static final String FLOAT = "float";
    static final String DOUBLE = "double";
    static final String DECIMAL = "decimal";
    static final String DATETIME = "datetime";
    static final String CHAR = "char";
    static final String STRING = "string";

    public Type toGravitino(JdbcTypeConverter.JdbcTypeBean typeBean) {
        switch (typeBean.getTypeName().toLowerCase()) {
            case "boolean": {
                return Types.BooleanType.get();
            }
            case "tinyint": {
                return Types.ByteType.get();
            }
            case "smallint": {
                return Types.ShortType.get();
            }
            case "int": {
                return Types.IntegerType.get();
            }
            case "bigint": {
                return Types.LongType.get();
            }
            case "float": {
                return Types.FloatType.get();
            }
            case "double": {
                return Types.DoubleType.get();
            }
            case "decimal": {
                return Types.DecimalType.of((int)Integer.parseInt(typeBean.getColumnSize()), (int)Integer.parseInt(typeBean.getScale()));
            }
            case "date": {
                return Types.DateType.get();
            }
            case "datetime": {
                return Types.TimestampType.withTimeZone();
            }
            case "char": {
                return Types.FixedCharType.of((int)Integer.parseInt(typeBean.getColumnSize()));
            }
            case "varchar": {
                return Types.VarCharType.of((int)Integer.parseInt(typeBean.getColumnSize()));
            }
            case "string": 
            case "text": {
                return Types.StringType.get();
            }
        }
        return Types.ExternalType.of((String)typeBean.getTypeName());
    }

    public String fromGravitino(Type type) {
        if (type instanceof Types.BooleanType) {
            return BOOLEAN;
        }
        if (type instanceof Types.ByteType) {
            return TINYINT;
        }
        if (type instanceof Types.ShortType) {
            return SMALLINT;
        }
        if (type instanceof Types.IntegerType) {
            return INT;
        }
        if (type instanceof Types.LongType) {
            return BIGINT;
        }
        if (type instanceof Types.FloatType) {
            return FLOAT;
        }
        if (type instanceof Types.DoubleType) {
            return DOUBLE;
        }
        if (type instanceof Types.DecimalType) {
            return "decimal(" + ((Types.DecimalType)type).precision() + "," + ((Types.DecimalType)type).scale() + ")";
        }
        if (type instanceof Types.DateType) {
            return "date";
        }
        if (type instanceof Types.TimestampType) {
            return DATETIME;
        }
        if (type instanceof Types.VarCharType) {
            int length = ((Types.VarCharType)type).length();
            if (length < 1 || length > 65533) {
                throw new IllegalArgumentException(String.format("Type %s is invalid, length should be between 1 and 65533", type.simpleString()));
            }
            return "varchar(" + ((Types.VarCharType)type).length() + ")";
        }
        if (type instanceof Types.FixedCharType) {
            int length = ((Types.FixedCharType)type).length();
            if (length < 1 || length > 255) {
                throw new IllegalArgumentException(String.format("Type %s is invalid, length should be between 1 and 255", type.simpleString()));
            }
            return "char(" + ((Types.FixedCharType)type).length() + ")";
        }
        if (type instanceof Types.StringType) {
            return STRING;
        }
        throw new IllegalArgumentException(String.format("Couldn't convert Gravitino type %s to Doris type", type.simpleString()));
    }
}

