/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.utils;

import java.util.ArrayDeque;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ForkJoinPool;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.apache.paimon.shade.guava30.com.google.common.collect.Lists;
import org.apache.paimon.utils.FileUtils;

public class ScanParallelExecutor {
    public static <T, U> Iterable<T> parallelismBatchIterable(final Function<List<U>, List<T>> processor, List<U> input, @Nullable Integer queueSize) {
        ForkJoinPool poolCandidate = FileUtils.COMMON_IO_FORK_JOIN_POOL;
        if (queueSize == null) {
            queueSize = poolCandidate.getParallelism();
        } else if (queueSize <= 0) {
            throw new NegativeArraySizeException("queue size should not be negetive");
        }
        final ArrayDeque stack = new ArrayDeque(Lists.partition(input, (int)queueSize));
        final int settledQueueSize = queueSize;
        return () -> new Iterator<T>(){
            private int index = 0;
            List activeList = null;

            @Override
            public boolean hasNext() {
                this.advanceIfNeeded();
                return this.activeList != null && this.index < this.activeList.size();
            }

            @Override
            public T next() {
                this.advanceIfNeeded();
                if (this.activeList == null || this.index >= this.activeList.size()) {
                    throw new NoSuchElementException();
                }
                return this.activeList.get(this.index++);
            }

            private void advanceIfNeeded() {
                while ((this.activeList == null || this.index >= this.activeList.size()) && stack.size() > 0) {
                    this.index = 0;
                    try {
                        this.activeList = CompletableFuture.supplyAsync(() -> (List)processor.apply(stack.poll()), ScanParallelExecutor.getExecutePool(settledQueueSize)).get();
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        };
    }

    public static ForkJoinPool getExecutePool(@Nullable Integer queueSize) {
        if (queueSize == null) {
            return FileUtils.COMMON_IO_FORK_JOIN_POOL;
        }
        return queueSize > FileUtils.COMMON_IO_FORK_JOIN_POOL.getParallelism() ? FileUtils.getScanIoForkJoinPool(queueSize) : FileUtils.COMMON_IO_FORK_JOIN_POOL;
    }
}

