/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.sort;

import java.io.Closeable;
import java.io.File;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.paimon.disk.FileIOChannel;
import org.apache.paimon.utils.Preconditions;

public class SpillChannelManager
implements Closeable {
    private final HashSet<FileIOChannel.ID> channels = new HashSet(64);
    private final HashSet<FileIOChannel> openChannels = new HashSet(64);
    private volatile boolean closed;

    public synchronized void addChannel(FileIOChannel.ID id) {
        Preconditions.checkArgument((!this.closed ? 1 : 0) != 0);
        this.channels.add(id);
    }

    public synchronized void addOpenChannels(List<FileIOChannel> toOpen) {
        Preconditions.checkArgument((!this.closed ? 1 : 0) != 0);
        for (FileIOChannel channel : toOpen) {
            this.openChannels.add(channel);
            this.channels.remove(channel.getChannelID());
        }
    }

    public synchronized void removeChannel(FileIOChannel.ID id) {
        Preconditions.checkArgument((!this.closed ? 1 : 0) != 0);
        this.channels.remove(id);
    }

    @Override
    public synchronized void close() {
        Object channel;
        if (this.closed) {
            return;
        }
        this.closed = true;
        Iterator<Object> channels = this.openChannels.iterator();
        while (channels.hasNext()) {
            channel = channels.next();
            channels.remove();
            try {
                channel.closeAndDelete();
            }
            catch (Throwable throwable) {}
        }
        channels = this.channels.iterator();
        while (channels.hasNext()) {
            channel = (FileIOChannel.ID)channels.next();
            channels.remove();
            try {
                File f = new File(((FileIOChannel.ID)channel).getPath());
                if (!f.exists()) continue;
                f.delete();
            }
            catch (Throwable throwable) {}
        }
    }
}

