/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.manifest;

import java.io.IOException;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.paimon.CoreOptions;
import org.apache.paimon.annotation.VisibleForTesting;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.format.FileFormat;
import org.apache.paimon.format.FormatReaderFactory;
import org.apache.paimon.format.FormatWriterFactory;
import org.apache.paimon.format.TableStatsCollector;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.fs.Path;
import org.apache.paimon.io.RollingFileWriter;
import org.apache.paimon.io.SingleFileWriter;
import org.apache.paimon.manifest.ManifestEntry;
import org.apache.paimon.manifest.ManifestEntrySerializer;
import org.apache.paimon.manifest.ManifestFileMeta;
import org.apache.paimon.manifest.SimpleFileEntry;
import org.apache.paimon.manifest.SimpleFileEntrySerializer;
import org.apache.paimon.schema.SchemaManager;
import org.apache.paimon.stats.FieldStatsArraySerializer;
import org.apache.paimon.types.RowType;
import org.apache.paimon.utils.FileStorePathFactory;
import org.apache.paimon.utils.ObjectsFile;
import org.apache.paimon.utils.PathFactory;
import org.apache.paimon.utils.SegmentsCache;
import org.apache.paimon.utils.VersionedObjectSerializer;

public class ManifestFile
extends ObjectsFile<ManifestEntry> {
    private final SchemaManager schemaManager;
    private final RowType partitionType;
    private final FormatWriterFactory writerFactory;
    private final long suggestedFileSize;

    private ManifestFile(FileIO fileIO, SchemaManager schemaManager, RowType partitionType, ManifestEntrySerializer serializer, FormatReaderFactory readerFactory, FormatWriterFactory writerFactory, PathFactory pathFactory, long suggestedFileSize, @Nullable SegmentsCache<String> cache) {
        super(fileIO, serializer, readerFactory, writerFactory, pathFactory, cache);
        this.schemaManager = schemaManager;
        this.partitionType = partitionType;
        this.writerFactory = writerFactory;
        this.suggestedFileSize = suggestedFileSize;
    }

    @VisibleForTesting
    public long suggestedFileSize() {
        return this.suggestedFileSize;
    }

    public List<ManifestFileMeta> write(List<ManifestEntry> entries) {
        RollingFileWriter<ManifestEntry, ManifestFileMeta> writer = this.createRollingWriter();
        try {
            writer.write((ManifestEntry)((Object)entries));
            writer.close();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return writer.result();
    }

    public RollingFileWriter<ManifestEntry, ManifestFileMeta> createRollingWriter() {
        return new RollingFileWriter<ManifestEntry, ManifestFileMeta>(() -> new ManifestEntryWriter(this.writerFactory, this.pathFactory.newPath(), (String)CoreOptions.FILE_COMPRESSION.defaultValue()), this.suggestedFileSize);
    }

    public static class Factory {
        private final FileIO fileIO;
        private final SchemaManager schemaManager;
        private final RowType partitionType;
        private final FileFormat fileFormat;
        private final FileStorePathFactory pathFactory;
        private final long suggestedFileSize;
        @Nullable
        private final SegmentsCache<String> cache;

        public Factory(FileIO fileIO, SchemaManager schemaManager, RowType partitionType, FileFormat fileFormat, FileStorePathFactory pathFactory, long suggestedFileSize, @Nullable SegmentsCache<String> cache) {
            this.fileIO = fileIO;
            this.schemaManager = schemaManager;
            this.partitionType = partitionType;
            this.fileFormat = fileFormat;
            this.pathFactory = pathFactory;
            this.suggestedFileSize = suggestedFileSize;
            this.cache = cache;
        }

        public ManifestFile create() {
            RowType entryType = VersionedObjectSerializer.versionType(ManifestEntry.schema());
            return new ManifestFile(this.fileIO, this.schemaManager, this.partitionType, new ManifestEntrySerializer(), this.fileFormat.createReaderFactory(entryType), this.fileFormat.createWriterFactory(entryType), this.pathFactory.manifestFileFactory(), this.suggestedFileSize, this.cache);
        }

        public ObjectsFile<SimpleFileEntry> createSimpleFileEntryReader() {
            RowType entryType = VersionedObjectSerializer.versionType(ManifestEntry.schema());
            return new ObjectsFile<SimpleFileEntry>(this.fileIO, new SimpleFileEntrySerializer(), this.fileFormat.createReaderFactory(entryType), this.fileFormat.createWriterFactory(entryType), this.pathFactory.manifestFileFactory(), this.cache);
        }
    }

    private class ManifestEntryWriter
    extends SingleFileWriter<ManifestEntry, ManifestFileMeta> {
        private final TableStatsCollector partitionStatsCollector;
        private final FieldStatsArraySerializer partitionStatsSerializer;
        private long numAddedFiles;
        private long numDeletedFiles;
        private long schemaId;

        ManifestEntryWriter(FormatWriterFactory factory, Path path, String fileCompression) {
            super(ManifestFile.this.fileIO, factory, path, ManifestFile.this.serializer::toRow, fileCompression);
            this.numAddedFiles = 0L;
            this.numDeletedFiles = 0L;
            this.schemaId = Long.MIN_VALUE;
            this.partitionStatsCollector = new TableStatsCollector(ManifestFile.this.partitionType);
            this.partitionStatsSerializer = new FieldStatsArraySerializer(ManifestFile.this.partitionType);
        }

        @Override
        public void write(ManifestEntry entry) throws IOException {
            super.write(entry);
            switch (entry.kind()) {
                case ADD: {
                    ++this.numAddedFiles;
                    break;
                }
                case DELETE: {
                    ++this.numDeletedFiles;
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unknown entry kind: " + (Object)((Object)entry.kind()));
                }
            }
            this.schemaId = Math.max(this.schemaId, entry.file().schemaId());
            this.partitionStatsCollector.collect((InternalRow)entry.partition());
        }

        @Override
        public ManifestFileMeta result() throws IOException {
            return new ManifestFileMeta(this.path.getName(), this.fileIO.getFileSize(this.path), this.numAddedFiles, this.numDeletedFiles, this.partitionStatsSerializer.toBinary(this.partitionStatsCollector.extract()), this.numAddedFiles + this.numDeletedFiles > 0L ? this.schemaId : ManifestFile.this.schemaManager.latest().get().id());
        }
    }
}

