/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.casting;

import java.math.BigDecimal;
import org.apache.paimon.casting.AbstractCastRule;
import org.apache.paimon.casting.CastExecutor;
import org.apache.paimon.casting.CastRulePredicate;
import org.apache.paimon.data.BinaryString;
import org.apache.paimon.data.Decimal;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.DataTypeFamily;
import org.apache.paimon.types.DataTypeRoot;
import org.apache.paimon.types.DecimalType;

class StringToDecimalCastRule
extends AbstractCastRule<BinaryString, Decimal> {
    static final StringToDecimalCastRule INSTANCE = new StringToDecimalCastRule();

    private StringToDecimalCastRule() {
        super(CastRulePredicate.builder().input(DataTypeFamily.CHARACTER_STRING).target(DataTypeRoot.DECIMAL).build());
    }

    @Override
    public CastExecutor<BinaryString, Decimal> create(DataType inputType, DataType targetType) {
        DecimalType decimalType = (DecimalType)targetType;
        return value -> Decimal.fromBigDecimal((BigDecimal)new BigDecimal(value.toString()), (int)decimalType.getPrecision(), (int)decimalType.getScale());
    }
}

