/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.catalog.lakehouse.iceberg.converter;

import com.google.common.base.Preconditions;
import java.util.Locale;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.gravitino.rel.expressions.Expression;
import org.apache.gravitino.rel.expressions.FunctionExpression;
import org.apache.gravitino.rel.expressions.NamedReference;
import org.apache.gravitino.rel.expressions.literals.Literal;
import org.apache.gravitino.rel.expressions.sorts.NullOrdering;
import org.apache.gravitino.rel.expressions.sorts.SortDirection;
import org.apache.gravitino.rel.types.Types;
import org.apache.iceberg.NullOrder;
import org.apache.iceberg.Schema;
import org.apache.iceberg.SortOrder;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.expressions.Term;
import org.apache.iceberg.expressions.UnboundTerm;

public class ToIcebergSortOrder {
    private static final String DOT = ".";

    private ToIcebergSortOrder() {
    }

    public static SortOrder toSortOrder(Schema schema, org.apache.gravitino.rel.expressions.sorts.SortOrder[] sortOrders) {
        if (ArrayUtils.isEmpty((Object[])sortOrders)) {
            return null;
        }
        SortOrder.Builder sortOrderBuilder = SortOrder.builderFor((Schema)schema);
        for (org.apache.gravitino.rel.expressions.sorts.SortOrder sortOrder : sortOrders) {
            if (sortOrder.expression() instanceof NamedReference.FieldReference) {
                String fieldName = String.join((CharSequence)DOT, ((NamedReference.FieldReference)sortOrder.expression()).fieldName());
                sortOrderBuilder.sortBy(fieldName, ToIcebergSortOrder.toIceberg(sortOrder.direction()), ToIcebergSortOrder.toIceberg(sortOrder.nullOrdering()));
                continue;
            }
            if (sortOrder.expression() instanceof FunctionExpression) {
                UnboundTerm icebergExpression;
                FunctionExpression sortFunc = (FunctionExpression)sortOrder.expression();
                switch (sortFunc.functionName().toLowerCase(Locale.ROOT)) {
                    case "bucket": {
                        Preconditions.checkArgument((sortFunc.arguments().length == 2 ? 1 : 0) != 0, (Object)"Bucket sort should have 2 arguments");
                        Expression firstArg = sortFunc.arguments()[0];
                        Preconditions.checkArgument((firstArg instanceof Literal && ((Literal)firstArg).dataType() instanceof Types.IntegerType ? 1 : 0) != 0, (Object)"Bucket sort's first argument must be a integer literal");
                        int numBuckets = Integer.parseInt(String.valueOf(((Literal)firstArg).value()));
                        Expression secondArg = sortFunc.arguments()[1];
                        Preconditions.checkArgument((boolean)(secondArg instanceof NamedReference.FieldReference), (Object)"Bucket sort's second argument must be a field reference");
                        String fieldName = String.join((CharSequence)DOT, ((NamedReference.FieldReference)secondArg).fieldName());
                        icebergExpression = Expressions.bucket((String)fieldName, (int)numBuckets);
                        break;
                    }
                    case "truncate": {
                        Preconditions.checkArgument((sortFunc.arguments().length == 2 ? 1 : 0) != 0, (Object)"Truncate sort should have 2 arguments");
                        Expression firstArg = sortFunc.arguments()[0];
                        Preconditions.checkArgument((firstArg instanceof Literal && ((Literal)firstArg).dataType() instanceof Types.IntegerType ? 1 : 0) != 0, (Object)"Truncate sort's first argument must be a integer literal");
                        int width = Integer.parseInt(String.valueOf(((Literal)firstArg).value()));
                        Expression secondArg = sortFunc.arguments()[1];
                        Preconditions.checkArgument((boolean)(secondArg instanceof NamedReference.FieldReference), (Object)"Truncate sort's second argument must be a field reference");
                        String fieldName = String.join((CharSequence)DOT, ((NamedReference.FieldReference)secondArg).fieldName());
                        icebergExpression = Expressions.truncate((String)fieldName, (int)width);
                        break;
                    }
                    case "year": {
                        icebergExpression = Expressions.year((String)ToIcebergSortOrder.getValidSingleField("year", sortFunc.arguments()));
                        break;
                    }
                    case "month": {
                        icebergExpression = Expressions.month((String)ToIcebergSortOrder.getValidSingleField("month", sortFunc.arguments()));
                        break;
                    }
                    case "day": {
                        icebergExpression = Expressions.day((String)ToIcebergSortOrder.getValidSingleField("day", sortFunc.arguments()));
                        break;
                    }
                    case "hour": {
                        icebergExpression = Expressions.hour((String)ToIcebergSortOrder.getValidSingleField("hour", sortFunc.arguments()));
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException("Sort function is not supported: " + sortFunc.functionName());
                    }
                }
                sortOrderBuilder.sortBy((Term)icebergExpression, ToIcebergSortOrder.toIceberg(sortOrder.direction()), ToIcebergSortOrder.toIceberg(sortOrder.nullOrdering()));
                continue;
            }
            throw new UnsupportedOperationException("Sort expression is not supported: " + sortOrder.expression());
        }
        return sortOrderBuilder.build();
    }

    private static String getValidSingleField(String functionName, Expression[] arguments) {
        Preconditions.checkArgument((arguments.length == 1 ? 1 : 0) != 0, (String)"Sort function %s should have 1 argument, but got %s", (Object)functionName, (int)arguments.length);
        Expression argument = arguments[0];
        Preconditions.checkArgument((boolean)(argument instanceof NamedReference.FieldReference), (String)"Sort function %s's argument should be a field reference, but got %s", (Object)functionName, (Object)argument);
        NamedReference.FieldReference fieldReference = (NamedReference.FieldReference)argument;
        return String.join((CharSequence)DOT, fieldReference.fieldName());
    }

    private static NullOrder toIceberg(NullOrdering nullOrdering) {
        return nullOrdering == NullOrdering.NULLS_FIRST ? NullOrder.NULLS_FIRST : NullOrder.NULLS_LAST;
    }

    private static org.apache.iceberg.SortDirection toIceberg(SortDirection direction) {
        return direction == SortDirection.ASCENDING ? org.apache.iceberg.SortDirection.ASC : org.apache.iceberg.SortDirection.DESC;
    }
}

