/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.catalog.lakehouse.iceberg;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.gravitino.Catalog;
import org.apache.gravitino.NameIdentifier;
import org.apache.gravitino.Namespace;
import org.apache.gravitino.SchemaChange;
import org.apache.gravitino.catalog.lakehouse.iceberg.IcebergCatalogPropertiesMetadata;
import org.apache.gravitino.catalog.lakehouse.iceberg.IcebergColumn;
import org.apache.gravitino.catalog.lakehouse.iceberg.IcebergSchema;
import org.apache.gravitino.catalog.lakehouse.iceberg.IcebergTable;
import org.apache.gravitino.catalog.lakehouse.iceberg.ops.IcebergTableOpsHelper;
import org.apache.gravitino.connector.CatalogInfo;
import org.apache.gravitino.connector.CatalogOperations;
import org.apache.gravitino.connector.HasPropertyMetadata;
import org.apache.gravitino.connector.SupportsSchemas;
import org.apache.gravitino.exceptions.ConnectionFailedException;
import org.apache.gravitino.exceptions.NoSuchCatalogException;
import org.apache.gravitino.exceptions.NoSuchSchemaException;
import org.apache.gravitino.exceptions.NoSuchTableException;
import org.apache.gravitino.exceptions.NonEmptySchemaException;
import org.apache.gravitino.exceptions.SchemaAlreadyExistsException;
import org.apache.gravitino.exceptions.TableAlreadyExistsException;
import org.apache.gravitino.iceberg.common.IcebergConfig;
import org.apache.gravitino.iceberg.common.ops.IcebergTableOps;
import org.apache.gravitino.meta.AuditInfo;
import org.apache.gravitino.rel.Column;
import org.apache.gravitino.rel.Table;
import org.apache.gravitino.rel.TableCatalog;
import org.apache.gravitino.rel.TableChange;
import org.apache.gravitino.rel.expressions.distributions.Distribution;
import org.apache.gravitino.rel.expressions.sorts.SortOrder;
import org.apache.gravitino.rel.expressions.transforms.Transform;
import org.apache.gravitino.rel.indexes.Index;
import org.apache.gravitino.utils.MapUtils;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.exceptions.AlreadyExistsException;
import org.apache.iceberg.exceptions.NamespaceNotEmptyException;
import org.apache.iceberg.exceptions.NoSuchNamespaceException;
import org.apache.iceberg.rest.requests.RenameTableRequest;
import org.apache.iceberg.rest.requests.UpdateNamespacePropertiesRequest;
import org.apache.iceberg.rest.responses.GetNamespaceResponse;
import org.apache.iceberg.rest.responses.ListTablesResponse;
import org.apache.iceberg.rest.responses.LoadTableResponse;
import org.apache.iceberg.rest.responses.UpdateNamespacePropertiesResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IcebergCatalogOperations
implements CatalogOperations,
SupportsSchemas,
TableCatalog {
    private static final String ICEBERG_TABLE_DOES_NOT_EXIST_MSG = "Iceberg table does not exist: %s";
    public static final Logger LOG = LoggerFactory.getLogger(IcebergCatalogOperations.class);
    @VisibleForTesting
    IcebergTableOps icebergTableOps;
    private IcebergTableOpsHelper icebergTableOpsHelper;

    public void initialize(Map<String, String> conf, CatalogInfo info, HasPropertyMetadata propertiesMetadata) throws RuntimeException {
        Map prefixMap = MapUtils.getPrefixMap(conf, (String)"gravitino.bypass.");
        Map<String, String> gravitinoConfig = ((IcebergCatalogPropertiesMetadata)propertiesMetadata.catalogPropertiesMetadata()).transformProperties(conf);
        HashMap resultConf = Maps.newHashMap((Map)prefixMap);
        resultConf.putAll(gravitinoConfig);
        resultConf.put("catalog_uuid", info.id().toString());
        IcebergConfig icebergConfig = new IcebergConfig((Map)resultConf);
        this.icebergTableOps = new IcebergTableOps(icebergConfig);
        this.icebergTableOpsHelper = new IcebergTableOpsHelper(this.icebergTableOps.getCatalog());
    }

    public void close() {
        if (null != this.icebergTableOps) {
            try {
                this.icebergTableOps.close();
            }
            catch (Exception e) {
                LOG.warn("Failed to close Iceberg catalog", (Throwable)e);
            }
        }
    }

    public NameIdentifier[] listSchemas(Namespace namespace) throws NoSuchCatalogException {
        try {
            List namespaces = this.icebergTableOps.listNamespace(IcebergTableOpsHelper.getIcebergNamespace(new String[0])).namespaces();
            return (NameIdentifier[])namespaces.stream().map(icebergNamespace -> NameIdentifier.of((Namespace)namespace, (String)icebergNamespace.toString())).toArray(NameIdentifier[]::new);
        }
        catch (NoSuchNamespaceException e) {
            throw new NoSuchSchemaException((Throwable)e, "Failed to list all schemas (database) under namespace : %s in Iceberg", new Object[]{namespace});
        }
    }

    public IcebergSchema createSchema(NameIdentifier ident, String comment, Map<String, String> properties) throws NoSuchCatalogException, SchemaAlreadyExistsException {
        try {
            String currentUser = IcebergCatalogOperations.currentUser();
            IcebergSchema createdSchema = (IcebergSchema)((IcebergSchema.Builder)((IcebergSchema.Builder)((IcebergSchema.Builder)((IcebergSchema.Builder)IcebergSchema.builder().withName(ident.name())).withComment(comment)).withProperties(properties)).withAuditInfo(AuditInfo.builder().withCreator(currentUser).withCreateTime(Instant.now()).build())).build();
            this.icebergTableOps.createNamespace(createdSchema.toCreateRequest(IcebergTableOpsHelper.getIcebergNamespace(ident.name())));
            LOG.info("Created Iceberg schema (database) {} in Iceberg\ncurrentUser:{} \ncomment: {} \nmetadata: {}", new Object[]{ident.name(), currentUser, comment, properties});
            return createdSchema;
        }
        catch (AlreadyExistsException e) {
            throw new SchemaAlreadyExistsException((Throwable)e, "Iceberg schema (database) '%s' already exists", new Object[]{ident.name()});
        }
        catch (NoSuchNamespaceException e) {
            throw new NoSuchSchemaException((Throwable)e, "Iceberg schema (database) does not exist: %s in Gravitino store, This scenario occurs after the creation is completed and reloaded", new Object[]{ident.name()});
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public IcebergSchema loadSchema(NameIdentifier ident) throws NoSuchSchemaException {
        try {
            GetNamespaceResponse response = this.icebergTableOps.loadNamespace(IcebergTableOpsHelper.getIcebergNamespace(ident.name()));
            IcebergSchema icebergSchema = (IcebergSchema)((IcebergSchema.Builder)((IcebergSchema.Builder)((IcebergSchema.Builder)((IcebergSchema.Builder)IcebergSchema.builder().withName(ident.name())).withComment(Optional.of(response).map(GetNamespaceResponse::properties).map(map -> (String)map.get("comment")).orElse(null))).withProperties(response.properties())).withAuditInfo(AuditInfo.EMPTY)).build();
            LOG.info("Loaded Iceberg schema (database) {} from Iceberg ", (Object)ident.name());
            return icebergSchema;
        }
        catch (NoSuchNamespaceException e) {
            throw new NoSuchSchemaException((Throwable)e, "Iceberg schema (database) does not exist: %s in Gravitino store", new Object[]{ident.name()});
        }
    }

    public IcebergSchema alterSchema(NameIdentifier ident, SchemaChange ... changes) throws NoSuchSchemaException {
        try {
            GetNamespaceResponse response = this.icebergTableOps.loadNamespace(IcebergTableOpsHelper.getIcebergNamespace(ident.name()));
            Map metadata = response.properties();
            ArrayList<String> removals = new ArrayList<String>();
            HashMap<String, String> updates = new HashMap<String, String>();
            HashMap<String, String> resultProperties = new HashMap<String, String>(metadata);
            for (SchemaChange change : changes) {
                if (change instanceof SchemaChange.SetProperty) {
                    String key = ((SchemaChange.SetProperty)change).getProperty();
                    String val = ((SchemaChange.SetProperty)change).getValue();
                    updates.put(key, val);
                    resultProperties.put(key, val);
                    continue;
                }
                if (change instanceof SchemaChange.RemoveProperty) {
                    removals.add(((SchemaChange.RemoveProperty)change).getProperty());
                    resultProperties.remove(((SchemaChange.RemoveProperty)change).getProperty());
                    continue;
                }
                throw new IllegalArgumentException("Unsupported schema change type: " + change.getClass().getSimpleName());
            }
            String comment = Optional.of(response.properties()).map(map -> (String)map.get("comment")).orElse(null);
            IcebergSchema icebergSchema = (IcebergSchema)((IcebergSchema.Builder)((IcebergSchema.Builder)((IcebergSchema.Builder)((IcebergSchema.Builder)IcebergSchema.builder().withName(ident.name())).withComment(comment)).withAuditInfo(AuditInfo.EMPTY)).withProperties(resultProperties)).build();
            UpdateNamespacePropertiesRequest updateNamespacePropertiesRequest = UpdateNamespacePropertiesRequest.builder().updateAll(updates).removeAll(removals).build();
            UpdateNamespacePropertiesResponse updateNamespacePropertiesResponse = this.icebergTableOps.updateNamespaceProperties(IcebergTableOpsHelper.getIcebergNamespace(ident.name()), updateNamespacePropertiesRequest);
            LOG.info("Altered Iceberg schema (database) {}. UpdateResponse:\n{}", (Object)ident.name(), (Object)updateNamespacePropertiesResponse);
            return icebergSchema;
        }
        catch (NoSuchNamespaceException e) {
            throw new NoSuchSchemaException((Throwable)e, "Iceberg schema (database) %s does not exist", new Object[]{ident.name()});
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public boolean dropSchema(NameIdentifier ident, boolean cascade) throws NonEmptySchemaException {
        Preconditions.checkArgument((!cascade ? 1 : 0) != 0, (Object)"Iceberg does not support cascading delete operations.");
        try {
            this.icebergTableOps.dropNamespace(IcebergTableOpsHelper.getIcebergNamespace(ident.name()));
            LOG.info("Dropped Iceberg schema (database) {}", (Object)ident.name());
            return true;
        }
        catch (NamespaceNotEmptyException e) {
            throw new NonEmptySchemaException((Throwable)e, "Iceberg schema (database) %s is not empty. One or more tables exist.", new Object[]{ident.name()});
        }
        catch (NoSuchNamespaceException e) {
            LOG.warn("Iceberg schema (database) {} does not exist", (Object)ident.name());
            return false;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public NameIdentifier[] listTables(Namespace namespace) throws NoSuchSchemaException {
        NameIdentifier schemaIdent = NameIdentifier.of((String[])namespace.levels());
        if (!this.schemaExists(schemaIdent)) {
            throw new NoSuchSchemaException("Schema (database) does not exist %s", new Object[]{namespace});
        }
        try {
            ListTablesResponse listTablesResponse = this.icebergTableOps.listTable(IcebergTableOpsHelper.getIcebergNamespace(namespace));
            return (NameIdentifier[])listTablesResponse.identifiers().stream().map(tableIdentifier -> NameIdentifier.of((String[])((String[])ArrayUtils.add((Object[])namespace.levels(), (Object)tableIdentifier.name())))).toArray(NameIdentifier[]::new);
        }
        catch (NoSuchNamespaceException e) {
            throw new NoSuchSchemaException("Schema (database) does not exist %s in Iceberg", new Object[]{namespace});
        }
    }

    public Table loadTable(NameIdentifier tableIdent) throws NoSuchTableException {
        try {
            LoadTableResponse tableResponse = this.icebergTableOps.loadTable(IcebergTableOpsHelper.buildIcebergTableIdentifier(tableIdent));
            IcebergTable icebergTable = IcebergTable.fromIcebergTable(tableResponse.tableMetadata(), tableIdent.name());
            LOG.info("Loaded Iceberg table {}", (Object)tableIdent.name());
            return icebergTable;
        }
        catch (org.apache.iceberg.exceptions.NoSuchTableException e) {
            throw new NoSuchTableException((Throwable)e, ICEBERG_TABLE_DOES_NOT_EXIST_MSG, new Object[]{tableIdent.name()});
        }
    }

    public Table alterTable(NameIdentifier tableIdent, TableChange ... changes) throws NoSuchTableException, IllegalArgumentException {
        Optional<TableChange> renameTableOptional = Arrays.stream(changes).filter(tableChange -> tableChange instanceof TableChange.RenameTable).reduce((a, b) -> b);
        if (renameTableOptional.isPresent()) {
            String otherChange = Arrays.stream(changes).filter(tableChange -> !(tableChange instanceof TableChange.RenameTable)).map(String::valueOf).collect(Collectors.joining("\n"));
            Preconditions.checkArgument((boolean)StringUtils.isEmpty((CharSequence)otherChange), (Object)String.format("The operation to change the table name cannot be performed together with other operations.The list of operations that you cannot perform includes: \n %s", otherChange));
            return this.renameTable(tableIdent, (TableChange.RenameTable)renameTableOptional.get());
        }
        return this.internalUpdateTable(tableIdent, changes);
    }

    private Table internalUpdateTable(NameIdentifier tableIdent, TableChange ... changes) throws NoSuchTableException, IllegalArgumentException {
        try {
            String[] levels = tableIdent.namespace().levels();
            IcebergTableOps.IcebergTableChange icebergTableChange = this.icebergTableOpsHelper.buildIcebergTableChanges(NameIdentifier.of((String[])new String[]{levels[levels.length - 1], tableIdent.name()}), changes);
            LoadTableResponse loadTableResponse = this.icebergTableOps.updateTable(icebergTableChange);
            loadTableResponse.validate();
            return IcebergTable.fromIcebergTable(loadTableResponse.tableMetadata(), tableIdent.name());
        }
        catch (org.apache.iceberg.exceptions.NoSuchTableException e) {
            throw new NoSuchTableException((Throwable)e, ICEBERG_TABLE_DOES_NOT_EXIST_MSG, new Object[]{tableIdent.name()});
        }
    }

    private Table renameTable(NameIdentifier tableIdent, TableChange.RenameTable renameTable) throws NoSuchTableException, IllegalArgumentException {
        try {
            RenameTableRequest renameTableRequest = RenameTableRequest.builder().withSource(IcebergTableOpsHelper.buildIcebergTableIdentifier(tableIdent)).withDestination(IcebergTableOpsHelper.buildIcebergTableIdentifier(tableIdent.namespace(), renameTable.getNewName())).build();
            this.icebergTableOps.renameTable(renameTableRequest);
            return this.loadTable(NameIdentifier.of((Namespace)tableIdent.namespace(), (String)renameTable.getNewName()));
        }
        catch (org.apache.iceberg.exceptions.NoSuchTableException e) {
            throw new NoSuchTableException((Throwable)e, ICEBERG_TABLE_DOES_NOT_EXIST_MSG, new Object[]{tableIdent.name()});
        }
    }

    public boolean dropTable(NameIdentifier tableIdent) {
        try {
            this.icebergTableOps.dropTable(IcebergTableOpsHelper.buildIcebergTableIdentifier(tableIdent));
            LOG.info("Dropped Iceberg table {}", (Object)tableIdent.name());
            return true;
        }
        catch (org.apache.iceberg.exceptions.NoSuchTableException e) {
            LOG.warn("Iceberg table {} does not exist", (Object)tableIdent.name());
            return false;
        }
    }

    public Table createTable(NameIdentifier tableIdent, Column[] columns, String comment, Map<String, String> properties, Transform[] partitioning, Distribution distribution, SortOrder[] sortOrders, Index[] indexes) throws NoSuchSchemaException, TableAlreadyExistsException {
        Preconditions.checkArgument((indexes.length == 0 ? 1 : 0) != 0, (Object)"Iceberg-catalog does not support indexes");
        try {
            NameIdentifier schemaIdent = NameIdentifier.of((String[])tableIdent.namespace().levels());
            if (!this.schemaExists(schemaIdent)) {
                LOG.warn("Iceberg schema (database) does not exist: {}", (Object)schemaIdent);
                throw new NoSuchSchemaException("Iceberg Schema (database) does not exist %s", new Object[]{schemaIdent});
            }
            IcebergColumn[] icebergColumns = (IcebergColumn[])Arrays.stream(columns).map(column -> (IcebergColumn)((IcebergColumn.Builder)((IcebergColumn.Builder)((IcebergColumn.Builder)((IcebergColumn.Builder)IcebergColumn.builder().withName(column.name())).withType(column.dataType())).withComment(column.comment())).withNullable(column.nullable())).build()).toArray(IcebergColumn[]::new);
            IcebergTable createdTable = (IcebergTable)((IcebergTable.Builder)((IcebergTable.Builder)((IcebergTable.Builder)((IcebergTable.Builder)((IcebergTable.Builder)((IcebergTable.Builder)((IcebergTable.Builder)((IcebergTable.Builder)IcebergTable.builder().withName(tableIdent.name())).withColumns((Column[])icebergColumns)).withComment(comment)).withPartitioning(partitioning)).withSortOrders(sortOrders)).withProperties(properties)).withDistribution(distribution)).withAuditInfo(AuditInfo.builder().withCreator(IcebergCatalogOperations.currentUser()).withCreateTime(Instant.now()).build())).build();
            LoadTableResponse loadTableResponse = this.icebergTableOps.createTable(IcebergTableOpsHelper.getIcebergNamespace(schemaIdent.name()), createdTable.toCreateTableRequest());
            loadTableResponse.validate();
            LOG.info("Created Iceberg table {}", (Object)tableIdent.name());
            return createdTable;
        }
        catch (AlreadyExistsException e) {
            throw new TableAlreadyExistsException((Throwable)e, "Table already exists: %s", new Object[]{tableIdent.name()});
        }
    }

    public boolean purgeTable(NameIdentifier tableIdent) throws UnsupportedOperationException {
        try {
            String schema = NameIdentifier.of((String[])tableIdent.namespace().levels()).name();
            this.icebergTableOps.purgeTable(TableIdentifier.of((String[])new String[]{schema, tableIdent.name()}));
            LOG.info("Purge Iceberg table {}", (Object)tableIdent.name());
            return true;
        }
        catch (org.apache.iceberg.exceptions.NoSuchTableException e) {
            LOG.warn("Iceberg table {} does not exist", (Object)tableIdent.name());
            return false;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void testConnection(NameIdentifier catalogIdent, Catalog.Type type, String provider, String comment, Map<String, String> properties) {
        try {
            this.icebergTableOps.listNamespace(IcebergTableOpsHelper.getIcebergNamespace(new String[0]));
        }
        catch (Exception e) {
            throw new ConnectionFailedException((Throwable)e, "Failed to run listNamespace on Iceberg catalog: %s", new Object[]{e.getMessage()});
        }
    }

    private static String currentUser() {
        return System.getProperty("user.name");
    }
}

