/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.catalog.hadoop.authentication;

import java.io.File;
import java.io.IOException;
import java.util.Locale;
import java.util.Map;
import org.apache.gravitino.catalog.hadoop.authentication.UserContext;
import org.apache.gravitino.catalog.hadoop.authentication.kerberos.KerberosClient;
import org.apache.gravitino.utils.PrincipalUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KerberosUserContext
extends UserContext {
    public static final Logger LOGGER = LoggerFactory.getLogger(KerberosUserContext.class);
    private UserGroupInformation userGroupInformation;
    private boolean enableUserImpersonation;
    private String kerberosRealm;
    private final String keytab;
    private KerberosClient kerberosClient;

    KerberosUserContext(boolean enableUserImpersonation, String keytabPath) {
        this.enableUserImpersonation = enableUserImpersonation;
        this.keytab = keytabPath;
    }

    public void setEnableUserImpersonation(boolean enableUserImpersonation) {
        this.enableUserImpersonation = enableUserImpersonation;
    }

    public synchronized void initKerberos(Map<String, String> properties, Configuration configuration, boolean refreshCredentials) {
        configuration.set("hadoop.security.authentication", UserGroupInformation.AuthenticationMethod.KERBEROS.name().toLowerCase(Locale.ROOT));
        try {
            KerberosClient client;
            UserGroupInformation.setConfiguration((Configuration)configuration);
            this.kerberosClient = client = new KerberosClient(properties, configuration, refreshCredentials);
            File keytabFile = client.saveKeyTabFileFromUri(this.keytab);
            this.kerberosRealm = client.login(keytabFile.getAbsolutePath());
            this.userGroupInformation = UserGroupInformation.getLoginUser();
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to login with Kerberos", e);
        }
    }

    @Override
    UserGroupInformation createProxyUser() {
        String proxyKerberosPrincipalName = PrincipalUtils.getCurrentUserName();
        if (!proxyKerberosPrincipalName.contains("@")) {
            proxyKerberosPrincipalName = String.format("%s@%s", proxyKerberosPrincipalName, this.kerberosRealm);
        }
        return UserGroupInformation.createProxyUser((String)proxyKerberosPrincipalName, (UserGroupInformation)this.getUser());
    }

    @Override
    UserGroupInformation getUser() {
        return this.userGroupInformation;
    }

    @Override
    boolean enableUserImpersonation() {
        return this.enableUserImpersonation;
    }

    @Override
    public void close() throws IOException {
        boolean isDeleted;
        if (this.kerberosClient != null) {
            this.kerberosClient.close();
        }
        if (this.keytab == null) {
            return;
        }
        File file = new File(this.keytab);
        if (file.exists() && !(isDeleted = file.delete())) {
            LOGGER.error("Failed to delete file: {}", (Object)this.keytab);
        }
    }

    public KerberosUserContext deepCopy() {
        KerberosUserContext copy = new KerberosUserContext(this.enableUserImpersonation, this.keytab);
        copy.userGroupInformation = this.userGroupInformation;
        copy.kerberosRealm = this.kerberosRealm;
        return copy;
    }
}

