/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.catalog.hadoop;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.Principal;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import javax.security.auth.Subject;
import org.apache.gravitino.Catalog;
import org.apache.gravitino.Entity;
import org.apache.gravitino.EntityStore;
import org.apache.gravitino.NameIdentifier;
import org.apache.gravitino.Namespace;
import org.apache.gravitino.Schema;
import org.apache.gravitino.SchemaChange;
import org.apache.gravitino.UserPrincipal;
import org.apache.gravitino.catalog.hadoop.HadoopCatalogOperations;
import org.apache.gravitino.catalog.hadoop.authentication.UserContext;
import org.apache.gravitino.connector.CatalogInfo;
import org.apache.gravitino.connector.CatalogOperations;
import org.apache.gravitino.connector.HasPropertyMetadata;
import org.apache.gravitino.connector.SupportsSchemas;
import org.apache.gravitino.exceptions.FilesetAlreadyExistsException;
import org.apache.gravitino.exceptions.NoSuchCatalogException;
import org.apache.gravitino.exceptions.NoSuchEntityException;
import org.apache.gravitino.exceptions.NoSuchFilesetException;
import org.apache.gravitino.exceptions.NoSuchSchemaException;
import org.apache.gravitino.exceptions.NonEmptySchemaException;
import org.apache.gravitino.exceptions.SchemaAlreadyExistsException;
import org.apache.gravitino.file.Fileset;
import org.apache.gravitino.file.FilesetCatalog;
import org.apache.gravitino.file.FilesetChange;
import org.apache.gravitino.meta.FilesetEntity;
import org.apache.gravitino.meta.SchemaEntity;
import org.apache.gravitino.utils.PrincipalUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecureHadoopCatalogOperations
implements CatalogOperations,
SupportsSchemas,
FilesetCatalog {
    public static final Logger LOG = LoggerFactory.getLogger(SecureHadoopCatalogOperations.class);
    private final HadoopCatalogOperations hadoopCatalogOperations;
    public static final String GRAVITINO_KEYTAB_FORMAT = "keytabs/gravitino-%s";
    private UserContext catalogUserContext;

    public SecureHadoopCatalogOperations() {
        this.hadoopCatalogOperations = new HadoopCatalogOperations();
    }

    public SecureHadoopCatalogOperations(EntityStore store) {
        this.hadoopCatalogOperations = new HadoopCatalogOperations(store);
    }

    @VisibleForTesting
    public HadoopCatalogOperations getBaseHadoopCatalogOperations() {
        return this.hadoopCatalogOperations;
    }

    public Fileset createFileset(NameIdentifier ident, String comment, Fileset.Type type, String storageLocation, Map<String, String> properties) throws NoSuchSchemaException, FilesetAlreadyExistsException {
        String apiUser = PrincipalUtils.getCurrentUserName();
        UserContext userContext = UserContext.getUserContext(ident, properties, null, this.hadoopCatalogOperations.getCatalogInfo());
        return userContext.doAs(() -> {
            this.setUser(apiUser);
            return this.hadoopCatalogOperations.createFileset(ident, comment, type, storageLocation, properties);
        }, ident);
    }

    public boolean dropFileset(NameIdentifier ident) {
        FilesetEntity filesetEntity;
        try {
            filesetEntity = (FilesetEntity)this.hadoopCatalogOperations.getStore().get(ident, Entity.EntityType.FILESET, FilesetEntity.class);
        }
        catch (NoSuchEntityException e) {
            LOG.warn("Fileset {} does not exist", (Object)ident);
            return false;
        }
        catch (IOException ioe) {
            throw new RuntimeException("Failed to delete fileset " + ident, ioe);
        }
        UserContext userContext = UserContext.getUserContext(ident, filesetEntity.properties(), null, this.hadoopCatalogOperations.getCatalogInfo());
        boolean r = userContext.doAs(() -> this.hadoopCatalogOperations.dropFileset(ident), ident);
        UserContext.clearUserContext(ident);
        return r;
    }

    public Schema createSchema(NameIdentifier ident, String comment, Map<String, String> properties) throws NoSuchCatalogException, SchemaAlreadyExistsException {
        String apiUser = PrincipalUtils.getCurrentUserName();
        UserContext userContext = UserContext.getUserContext(ident, properties, null, this.hadoopCatalogOperations.getCatalogInfo());
        return userContext.doAs(() -> {
            this.setUser(apiUser);
            return this.hadoopCatalogOperations.createSchema(ident, comment, properties);
        }, ident);
    }

    public boolean dropSchema(NameIdentifier ident, boolean cascade) throws NonEmptySchemaException {
        try {
            SchemaEntity schemaEntity = (SchemaEntity)this.hadoopCatalogOperations.getStore().get(ident, Entity.EntityType.SCHEMA, SchemaEntity.class);
            Map<String, String> properties = Optional.ofNullable(schemaEntity.properties()).orElse(Collections.emptyMap());
            UserContext userContext = UserContext.getUserContext(ident, properties, null, this.hadoopCatalogOperations.getCatalogInfo());
            boolean r = userContext.doAs(() -> this.hadoopCatalogOperations.dropSchema(ident, cascade), ident);
            UserContext.clearUserContext(ident);
            return r;
        }
        catch (IOException ioe) {
            throw new RuntimeException("Failed to delete schema " + ident, ioe);
        }
    }

    public void initialize(Map<String, String> config, CatalogInfo info, HasPropertyMetadata propertiesMetadata) throws RuntimeException {
        this.hadoopCatalogOperations.initialize(config, info, propertiesMetadata);
        this.catalogUserContext = UserContext.getUserContext(NameIdentifier.of((Namespace)info.namespace(), (String)info.name()), config, this.hadoopCatalogOperations.getHadoopConf(), info);
    }

    public Fileset alterFileset(NameIdentifier ident, FilesetChange ... changes) throws NoSuchFilesetException, IllegalArgumentException {
        Fileset fileset = this.hadoopCatalogOperations.alterFileset(ident, changes);
        String finalName = ident.name();
        for (FilesetChange change : changes) {
            if (!(change instanceof FilesetChange.RenameFileset)) continue;
            finalName = ((FilesetChange.RenameFileset)change).getNewName();
        }
        if (!ident.name().equals(finalName)) {
            UserContext.clearUserContext(NameIdentifier.of((Namespace)ident.namespace(), (String)finalName));
        }
        return fileset;
    }

    public NameIdentifier[] listSchemas(Namespace namespace) throws NoSuchCatalogException {
        return this.hadoopCatalogOperations.listSchemas(namespace);
    }

    public Schema loadSchema(NameIdentifier ident) throws NoSuchSchemaException {
        return this.hadoopCatalogOperations.loadSchema(ident);
    }

    public Schema alterSchema(NameIdentifier ident, SchemaChange ... changes) throws NoSuchSchemaException {
        return this.hadoopCatalogOperations.alterSchema(ident, changes);
    }

    public NameIdentifier[] listFilesets(Namespace namespace) throws NoSuchSchemaException {
        return this.hadoopCatalogOperations.listFilesets(namespace);
    }

    public Fileset loadFileset(NameIdentifier ident) throws NoSuchFilesetException {
        return this.hadoopCatalogOperations.loadFileset(ident);
    }

    public void close() throws IOException {
        this.hadoopCatalogOperations.close();
        this.catalogUserContext.close();
        UserContext.cleanAllUserContext();
    }

    public void testConnection(NameIdentifier catalogIdent, Catalog.Type type, String provider, String comment, Map<String, String> properties) throws Exception {
        this.hadoopCatalogOperations.testConnection(catalogIdent, type, provider, comment, properties);
    }

    private void setUser(String apiUser) {
        AccessControlContext context = AccessController.getContext();
        Subject subject = Subject.getSubject(context);
        subject.getPrincipals().add((Principal)new UserPrincipal(apiUser));
    }
}

