/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jsqlparser.statement.update;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.OracleHint;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.StatementVisitor;
import net.sf.jsqlparser.statement.select.FromItem;
import net.sf.jsqlparser.statement.select.Join;
import net.sf.jsqlparser.statement.select.Limit;
import net.sf.jsqlparser.statement.select.OrderByElement;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.select.SelectExpressionItem;
import net.sf.jsqlparser.statement.select.SubSelect;
import net.sf.jsqlparser.statement.select.WithItem;
import net.sf.jsqlparser.statement.update.UpdateSet;

public class Update
implements Statement {
    private List<WithItem> withItemsList;
    private Table table;
    private Expression where;
    private final ArrayList<UpdateSet> updateSets = new ArrayList();
    private FromItem fromItem;
    private List<Join> joins;
    private List<Join> startJoins;
    private OracleHint oracleHint = null;
    private List<OrderByElement> orderByElements;
    private Limit limit;
    private boolean returningAllColumns = false;
    private List<SelectExpressionItem> returningExpressionList = null;

    public ArrayList<UpdateSet> getUpdateSets() {
        return this.updateSets;
    }

    @Override
    public void accept(StatementVisitor statementVisitor) {
        statementVisitor.visit(this);
    }

    public List<WithItem> getWithItemsList() {
        return this.withItemsList;
    }

    public void setWithItemsList(List<WithItem> withItemsList) {
        this.withItemsList = withItemsList;
    }

    public Update withWithItemsList(List<WithItem> withItemsList) {
        this.setWithItemsList(withItemsList);
        return this;
    }

    public Update addWithItemsList(WithItem ... withItemsList) {
        List collection = Optional.ofNullable(this.getWithItemsList()).orElseGet(ArrayList::new);
        Collections.addAll(collection, withItemsList);
        return this.withWithItemsList(collection);
    }

    public Update addWithItemsList(Collection<? extends WithItem> withItemsList) {
        List collection = Optional.ofNullable(this.getWithItemsList()).orElseGet(ArrayList::new);
        collection.addAll(withItemsList);
        return this.withWithItemsList(collection);
    }

    public Table getTable() {
        return this.table;
    }

    public Expression getWhere() {
        return this.where;
    }

    public void setTable(Table table) {
        this.table = table;
    }

    public void setWhere(Expression expression) {
        this.where = expression;
    }

    public OracleHint getOracleHint() {
        return this.oracleHint;
    }

    public void setOracleHint(OracleHint oracleHint) {
        this.oracleHint = oracleHint;
    }

    public void addUpdateSet(Column column, Expression expression) {
        this.updateSets.add(new UpdateSet(column, expression));
    }

    public void addUpdateSet(UpdateSet updateSet) {
        this.updateSets.add(updateSet);
    }

    @Deprecated
    public List<Column> getColumns() {
        return this.updateSets.get((int)0).columns;
    }

    @Deprecated
    public List<Expression> getExpressions() {
        return this.updateSets.get((int)0).expressions;
    }

    @Deprecated
    public void setColumns(List<Column> list) {
        if (this.updateSets.isEmpty()) {
            this.updateSets.add(new UpdateSet());
        }
        this.updateSets.get((int)0).columns.clear();
        this.updateSets.get((int)0).columns.addAll(list);
    }

    @Deprecated
    public void setExpressions(List<Expression> list) {
        this.updateSets.get((int)0).expressions.clear();
        this.updateSets.get((int)0).expressions.addAll(list);
    }

    public FromItem getFromItem() {
        return this.fromItem;
    }

    public void setFromItem(FromItem fromItem) {
        this.fromItem = fromItem;
    }

    public List<Join> getJoins() {
        return this.joins;
    }

    public void setJoins(List<Join> joins) {
        this.joins = joins;
    }

    public List<Join> getStartJoins() {
        return this.startJoins;
    }

    public void setStartJoins(List<Join> startJoins) {
        this.startJoins = startJoins;
    }

    @Deprecated
    public Select getSelect() {
        Select select = null;
        if (this.updateSets.get((int)0).expressions.get(0) instanceof SubSelect) {
            SubSelect subSelect = (SubSelect)this.updateSets.get((int)0).expressions.get(0);
            select = new Select().withWithItemsList(subSelect.getWithItemsList()).withSelectBody(subSelect.getSelectBody());
        }
        return select;
    }

    @Deprecated
    public void setSelect(Select select) {
        if (select != null) {
            SubSelect subSelect = new SubSelect().withSelectBody(select.getSelectBody());
            if (select.getWithItemsList() != null && select.getWithItemsList().size() > 0) {
                subSelect.setWithItemsList(select.getWithItemsList());
            }
            if (this.updateSets.get((int)0).expressions.isEmpty()) {
                this.updateSets.get((int)0).expressions.add(subSelect);
            } else {
                this.updateSets.get((int)0).expressions.set(0, subSelect);
            }
        }
    }

    @Deprecated
    public boolean isUseColumnsBrackets() {
        return this.updateSets.get((int)0).usingBracketsForColumns;
    }

    @Deprecated
    public void setUseColumnsBrackets(boolean useColumnsBrackets) {
        this.updateSets.get((int)0).usingBracketsForColumns = useColumnsBrackets;
    }

    @Deprecated
    public boolean isUseSelect() {
        return this.updateSets.get((int)0).expressions.get(0) instanceof SubSelect;
    }

    @Deprecated
    public void setUseSelect(boolean useSelect) {
    }

    public void setOrderByElements(List<OrderByElement> orderByElements) {
        this.orderByElements = orderByElements;
    }

    public void setLimit(Limit limit) {
        this.limit = limit;
    }

    public List<OrderByElement> getOrderByElements() {
        return this.orderByElements;
    }

    public Limit getLimit() {
        return this.limit;
    }

    public boolean isReturningAllColumns() {
        return this.returningAllColumns;
    }

    public void setReturningAllColumns(boolean returningAllColumns) {
        this.returningAllColumns = returningAllColumns;
    }

    public List<SelectExpressionItem> getReturningExpressionList() {
        return this.returningExpressionList;
    }

    public void setReturningExpressionList(List<SelectExpressionItem> returningExpressionList) {
        this.returningExpressionList = returningExpressionList;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        if (this.withItemsList != null && !this.withItemsList.isEmpty()) {
            b.append("WITH ");
            Iterator<Object> iter = this.withItemsList.iterator();
            while (iter.hasNext()) {
                WithItem withItem = iter.next();
                b.append(withItem);
                if (iter.hasNext()) {
                    b.append(",");
                }
                b.append(" ");
            }
        }
        b.append("UPDATE ");
        b.append(this.table);
        if (this.startJoins != null) {
            for (Join join : this.startJoins) {
                if (join.isSimple()) {
                    b.append(", ").append(join);
                    continue;
                }
                b.append(" ").append(join);
            }
        }
        b.append(" SET ");
        int j = 0;
        for (UpdateSet updateSet : this.updateSets) {
            int i;
            if (j > 0) {
                b.append(", ");
            }
            if (updateSet.usingBracketsForColumns) {
                b.append("(");
            }
            for (i = 0; i < updateSet.columns.size(); ++i) {
                if (i > 0) {
                    b.append(", ");
                }
                b.append(updateSet.columns.get(i));
            }
            if (updateSet.usingBracketsForColumns) {
                b.append(")");
            }
            b.append(" = ");
            if (updateSet.usingBracketsForValues) {
                b.append("(");
            }
            for (i = 0; i < updateSet.expressions.size(); ++i) {
                if (i > 0) {
                    b.append(", ");
                }
                b.append(updateSet.expressions.get(i));
            }
            if (updateSet.usingBracketsForValues) {
                b.append(")");
            }
            ++j;
        }
        if (this.fromItem != null) {
            b.append(" FROM ").append(this.fromItem);
            if (this.joins != null) {
                for (Join join : this.joins) {
                    if (join.isSimple()) {
                        b.append(", ").append(join);
                        continue;
                    }
                    b.append(" ").append(join);
                }
            }
        }
        if (this.where != null) {
            b.append(" WHERE ");
            b.append(this.where);
        }
        if (this.orderByElements != null) {
            b.append(PlainSelect.orderByToString(this.orderByElements));
        }
        if (this.limit != null) {
            b.append(this.limit);
        }
        if (this.isReturningAllColumns()) {
            b.append(" RETURNING *");
        } else if (this.getReturningExpressionList() != null) {
            b.append(" RETURNING ").append(PlainSelect.getStringList(this.getReturningExpressionList(), true, false));
        }
        return b.toString();
    }

    public Update withTable(Table table) {
        this.setTable(table);
        return this;
    }

    public Update withFromItem(FromItem fromItem) {
        this.setFromItem(fromItem);
        return this;
    }

    public Update withJoins(List<Join> joins) {
        this.setJoins(joins);
        return this;
    }

    public Update withStartJoins(List<Join> startJoins) {
        this.setStartJoins(startJoins);
        return this;
    }

    public Update withSelect(Select select) {
        this.setSelect(select);
        return this;
    }

    public Update withUseColumnsBrackets(boolean useColumnsBrackets) {
        this.setUseColumnsBrackets(useColumnsBrackets);
        return this;
    }

    public Update withUseSelect(boolean useSelect) {
        this.setUseSelect(useSelect);
        return this;
    }

    public Update withOrderByElements(List<OrderByElement> orderByElements) {
        this.setOrderByElements(orderByElements);
        return this;
    }

    public Update withLimit(Limit limit) {
        this.setLimit(limit);
        return this;
    }

    public Update withReturningAllColumns(boolean returningAllColumns) {
        this.setReturningAllColumns(returningAllColumns);
        return this;
    }

    public Update withReturningExpressionList(List<SelectExpressionItem> returningExpressionList) {
        this.setReturningExpressionList(returningExpressionList);
        return this;
    }

    public Update withWhere(Expression where) {
        this.setWhere(where);
        return this;
    }

    public Update withColumns(List<Column> columns) {
        this.setColumns(columns);
        return this;
    }

    public Update withExpressions(List<Expression> expressions) {
        this.setExpressions(expressions);
        return this;
    }

    public Update addColumns(Column ... columns) {
        List collection = Optional.ofNullable(this.getColumns()).orElseGet(ArrayList::new);
        Collections.addAll(collection, columns);
        return this.withColumns(collection);
    }

    public Update addColumns(Collection<? extends Column> columns) {
        List collection = Optional.ofNullable(this.getColumns()).orElseGet(ArrayList::new);
        collection.addAll(columns);
        return this.withColumns(collection);
    }

    public Update addExpressions(Expression ... expressions) {
        List collection = Optional.ofNullable(this.getExpressions()).orElseGet(ArrayList::new);
        Collections.addAll(collection, expressions);
        return this.withExpressions(collection);
    }

    public Update addExpressions(Collection<? extends Expression> expressions) {
        List collection = Optional.ofNullable(this.getExpressions()).orElseGet(ArrayList::new);
        collection.addAll(expressions);
        return this.withExpressions(collection);
    }

    public Update addJoins(Join ... joins) {
        List collection = Optional.ofNullable(this.getJoins()).orElseGet(ArrayList::new);
        Collections.addAll(collection, joins);
        return this.withJoins(collection);
    }

    public Update addJoins(Collection<? extends Join> joins) {
        List collection = Optional.ofNullable(this.getJoins()).orElseGet(ArrayList::new);
        collection.addAll(joins);
        return this.withJoins(collection);
    }

    public Update addStartJoins(Join ... startJoins) {
        List collection = Optional.ofNullable(this.getStartJoins()).orElseGet(ArrayList::new);
        Collections.addAll(collection, startJoins);
        return this.withStartJoins(collection);
    }

    public Update addStartJoins(Collection<? extends Join> startJoins) {
        List collection = Optional.ofNullable(this.getStartJoins()).orElseGet(ArrayList::new);
        collection.addAll(startJoins);
        return this.withStartJoins(collection);
    }

    public Update addOrderByElements(OrderByElement ... orderByElements) {
        List collection = Optional.ofNullable(this.getOrderByElements()).orElseGet(ArrayList::new);
        Collections.addAll(collection, orderByElements);
        return this.withOrderByElements(collection);
    }

    public Update addOrderByElements(Collection<? extends OrderByElement> orderByElements) {
        List collection = Optional.ofNullable(this.getOrderByElements()).orElseGet(ArrayList::new);
        collection.addAll(orderByElements);
        return this.withOrderByElements(collection);
    }

    public Update addReturningExpressionList(SelectExpressionItem ... returningExpressionList) {
        List collection = Optional.ofNullable(this.getReturningExpressionList()).orElseGet(ArrayList::new);
        Collections.addAll(collection, returningExpressionList);
        return this.withReturningExpressionList(collection);
    }

    public Update addReturningExpressionList(Collection<? extends SelectExpressionItem> returningExpressionList) {
        List collection = Optional.ofNullable(this.getReturningExpressionList()).orElseGet(ArrayList::new);
        collection.addAll(returningExpressionList);
        return this.withReturningExpressionList(collection);
    }

    public <E extends Expression> E getWhere(Class<E> type) {
        return (E)((Expression)type.cast(this.getWhere()));
    }

    public <E extends FromItem> E getFromItem(Class<E> type) {
        return (E)((FromItem)type.cast(this.getFromItem()));
    }
}

