/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.storage.relational.mapper.provider.base;

import org.apache.gravitino.storage.relational.po.TablePO;
import org.apache.ibatis.annotations.Param;

public class TableMetaBaseSQLProvider {
    public String listTablePOsBySchemaId(@Param(value="schemaId") Long schemaId) {
        return "SELECT table_id as tableId, table_name as tableName, metalake_id as metalakeId, catalog_id as catalogId, schema_id as schemaId, audit_info as auditInfo, current_version as currentVersion, last_version as lastVersion, deleted_at as deletedAt FROM table_meta WHERE schema_id = #{schemaId} AND deleted_at = 0";
    }

    public String selectTableIdBySchemaIdAndName(@Param(value="schemaId") Long schemaId, @Param(value="tableName") String name) {
        return "SELECT table_id as tableId FROM table_meta WHERE schema_id = #{schemaId} AND table_name = #{tableName} AND deleted_at = 0";
    }

    public String selectTableMetaBySchemaIdAndName(@Param(value="schemaId") Long schemaId, @Param(value="tableName") String name) {
        return "SELECT table_id as tableId, table_name as tableName, metalake_id as metalakeId, catalog_id as catalogId, schema_id as schemaId, audit_info as auditInfo, current_version as currentVersion, last_version as lastVersion, deleted_at as deletedAt FROM table_meta WHERE schema_id = #{schemaId} AND table_name = #{tableName} AND deleted_at = 0";
    }

    public String selectTableMetaById(@Param(value="tableId") Long tableId) {
        return "SELECT table_id as tableId, table_name as tableName, metalake_id as metalakeId, catalog_id as catalogId, schema_id as schemaId, audit_info as auditInfo, current_version as currentVersion, last_version as lastVersion, deleted_at as deletedAt FROM table_meta WHERE table_id = #{tableId} AND deleted_at = 0";
    }

    public String insertTableMeta(@Param(value="tableMeta") TablePO tablePO) {
        return "INSERT INTO table_meta(table_id, table_name, metalake_id, catalog_id, schema_id, audit_info, current_version, last_version, deleted_at) VALUES( #{tableMeta.tableId}, #{tableMeta.tableName}, #{tableMeta.metalakeId}, #{tableMeta.catalogId}, #{tableMeta.schemaId}, #{tableMeta.auditInfo}, #{tableMeta.currentVersion}, #{tableMeta.lastVersion}, #{tableMeta.deletedAt} )";
    }

    public String insertTableMetaOnDuplicateKeyUpdate(@Param(value="tableMeta") TablePO tablePO) {
        return "INSERT INTO table_meta(table_id, table_name, metalake_id, catalog_id, schema_id, audit_info, current_version, last_version, deleted_at) VALUES( #{tableMeta.tableId}, #{tableMeta.tableName}, #{tableMeta.metalakeId}, #{tableMeta.catalogId}, #{tableMeta.schemaId}, #{tableMeta.auditInfo}, #{tableMeta.currentVersion}, #{tableMeta.lastVersion}, #{tableMeta.deletedAt} ) ON DUPLICATE KEY UPDATE table_name = #{tableMeta.tableName}, metalake_id = #{tableMeta.metalakeId}, catalog_id = #{tableMeta.catalogId}, schema_id = #{tableMeta.schemaId}, audit_info = #{tableMeta.auditInfo}, current_version = #{tableMeta.currentVersion}, last_version = #{tableMeta.lastVersion}, deleted_at = #{tableMeta.deletedAt}";
    }

    public String updateTableMeta(@Param(value="newTableMeta") TablePO newTablePO, @Param(value="oldTableMeta") TablePO oldTablePO) {
        return "UPDATE table_meta SET table_name = #{newTableMeta.tableName}, metalake_id = #{newTableMeta.metalakeId}, catalog_id = #{newTableMeta.catalogId}, schema_id = #{newTableMeta.schemaId}, audit_info = #{newTableMeta.auditInfo}, current_version = #{newTableMeta.currentVersion}, last_version = #{newTableMeta.lastVersion}, deleted_at = #{newTableMeta.deletedAt} WHERE table_id = #{oldTableMeta.tableId} AND table_name = #{oldTableMeta.tableName} AND metalake_id = #{oldTableMeta.metalakeId} AND catalog_id = #{oldTableMeta.catalogId} AND schema_id = #{oldTableMeta.schemaId} AND audit_info = #{oldTableMeta.auditInfo} AND current_version = #{oldTableMeta.currentVersion} AND last_version = #{oldTableMeta.lastVersion} AND deleted_at = 0";
    }

    public String softDeleteTableMetasByTableId(@Param(value="tableId") Long tableId) {
        return "UPDATE table_meta SET deleted_at = (UNIX_TIMESTAMP() * 1000.0) + EXTRACT(MICROSECOND FROM CURRENT_TIMESTAMP(3)) / 1000 WHERE table_id = #{tableId} AND deleted_at = 0";
    }

    public String softDeleteTableMetasByMetalakeId(@Param(value="metalakeId") Long metalakeId) {
        return "UPDATE table_meta SET deleted_at = (UNIX_TIMESTAMP() * 1000.0) + EXTRACT(MICROSECOND FROM CURRENT_TIMESTAMP(3)) / 1000 WHERE metalake_id = #{metalakeId} AND deleted_at = 0";
    }

    public String softDeleteTableMetasByCatalogId(@Param(value="catalogId") Long catalogId) {
        return "UPDATE table_meta SET deleted_at = (UNIX_TIMESTAMP() * 1000.0) + EXTRACT(MICROSECOND FROM CURRENT_TIMESTAMP(3)) / 1000 WHERE catalog_id = #{catalogId} AND deleted_at = 0";
    }

    public String softDeleteTableMetasBySchemaId(@Param(value="schemaId") Long schemaId) {
        return "UPDATE table_meta SET deleted_at = (UNIX_TIMESTAMP() * 1000.0) + EXTRACT(MICROSECOND FROM CURRENT_TIMESTAMP(3)) / 1000 WHERE schema_id = #{schemaId} AND deleted_at = 0";
    }

    public String deleteTableMetasByLegacyTimeline(@Param(value="legacyTimeline") Long legacyTimeline, @Param(value="limit") int limit) {
        return "DELETE FROM table_meta WHERE deleted_at > 0 AND deleted_at < #{legacyTimeline} LIMIT #{limit}";
    }
}

