/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.catalog.mysql.operation;

import com.google.common.collect.ImmutableMap;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.gravitino.StringIdentifier;
import org.apache.gravitino.catalog.jdbc.JdbcSchema;
import org.apache.gravitino.catalog.jdbc.operation.JdbcDatabaseOperations;
import org.apache.gravitino.exceptions.NoSuchSchemaException;
import org.apache.gravitino.meta.AuditInfo;

public class MysqlDatabaseOperations
extends JdbcDatabaseOperations {
    public static final Set<String> SYS_MYSQL_DATABASE_NAMES = MysqlDatabaseOperations.createSysMysqlDatabaseNames();

    private static Set<String> createSysMysqlDatabaseNames() {
        HashSet<String> set = new HashSet<String>();
        set.add("information_schema");
        set.add("mysql");
        set.add("performance_schema");
        set.add("sys");
        return Collections.unmodifiableSet(set);
    }

    public String generateCreateDatabaseSql(String databaseName, String comment, Map<String, String> properties) {
        String originComment = StringIdentifier.removeIdFromComment((String)comment);
        if (StringUtils.isNotEmpty((CharSequence)originComment)) {
            throw new UnsupportedOperationException("MySQL doesn't support set schema comment: " + originComment);
        }
        StringBuilder sqlBuilder = new StringBuilder("CREATE DATABASE ");
        sqlBuilder.append("`").append(databaseName).append("`");
        if (MapUtils.isNotEmpty(properties)) {
            throw new UnsupportedOperationException("Properties are not supported yet");
        }
        String result = sqlBuilder.toString();
        LOG.info("Generated create database:{} sql: {}", (Object)databaseName, (Object)result);
        return result;
    }

    public String generateDropDatabaseSql(String databaseName, boolean cascade) {
        String dropDatabaseSql = "DROP DATABASE `" + databaseName + "`";
        if (cascade) {
            return dropDatabaseSql;
        }
        try (Connection connection = this.dataSource.getConnection();){
            String query = "SHOW TABLES IN `" + databaseName + "`";
            try (Statement statement = connection.createStatement();
                 ResultSet resultSet = statement.executeQuery(query);){
                if (resultSet.next()) {
                    throw new IllegalStateException(String.format("Database %s is not empty, the value of cascade should be true.", databaseName));
                }
            }
        }
        catch (SQLException sqlException) {
            throw this.exceptionMapper.toGravitinoException(sqlException);
        }
        return dropDatabaseSql;
    }

    public JdbcSchema load(String databaseName) throws NoSuchSchemaException {
        List allDatabases = this.listDatabases();
        String dbName = allDatabases.stream().filter(db -> db.equals(databaseName)).findFirst().orElseThrow(() -> new NoSuchSchemaException("Database %s could not be found", new Object[]{databaseName}));
        return (JdbcSchema)((JdbcSchema.Builder)((JdbcSchema.Builder)((JdbcSchema.Builder)JdbcSchema.builder().withName(dbName)).withProperties((Map)ImmutableMap.of())).withAuditInfo(AuditInfo.EMPTY)).build();
    }

    protected boolean isSystemDatabase(String dbName) {
        return SYS_MYSQL_DATABASE_NAMES.contains(dbName.toLowerCase(Locale.ROOT));
    }
}

