/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.catalog.mysql;

import java.util.Map;
import org.apache.gravitino.catalog.jdbc.JdbcCatalog;
import org.apache.gravitino.catalog.jdbc.MySQLProtocolCompatibleCatalogOperations;
import org.apache.gravitino.catalog.jdbc.converter.JdbcColumnDefaultValueConverter;
import org.apache.gravitino.catalog.jdbc.converter.JdbcExceptionConverter;
import org.apache.gravitino.catalog.jdbc.converter.JdbcTypeConverter;
import org.apache.gravitino.catalog.jdbc.operation.JdbcDatabaseOperations;
import org.apache.gravitino.catalog.jdbc.operation.JdbcTableOperations;
import org.apache.gravitino.catalog.mysql.MysqlCatalogCapability;
import org.apache.gravitino.catalog.mysql.MysqlTablePropertiesMetadata;
import org.apache.gravitino.catalog.mysql.converter.MysqlColumnDefaultValueConverter;
import org.apache.gravitino.catalog.mysql.converter.MysqlExceptionConverter;
import org.apache.gravitino.catalog.mysql.converter.MysqlTypeConverter;
import org.apache.gravitino.catalog.mysql.operation.MysqlDatabaseOperations;
import org.apache.gravitino.catalog.mysql.operation.MysqlTableOperations;
import org.apache.gravitino.connector.CatalogOperations;
import org.apache.gravitino.connector.PropertiesMetadata;
import org.apache.gravitino.connector.capability.Capability;

public class MysqlCatalog
extends JdbcCatalog {
    private static final MysqlTablePropertiesMetadata TABLE_PROPERTIES_META = new MysqlTablePropertiesMetadata();

    public String shortName() {
        return "jdbc-mysql";
    }

    protected CatalogOperations newOps(Map<String, String> config) {
        JdbcTypeConverter jdbcTypeConverter = this.createJdbcTypeConverter();
        return new MySQLProtocolCompatibleCatalogOperations(this.createExceptionConverter(), jdbcTypeConverter, this.createJdbcDatabaseOperations(), this.createJdbcTableOperations(), this.createJdbcColumnDefaultValueConverter());
    }

    public Capability newCapability() {
        return new MysqlCatalogCapability();
    }

    protected JdbcExceptionConverter createExceptionConverter() {
        return new MysqlExceptionConverter();
    }

    protected JdbcTypeConverter createJdbcTypeConverter() {
        return new MysqlTypeConverter();
    }

    protected JdbcDatabaseOperations createJdbcDatabaseOperations() {
        return new MysqlDatabaseOperations();
    }

    protected JdbcTableOperations createJdbcTableOperations() {
        return new MysqlTableOperations();
    }

    protected JdbcColumnDefaultValueConverter createJdbcColumnDefaultValueConverter() {
        return new MysqlColumnDefaultValueConverter();
    }

    public PropertiesMetadata tablePropertiesMetadata() throws UnsupportedOperationException {
        return TABLE_PROPERTIES_META;
    }
}

