/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.server.authentication;

import java.nio.charset.StandardCharsets;
import java.security.Principal;
import java.util.Base64;
import org.apache.commons.lang3.StringUtils;
import org.apache.gravitino.Config;
import org.apache.gravitino.UserPrincipal;
import org.apache.gravitino.server.authentication.Authenticator;

class SimpleAuthenticator
implements Authenticator {
    private final Principal ANONYMOUS_PRINCIPAL = new UserPrincipal("anonymous");

    SimpleAuthenticator() {
    }

    @Override
    public boolean isDataFromToken() {
        return true;
    }

    @Override
    public Principal authenticateToken(byte[] tokenData) {
        if (tokenData == null) {
            return this.ANONYMOUS_PRINCIPAL;
        }
        String authData = new String(tokenData, StandardCharsets.UTF_8);
        if (StringUtils.isBlank((CharSequence)authData)) {
            return this.ANONYMOUS_PRINCIPAL;
        }
        if (!authData.startsWith("Basic ")) {
            return this.ANONYMOUS_PRINCIPAL;
        }
        String credential = authData.substring("Basic ".length());
        if (StringUtils.isBlank((CharSequence)credential)) {
            return this.ANONYMOUS_PRINCIPAL;
        }
        try {
            String[] userInformation = new String(Base64.getDecoder().decode(credential), StandardCharsets.UTF_8).split(":");
            if (userInformation.length != 2) {
                return this.ANONYMOUS_PRINCIPAL;
            }
            return new UserPrincipal(userInformation[0]);
        }
        catch (IllegalArgumentException ie) {
            return this.ANONYMOUS_PRINCIPAL;
        }
    }

    @Override
    public void initialize(Config config) throws RuntimeException {
    }

    @Override
    public boolean supportsToken(byte[] tokenData) {
        return tokenData == null || new String(tokenData, StandardCharsets.UTF_8).startsWith("Basic ");
    }
}

