/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.catalog.lakehouse.paimon;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import org.apache.gravitino.catalog.lakehouse.paimon.PaimonCatalogBackend;
import org.apache.gravitino.catalog.lakehouse.paimon.authentication.AuthenticationConfig;
import org.apache.gravitino.catalog.lakehouse.paimon.authentication.kerberos.KerberosConfig;
import org.apache.gravitino.connector.BaseCatalogPropertiesMetadata;
import org.apache.gravitino.connector.PropertyEntry;

public class PaimonCatalogPropertiesMetadata
extends BaseCatalogPropertiesMetadata {
    @VisibleForTesting
    public static final String GRAVITINO_CATALOG_BACKEND = "catalog-backend";
    public static final String PAIMON_METASTORE = "metastore";
    public static final String WAREHOUSE = "warehouse";
    public static final String URI = "uri";
    public static final Map<String, String> GRAVITINO_CONFIG_TO_PAIMON = ImmutableMap.of((Object)"catalog-backend", (Object)"metastore", (Object)"warehouse", (Object)"warehouse", (Object)"uri", (Object)"uri");
    private static final Map<String, PropertyEntry<?>> PROPERTIES_METADATA;
    private static final Map<String, String> KERBEROS_CONFIGURATION;

    protected Map<String, PropertyEntry<?>> specificPropertyEntries() {
        return PROPERTIES_METADATA;
    }

    protected Map<String, String> transformProperties(Map<String, String> properties) {
        HashMap gravitinoConfig = Maps.newHashMap();
        properties.forEach((key, value) -> {
            if (GRAVITINO_CONFIG_TO_PAIMON.containsKey(key)) {
                gravitinoConfig.put(GRAVITINO_CONFIG_TO_PAIMON.get(key), value);
            }
            if (KERBEROS_CONFIGURATION.containsKey(key)) {
                gravitinoConfig.put(KERBEROS_CONFIGURATION.get(key), value);
            }
        });
        return gravitinoConfig;
    }

    static {
        KERBEROS_CONFIGURATION = ImmutableMap.of((Object)"authentication.kerberos.principal", (Object)"authentication.kerberos.principal", (Object)"authentication.kerberos.keytab-uri", (Object)"authentication.kerberos.keytab-uri", (Object)"authentication.kerberos.check-interval-sec", (Object)"authentication.kerberos.check-interval-sec", (Object)"authentication.kerberos.keytab-fetch-timeout-sec", (Object)"authentication.kerberos.keytab-fetch-timeout-sec", (Object)"authentication.type", (Object)"authentication.type");
        ImmutableList propertyEntries = ImmutableList.of((Object)PropertyEntry.enumPropertyEntry((String)GRAVITINO_CATALOG_BACKEND, (String)"Paimon catalog backend type", (boolean)true, (boolean)true, PaimonCatalogBackend.class, null, (boolean)false, (boolean)false), (Object)PropertyEntry.stringRequiredPropertyEntry((String)WAREHOUSE, (String)"Paimon catalog warehouse config", (boolean)false, (boolean)false), (Object)PropertyEntry.stringOptionalPropertyEntry((String)URI, (String)"Paimon catalog uri config", (boolean)false, null, (boolean)false));
        HashMap result = Maps.newHashMap((Map)BASIC_CATALOG_PROPERTY_ENTRIES);
        result.putAll(Maps.uniqueIndex((Iterable)propertyEntries, PropertyEntry::getName));
        result.putAll(KerberosConfig.KERBEROS_PROPERTY_ENTRIES);
        result.putAll(AuthenticationConfig.AUTHENTICATION_PROPERTY_ENTRIES);
        PROPERTIES_METADATA = ImmutableMap.copyOf((Map)result);
    }
}

