/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.catalog.kafka;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import org.apache.gravitino.Catalog;
import org.apache.gravitino.Entity;
import org.apache.gravitino.EntityStore;
import org.apache.gravitino.GravitinoEnv;
import org.apache.gravitino.NameIdentifier;
import org.apache.gravitino.Namespace;
import org.apache.gravitino.Schema;
import org.apache.gravitino.SchemaChange;
import org.apache.gravitino.StringIdentifier;
import org.apache.gravitino.catalog.kafka.KafkaSchema;
import org.apache.gravitino.catalog.kafka.KafkaTopic;
import org.apache.gravitino.connector.CatalogInfo;
import org.apache.gravitino.connector.CatalogOperations;
import org.apache.gravitino.connector.HasPropertyMetadata;
import org.apache.gravitino.connector.SupportsSchemas;
import org.apache.gravitino.exceptions.ConnectionFailedException;
import org.apache.gravitino.exceptions.NoSuchCatalogException;
import org.apache.gravitino.exceptions.NoSuchEntityException;
import org.apache.gravitino.exceptions.NoSuchSchemaException;
import org.apache.gravitino.exceptions.NoSuchTopicException;
import org.apache.gravitino.exceptions.NonEmptySchemaException;
import org.apache.gravitino.exceptions.SchemaAlreadyExistsException;
import org.apache.gravitino.exceptions.TopicAlreadyExistsException;
import org.apache.gravitino.messaging.DataLayout;
import org.apache.gravitino.messaging.Topic;
import org.apache.gravitino.messaging.TopicCatalog;
import org.apache.gravitino.messaging.TopicChange;
import org.apache.gravitino.meta.AuditInfo;
import org.apache.gravitino.meta.SchemaEntity;
import org.apache.gravitino.storage.IdGenerator;
import org.apache.gravitino.utils.NamespaceUtil;
import org.apache.gravitino.utils.PrincipalUtils;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.AlterConfigOp;
import org.apache.kafka.clients.admin.Config;
import org.apache.kafka.clients.admin.ConfigEntry;
import org.apache.kafka.clients.admin.CreateTopicsResult;
import org.apache.kafka.clients.admin.DescribeConfigsResult;
import org.apache.kafka.clients.admin.DescribeTopicsResult;
import org.apache.kafka.clients.admin.ListTopicsResult;
import org.apache.kafka.clients.admin.NewPartitions;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.clients.admin.TopicDescription;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.TopicPartitionInfo;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.InvalidConfigurationException;
import org.apache.kafka.common.errors.InvalidReplicationFactorException;
import org.apache.kafka.common.errors.TopicExistsException;
import org.apache.kafka.common.errors.UnknownTopicOrPartitionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaCatalogOperations
implements CatalogOperations,
SupportsSchemas,
TopicCatalog {
    private static final Logger LOG = LoggerFactory.getLogger(KafkaCatalogOperations.class);
    private static final String DEFAULT_SCHEMA_NAME = "default";
    @VisibleForTesting
    static final String CLIENT_ID_TEMPLATE = "%s-%s.%s";
    private final EntityStore store;
    private final IdGenerator idGenerator;
    @VisibleForTesting
    NameIdentifier defaultSchemaIdent;
    @VisibleForTesting
    Properties adminClientConfig;
    private CatalogInfo info;
    private AdminClient adminClient;
    private HasPropertyMetadata propertiesMetadata;

    @VisibleForTesting
    KafkaCatalogOperations(EntityStore store, IdGenerator idGenerator) {
        this.store = store;
        this.idGenerator = idGenerator;
    }

    public KafkaCatalogOperations() {
        this(GravitinoEnv.getInstance().entityStore(), GravitinoEnv.getInstance().idGenerator());
    }

    public void initialize(Map<String, String> config, CatalogInfo info, HasPropertyMetadata propertiesMetadata) throws RuntimeException {
        this.propertiesMetadata = propertiesMetadata;
        Preconditions.checkArgument((boolean)config.containsKey("bootstrap.servers"), (String)"Missing configuration: %s", (Object)"bootstrap.servers");
        Preconditions.checkArgument((boolean)config.containsKey("gravitino.identifier"), (String)"Missing configuration: %s", (Object)"gravitino.identifier");
        this.info = info;
        this.defaultSchemaIdent = NameIdentifier.of((String[])new String[]{info.namespace().level(0), info.name(), DEFAULT_SCHEMA_NAME});
        this.adminClientConfig = new Properties();
        Map<String, String> bypassConfigs = config.entrySet().stream().filter(e -> ((String)e.getKey()).startsWith("gravitino.bypass.")).collect(Collectors.toMap(e -> ((String)e.getKey()).substring("gravitino.bypass.".length()), Map.Entry::getValue));
        this.adminClientConfig.putAll(bypassConfigs);
        this.adminClientConfig.put("bootstrap.servers", config.get("bootstrap.servers"));
        this.adminClientConfig.put("client.id", String.format(CLIENT_ID_TEMPLATE, config.get("gravitino.identifier"), info.namespace(), info.name()));
        try {
            this.adminClient = AdminClient.create((Properties)this.adminClientConfig);
        }
        catch (KafkaException e2) {
            if (e2.getCause() instanceof ConfigException) {
                throw new IllegalArgumentException("Invalid configuration for Kafka AdminClient: " + e2.getCause().getMessage(), e2);
            }
            throw new RuntimeException("Failed to create Kafka AdminClient", e2);
        }
        this.createDefaultSchemaIfNecessary();
    }

    public NameIdentifier[] listTopics(Namespace namespace) throws NoSuchSchemaException {
        NameIdentifier schemaIdent = NameIdentifier.of((String[])namespace.levels());
        this.checkSchemaExists(schemaIdent);
        try {
            ListTopicsResult result = this.adminClient.listTopics();
            Set topicNames = (Set)result.names().get();
            return (NameIdentifier[])topicNames.stream().map(name -> NameIdentifier.of((Namespace)namespace, (String)name)).toArray(NameIdentifier[]::new);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(String.format("Failed to list topics under the schema %s: %s", namespace, e.getCause().getMessage()), e);
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Failed to list topics under the schema " + namespace, e);
        }
    }

    public void testConnection(NameIdentifier catalogIdent, Catalog.Type type, String provider, String comment, Map<String, String> properties) {
        try {
            this.adminClient.listTopics().names().get();
        }
        catch (Exception e) {
            throw new ConnectionFailedException((Throwable)e, "Failed to run listTopics in Kafka: %s", new Object[]{e.getMessage()});
        }
    }

    public Topic loadTopic(NameIdentifier ident) throws NoSuchTopicException {
        Uuid topicId;
        NameIdentifier schemaIdent = NameIdentifier.of((String[])ident.namespace().levels());
        this.checkSchemaExists(schemaIdent);
        DescribeTopicsResult result = this.adminClient.describeTopics(Collections.singleton(ident.name()));
        ConfigResource configResource = new ConfigResource(ConfigResource.Type.TOPIC, ident.name());
        DescribeConfigsResult configsResult = this.adminClient.describeConfigs(Collections.singleton(configResource));
        HashMap properties = Maps.newHashMap();
        try {
            TopicDescription topicDescription = (TopicDescription)((KafkaFuture)result.topicNameValues().get(ident.name())).get();
            int partitions = topicDescription.partitions().size();
            int replicationFactor = ((TopicPartitionInfo)topicDescription.partitions().get(0)).replicas().size();
            topicId = topicDescription.topicId();
            Config topicConfigs = (Config)((Map)configsResult.all().get()).get(configResource);
            topicConfigs.entries().forEach(e -> properties.put(e.name(), e.value()));
            properties.put("partition-count", String.valueOf(partitions));
            properties.put("replication-factor", String.valueOf(replicationFactor));
        }
        catch (ExecutionException e2) {
            if (e2.getCause() instanceof UnknownTopicOrPartitionException) {
                throw new NoSuchTopicException((Throwable)e2, "Topic %s does not exist", new Object[]{ident});
            }
            throw new RuntimeException("Failed to load topic " + ident.name() + " from Kafka", e2);
        }
        catch (InterruptedException e3) {
            throw new RuntimeException("Failed to load topic " + ident.name() + " from Kafka", e3);
        }
        LOG.info("Loaded topic {} from Kafka", (Object)ident);
        return ((KafkaTopic.Builder)((KafkaTopic.Builder)((KafkaTopic.Builder)KafkaTopic.builder().withName(ident.name())).withProperties(StringIdentifier.newPropertiesWithId((StringIdentifier)this.convertToGravitinoId(topicId), (Map)properties))).withAuditInfo(AuditInfo.builder().withCreator(PrincipalUtils.getCurrentPrincipal().getName()).withCreateTime(Instant.now()).build())).build();
    }

    public Topic createTopic(NameIdentifier ident, String comment, DataLayout dataLayout, Map<String, String> properties) throws NoSuchSchemaException, TopicAlreadyExistsException {
        NameIdentifier schemaIdent = NameIdentifier.of((String[])ident.namespace().levels());
        this.checkSchemaExists(schemaIdent);
        try {
            CreateTopicsResult createTopicsResult = this.adminClient.createTopics(Collections.singleton(this.buildNewTopic(ident, properties)));
            Uuid topicId = (Uuid)createTopicsResult.topicId(ident.name()).get();
            LOG.info("Created topic {}[id: {}] with {} partitions and replication factor {}", new Object[]{ident, topicId, createTopicsResult.numPartitions(ident.name()).get(), createTopicsResult.replicationFactor(ident.name()).get()});
            return ((KafkaTopic.Builder)((KafkaTopic.Builder)((KafkaTopic.Builder)((KafkaTopic.Builder)KafkaTopic.builder().withName(ident.name())).withComment(comment)).withProperties(StringIdentifier.newPropertiesWithId((StringIdentifier)this.convertToGravitinoId(topicId), properties))).withAuditInfo(AuditInfo.builder().withCreator(PrincipalUtils.getCurrentPrincipal().getName()).withCreateTime(Instant.now()).build())).build();
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof TopicExistsException) {
                throw new TopicAlreadyExistsException((Throwable)e, "Topic %s already exists", new Object[]{ident});
            }
            if (e.getCause() instanceof InvalidReplicationFactorException) {
                throw new IllegalArgumentException("Invalid replication factor for topic " + ident + e.getCause().getMessage(), e);
            }
            if (e.getCause() instanceof InvalidConfigurationException) {
                throw new IllegalArgumentException("Invalid properties for topic " + ident + e.getCause().getMessage(), e);
            }
            throw new RuntimeException("Failed to create topic in Kafka" + ident, e);
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Failed to create topic in Kafka" + ident, e);
        }
    }

    public Topic alterTopic(NameIdentifier ident, TopicChange ... changes) throws NoSuchTopicException, IllegalArgumentException {
        int oldPartitionCount;
        NameIdentifier schemaIdent = NameIdentifier.of((String[])ident.namespace().levels());
        this.checkSchemaExists(schemaIdent);
        KafkaTopic topic = (KafkaTopic)this.loadTopic(ident);
        String newComment = topic.comment();
        int newPartitionCount = oldPartitionCount = Integer.parseInt((String)topic.properties().get("partition-count"));
        HashMap alteredProperties = Maps.newHashMap((Map)topic.properties());
        ArrayList alterConfigOps = Lists.newArrayList();
        for (TopicChange change : changes) {
            if (change instanceof TopicChange.UpdateTopicComment) {
                newComment = ((TopicChange.UpdateTopicComment)change).getNewComment();
                continue;
            }
            if (change instanceof TopicChange.SetProperty) {
                TopicChange.SetProperty setProperty = (TopicChange.SetProperty)change;
                if ("partition-count".equals(setProperty.getProperty())) {
                    newPartitionCount = this.setPartitionCount(setProperty, newPartitionCount, alteredProperties);
                    continue;
                }
                this.setProperty(setProperty, alteredProperties, alterConfigOps);
                continue;
            }
            if (change instanceof TopicChange.RemoveProperty) {
                this.removeProperty((TopicChange.RemoveProperty)change, alteredProperties, alterConfigOps);
                continue;
            }
            throw new IllegalArgumentException("Unsupported topic change: " + change);
        }
        if (newPartitionCount != oldPartitionCount) {
            this.doPartitionCountIncrement(ident.name(), newPartitionCount);
        }
        if (!alterConfigOps.isEmpty()) {
            this.doAlterTopicConfig(ident.name(), alterConfigOps);
        }
        return ((KafkaTopic.Builder)((KafkaTopic.Builder)((KafkaTopic.Builder)((KafkaTopic.Builder)KafkaTopic.builder().withName(ident.name())).withComment(newComment)).withProperties(alteredProperties)).withAuditInfo(AuditInfo.builder().withCreator(topic.auditInfo().creator()).withCreateTime(topic.auditInfo().createTime()).withLastModifier(PrincipalUtils.getCurrentPrincipal().getName()).withLastModifiedTime(Instant.now()).build())).build();
    }

    public boolean dropTopic(NameIdentifier ident) {
        NameIdentifier schemaIdent = NameIdentifier.of((String[])ident.namespace().levels());
        this.checkSchemaExists(schemaIdent);
        try {
            this.adminClient.deleteTopics(Collections.singleton(ident.name())).all().get();
            return true;
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof UnknownTopicOrPartitionException) {
                return false;
            }
            throw new RuntimeException("Failed to drop topic " + ident.name() + " from Kafka", e);
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Failed to drop topic " + ident.name() + " from Kafka", e);
        }
    }

    public NameIdentifier[] listSchemas(Namespace namespace) throws NoSuchCatalogException {
        try {
            List schemas = this.store.list(namespace, SchemaEntity.class, Entity.EntityType.SCHEMA);
            return (NameIdentifier[])schemas.stream().map(s -> NameIdentifier.of((Namespace)namespace, (String)s.name())).toArray(NameIdentifier[]::new);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to list schemas under namespace " + namespace, e);
        }
    }

    public Schema createSchema(NameIdentifier ident, String comment, Map<String, String> properties) throws NoSuchCatalogException, SchemaAlreadyExistsException {
        throw new UnsupportedOperationException("Kafka catalog does not support schema creation because the \"default\" schema already includes all topics");
    }

    public Schema loadSchema(NameIdentifier ident) throws NoSuchSchemaException {
        try {
            SchemaEntity schema = (SchemaEntity)this.store.get(ident, Entity.EntityType.SCHEMA, SchemaEntity.class);
            return ((KafkaSchema.Builder)((KafkaSchema.Builder)((KafkaSchema.Builder)((KafkaSchema.Builder)KafkaSchema.builder().withName(schema.name())).withComment(schema.comment())).withProperties(schema.properties())).withAuditInfo(schema.auditInfo())).build();
        }
        catch (NoSuchEntityException exception) {
            throw new NoSuchSchemaException((Throwable)exception, "Schema %s does not exist", new Object[]{ident});
        }
        catch (IOException ioe) {
            throw new RuntimeException("Failed to load schema " + ident, ioe);
        }
    }

    public Schema alterSchema(NameIdentifier ident, SchemaChange ... changes) throws NoSuchSchemaException {
        if (ident.equals((Object)this.defaultSchemaIdent)) {
            throw new IllegalArgumentException("Cannot alter the default schema");
        }
        throw new UnsupportedOperationException("Kafka catalog does not support schema alteration");
    }

    public boolean dropSchema(NameIdentifier ident, boolean cascade) throws NonEmptySchemaException {
        if (ident.equals((Object)this.defaultSchemaIdent)) {
            throw new IllegalArgumentException("Cannot drop the default schema");
        }
        throw new UnsupportedOperationException("Kafka catalog does not support schema deletion");
    }

    public void close() throws IOException {
        if (this.adminClient != null) {
            this.adminClient.close();
            this.adminClient = null;
        }
    }

    private void checkSchemaExists(NameIdentifier ident) throws NoSuchSchemaException {
        if (!this.schemaExists(ident)) {
            LOG.warn("Kafka catalog schema {} does not exist", (Object)ident);
            throw new NoSuchSchemaException("Schema %s does not exist", new Object[]{ident});
        }
    }

    private int setPartitionCount(TopicChange.SetProperty setProperty, int currentPartitionCount, Map<String, String> properties) {
        Preconditions.checkArgument((boolean)"partition-count".equals(setProperty.getProperty()), (String)"Invalid property: %s", (Object)setProperty);
        int targetPartitionCount = Integer.parseInt(setProperty.getValue());
        if (targetPartitionCount == currentPartitionCount) {
            return currentPartitionCount;
        }
        if (targetPartitionCount < currentPartitionCount) {
            throw new IllegalArgumentException("Cannot reduce partition count from " + currentPartitionCount + " to " + targetPartitionCount);
        }
        properties.put("partition-count", setProperty.getValue());
        return targetPartitionCount;
    }

    private void setProperty(TopicChange.SetProperty setProperty, Map<String, String> alteredProperties, List<AlterConfigOp> alterConfigOps) {
        alteredProperties.put(setProperty.getProperty(), setProperty.getValue());
        alterConfigOps.add(new AlterConfigOp(new ConfigEntry(setProperty.getProperty(), setProperty.getValue()), AlterConfigOp.OpType.SET));
    }

    private void removeProperty(TopicChange.RemoveProperty removeProperty, Map<String, String> alteredProperties, List<AlterConfigOp> alterConfigOps) {
        Preconditions.checkArgument((!"partition-count".equals(removeProperty.getProperty()) ? 1 : 0) != 0, (Object)"Cannot remove partition count");
        alteredProperties.remove(removeProperty.getProperty());
        alterConfigOps.add(new AlterConfigOp(new ConfigEntry(removeProperty.getProperty(), null), AlterConfigOp.OpType.DELETE));
    }

    private void doPartitionCountIncrement(String topicName, int newPartitionCount) {
        try {
            this.adminClient.createPartitions(Collections.singletonMap(topicName, NewPartitions.increaseTo((int)newPartitionCount))).all().get();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to increase partition count for topic " + topicName, e);
        }
    }

    private void doAlterTopicConfig(String topicName, List<AlterConfigOp> alterConfigOps) {
        ConfigResource topicResource = new ConfigResource(ConfigResource.Type.TOPIC, topicName);
        try {
            this.adminClient.incrementalAlterConfigs(Collections.singletonMap(topicResource, alterConfigOps)).all().get();
        }
        catch (UnknownTopicOrPartitionException e) {
            throw new NoSuchTopicException((Throwable)e, "Topic %s does not exist", new Object[]{topicName});
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to alter topic properties for topic " + topicName, e);
        }
    }

    private StringIdentifier convertToGravitinoId(Uuid topicId) {
        return StringIdentifier.fromId((long)(topicId.getLeastSignificantBits() & Long.MAX_VALUE));
    }

    private NewTopic buildNewTopic(NameIdentifier ident, Map<String, String> properties) {
        Optional<Integer> partitionCount = Optional.ofNullable((Integer)this.propertiesMetadata.topicPropertiesMetadata().getOrDefault(properties, "partition-count"));
        Optional<Short> replicationFactor = Optional.ofNullable((Short)this.propertiesMetadata.topicPropertiesMetadata().getOrDefault(properties, "replication-factor"));
        NewTopic newTopic = new NewTopic(ident.name(), partitionCount, replicationFactor);
        return newTopic.configs(this.buildNewTopicConfigs(properties));
    }

    private Map<String, String> buildNewTopicConfigs(Map<String, String> properties) {
        HashMap topicConfigs = Maps.newHashMap(properties);
        topicConfigs.remove("partition-count");
        topicConfigs.remove("replication-factor");
        topicConfigs.remove("gravitino.identifier");
        return topicConfigs;
    }

    private void createDefaultSchemaIfNecessary() {
        try {
            if (StringIdentifier.DUMMY_ID.toString().equals(this.info.properties().get("gravitino.identifier")) || this.store.exists(this.defaultSchemaIdent, Entity.EntityType.SCHEMA)) {
                return;
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to check if schema " + this.defaultSchemaIdent + " exists", e);
        }
        long uid = this.idGenerator.nextId();
        ImmutableMap properties = ImmutableMap.builder().put((Object)"gravitino.identifier", (Object)StringIdentifier.fromId((long)uid).toString()).build();
        SchemaEntity defaultSchema = SchemaEntity.builder().withName(this.defaultSchemaIdent.name()).withId(Long.valueOf(uid)).withNamespace(NamespaceUtil.ofSchema((String)this.info.namespace().level(0), (String)this.info.name())).withComment("The default schema of Kafka catalog including all topics").withProperties((Map)properties).withAuditInfo(AuditInfo.builder().withCreator(this.info.auditInfo().creator()).withCreateTime(Instant.now()).build()).build();
        try {
            this.store.put((Entity)defaultSchema, true);
        }
        catch (IOException ioe) {
            throw new RuntimeException("Failed to create default schema for Kafka catalog", ioe);
        }
    }
}

