/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.storage.relational.session;

import com.google.common.annotations.VisibleForTesting;
import org.apache.gravitino.storage.relational.session.SqlSessionFactoryHelper;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.TransactionIsolationLevel;

public final class SqlSessions {
    private static final ThreadLocal<SqlSession> sessions = new ThreadLocal();

    private SqlSessions() {
    }

    @VisibleForTesting
    static ThreadLocal<SqlSession> getSessions() {
        return sessions;
    }

    public static SqlSession getSqlSession() {
        SqlSession sqlSession = sessions.get();
        if (sqlSession == null) {
            sqlSession = SqlSessionFactoryHelper.getInstance().getSqlSessionFactory().openSession(TransactionIsolationLevel.READ_COMMITTED);
            sessions.set(sqlSession);
            return sqlSession;
        }
        return sqlSession;
    }

    public static void commitAndCloseSqlSession() {
        SqlSession sqlSession = sessions.get();
        if (sqlSession != null) {
            try {
                sqlSession.commit();
                sqlSession.close();
            }
            finally {
                sessions.remove();
            }
        }
    }

    public static void rollbackAndCloseSqlSession() {
        SqlSession sqlSession = sessions.get();
        if (sqlSession != null) {
            try {
                sqlSession.rollback();
                sqlSession.close();
            }
            finally {
                sessions.remove();
            }
        }
    }

    public static void closeSqlSession() {
        SqlSession sqlSession = sessions.get();
        if (sqlSession != null) {
            try {
                sqlSession.close();
            }
            finally {
                sessions.remove();
            }
        }
    }

    public static <T> T getMapper(Class<T> className) {
        return (T)SqlSessions.getSqlSession().getMapper(className);
    }
}

