/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.catalog.jdbc.operation;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.gravitino.catalog.jdbc.converter.JdbcExceptionConverter;
import org.apache.gravitino.catalog.jdbc.operation.DatabaseOperation;
import org.apache.gravitino.catalog.jdbc.utils.JdbcConnectorUtils;
import org.apache.gravitino.exceptions.NoSuchSchemaException;
import org.apache.gravitino.exceptions.SchemaAlreadyExistsException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class JdbcDatabaseOperations
implements DatabaseOperation {
    public static final Logger LOG = LoggerFactory.getLogger(JdbcDatabaseOperations.class);
    protected DataSource dataSource;
    protected JdbcExceptionConverter exceptionMapper;

    @Override
    public void initialize(DataSource dataSource, JdbcExceptionConverter exceptionMapper, Map<String, String> conf) {
        this.dataSource = dataSource;
        this.exceptionMapper = exceptionMapper;
    }

    @Override
    public void create(String databaseName, String comment, Map<String, String> properties) throws SchemaAlreadyExistsException {
        LOG.info("Beginning to create database {}", (Object)databaseName);
        try (Connection connection = this.getConnection();){
            JdbcConnectorUtils.executeUpdate(connection, this.generateCreateDatabaseSql(databaseName, comment, properties));
            LOG.info("Finished creating database {}", (Object)databaseName);
        }
        catch (SQLException se) {
            throw this.exceptionMapper.toGravitinoException(se);
        }
    }

    @Override
    public boolean delete(String databaseName, boolean cascade) {
        LOG.info("Beginning to drop database {}", (Object)databaseName);
        try {
            this.dropDatabase(databaseName, cascade);
            LOG.info("Finished dropping database {}", (Object)databaseName);
        }
        catch (NoSuchSchemaException e) {
            return false;
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<String> listDatabases() {
        ArrayList<String> databaseNames = new ArrayList<String>();
        try (Connection connection = this.getConnection();){
            DatabaseMetaData metaData = connection.getMetaData();
            ResultSet resultSet = metaData.getCatalogs();
            while (resultSet.next()) {
                String databaseName = resultSet.getString("TABLE_CAT");
                if (this.isSystemDatabase(databaseName)) continue;
                databaseNames.add(databaseName);
            }
            ArrayList<String> arrayList = databaseNames;
            return arrayList;
        }
        catch (SQLException se) {
            throw this.exceptionMapper.toGravitinoException(se);
        }
    }

    protected void dropDatabase(String databaseName, boolean cascade) {
        try (Connection connection = this.getConnection();){
            JdbcConnectorUtils.executeUpdate(connection, this.generateDropDatabaseSql(databaseName, cascade));
        }
        catch (SQLException se) {
            throw this.exceptionMapper.toGravitinoException(se);
        }
    }

    protected abstract String generateCreateDatabaseSql(String var1, String var2, Map<String, String> var3);

    protected abstract String generateDropDatabaseSql(String var1, boolean var2);

    protected Connection getConnection() throws SQLException {
        return this.dataSource.getConnection();
    }

    protected boolean isSystemDatabase(String dbName) {
        return false;
    }
}

