/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.catalog.jdbc;

import java.sql.Driver;
import java.sql.DriverManager;
import org.apache.gravitino.catalog.jdbc.JdbcCatalogOperations;
import org.apache.gravitino.catalog.jdbc.converter.JdbcColumnDefaultValueConverter;
import org.apache.gravitino.catalog.jdbc.converter.JdbcExceptionConverter;
import org.apache.gravitino.catalog.jdbc.converter.JdbcTypeConverter;
import org.apache.gravitino.catalog.jdbc.operation.JdbcDatabaseOperations;
import org.apache.gravitino.catalog.jdbc.operation.JdbcTableOperations;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MySQLProtocolCompatibleCatalogOperations
extends JdbcCatalogOperations {
    private static final Logger LOG = LoggerFactory.getLogger(MySQLProtocolCompatibleCatalogOperations.class);
    private static final int MYSQL_JDBC_DRIVER_MINIMAL_SUPPORT_VERSION = 8;

    public MySQLProtocolCompatibleCatalogOperations(JdbcExceptionConverter exceptionConverter, JdbcTypeConverter jdbcTypeConverter, JdbcDatabaseOperations databaseOperation, JdbcTableOperations tableOperation, JdbcColumnDefaultValueConverter columnDefaultValueConverter) {
        super(exceptionConverter, jdbcTypeConverter, databaseOperation, tableOperation, columnDefaultValueConverter);
    }

    @Override
    public boolean checkJDBCDriverVersion() {
        JdbcCatalogOperations.JDBCDriverInfo driverInfo = this.getDiverInfo();
        if (driverInfo.majorVersion < 8) {
            throw new RuntimeException(String.format("Mysql catalog does not support the jdbc driver version %s, minimal required version is 8.0", driverInfo.version));
        }
        return true;
    }

    @Override
    public void close() {
        super.close();
        try {
            Class.forName("com.mysql.cj.jdbc.AbandonedConnectionCleanupThread").getMethod("uncheckedShutdown", new Class[0]).invoke(null, new Object[0]);
            LOG.info("AbandonedConnectionCleanupThread has been shutdown...");
            Driver mysqlDriver = DriverManager.getDriver("jdbc:mysql://dumpy_address");
            this.deregisterDriver(mysqlDriver);
        }
        catch (Exception e) {
            LOG.warn("Failed to shutdown AbandonedConnectionCleanupThread or deregister MySQL driver", (Throwable)e);
        }
    }
}

