/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.catalog.jdbc;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.gravitino.catalog.jdbc.config.JdbcConfig;
import org.apache.gravitino.connector.BaseCatalogPropertiesMetadata;
import org.apache.gravitino.connector.PropertyEntry;

public class JdbcCatalogPropertiesMetadata
extends BaseCatalogPropertiesMetadata {
    private static final Map<String, PropertyEntry<?>> PROPERTIES_METADATA;
    private static final List<String> JDBC_PROPERTIES;

    protected Map<String, PropertyEntry<?>> specificPropertyEntries() {
        return PROPERTIES_METADATA;
    }

    public Map<String, String> transformProperties(Map<String, String> properties) {
        HashMap result = Maps.newHashMap();
        properties.forEach((key, value) -> {
            if (JDBC_PROPERTIES.contains(key)) {
                result.put(key, value);
            }
        });
        return result;
    }

    static {
        JDBC_PROPERTIES = ImmutableList.of((Object)JdbcConfig.JDBC_URL.getKey(), (Object)JdbcConfig.JDBC_DATABASE.getKey(), (Object)JdbcConfig.JDBC_DRIVER.getKey(), (Object)JdbcConfig.USERNAME.getKey(), (Object)JdbcConfig.PASSWORD.getKey(), (Object)JdbcConfig.POOL_MIN_SIZE.getKey(), (Object)JdbcConfig.POOL_MAX_SIZE.getKey());
        ImmutableList propertyEntries = ImmutableList.of((Object)PropertyEntry.stringPropertyEntry((String)JdbcConfig.JDBC_URL.getKey(), (String)JdbcConfig.JDBC_URL.getDoc(), (boolean)true, (boolean)false, null, (boolean)false, (boolean)false), (Object)PropertyEntry.stringOptionalPropertyEntry((String)JdbcConfig.JDBC_DATABASE.getKey(), (String)JdbcConfig.JDBC_DATABASE.getDoc(), (boolean)false, null, (boolean)false), (Object)PropertyEntry.stringOptionalPropertyEntry((String)JdbcConfig.JDBC_DRIVER.getKey(), (String)JdbcConfig.JDBC_DRIVER.getDoc(), (boolean)false, null, (boolean)false), (Object)PropertyEntry.stringOptionalPropertyEntry((String)JdbcConfig.USERNAME.getKey(), (String)JdbcConfig.USERNAME.getDoc(), (boolean)false, null, (boolean)false), (Object)PropertyEntry.stringOptionalPropertyEntry((String)JdbcConfig.PASSWORD.getKey(), (String)JdbcConfig.PASSWORD.getDoc(), (boolean)false, null, (boolean)false), (Object)PropertyEntry.integerPropertyEntry((String)JdbcConfig.POOL_MIN_SIZE.getKey(), (String)JdbcConfig.POOL_MIN_SIZE.getDoc(), (boolean)false, (boolean)false, (Integer)((Integer)JdbcConfig.POOL_MIN_SIZE.getDefaultValue()), (boolean)true, (boolean)false), (Object)PropertyEntry.integerPropertyEntry((String)JdbcConfig.POOL_MAX_SIZE.getKey(), (String)JdbcConfig.POOL_MAX_SIZE.getDoc(), (boolean)false, (boolean)false, (Integer)((Integer)JdbcConfig.POOL_MAX_SIZE.getDefaultValue()), (boolean)true, (boolean)false));
        PROPERTIES_METADATA = ImmutableMap.builder().putAll(BASIC_CATALOG_PROPERTY_ENTRIES).putAll((Map)Maps.uniqueIndex((Iterable)propertyEntries, PropertyEntry::getName)).build();
    }
}

