/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.dto.requests;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.base.Preconditions;
import java.util.Arrays;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.apache.gravitino.json.JsonUtils;
import org.apache.gravitino.rel.Column;
import org.apache.gravitino.rel.TableChange;
import org.apache.gravitino.rel.expressions.Expression;
import org.apache.gravitino.rel.indexes.Index;
import org.apache.gravitino.rel.indexes.Indexes;
import org.apache.gravitino.rel.types.Type;
import org.apache.gravitino.rest.RESTRequest;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY)
@JsonSubTypes(value={@JsonSubTypes.Type(value=RenameTableRequest.class, name="rename"), @JsonSubTypes.Type(value=UpdateTableCommentRequest.class, name="updateComment"), @JsonSubTypes.Type(value=SetTablePropertyRequest.class, name="setProperty"), @JsonSubTypes.Type(value=RemoveTablePropertyRequest.class, name="removeProperty"), @JsonSubTypes.Type(value=AddTableColumnRequest.class, name="addColumn"), @JsonSubTypes.Type(value=RenameTableColumnRequest.class, name="renameColumn"), @JsonSubTypes.Type(value=UpdateTableColumnDefaultValueRequest.class, name="updateColumnDefaultValue"), @JsonSubTypes.Type(value=UpdateTableColumnTypeRequest.class, name="updateColumnType"), @JsonSubTypes.Type(value=UpdateTableColumnCommentRequest.class, name="updateColumnComment"), @JsonSubTypes.Type(value=UpdateTableColumnPositionRequest.class, name="updateColumnPosition"), @JsonSubTypes.Type(value=UpdateTableColumnNullabilityRequest.class, name="updateColumnNullability"), @JsonSubTypes.Type(value=DeleteTableColumnRequest.class, name="deleteColumn"), @JsonSubTypes.Type(value=AddTableIndexRequest.class, name="addTableIndex"), @JsonSubTypes.Type(value=DeleteTableIndexRequest.class, name="deleteTableIndex"), @JsonSubTypes.Type(value=UpdateColumnAutoIncrementRequest.class, name="updateColumnAutoIncrement")})
public interface TableUpdateRequest
extends RESTRequest {
    public TableChange tableChange();

    public static class UpdateColumnAutoIncrementRequest
    implements TableUpdateRequest {
        @JsonProperty(value="fieldName")
        private final String[] fieldName;
        @JsonProperty(value="autoIncrement")
        private final boolean autoIncrement;

        public UpdateColumnAutoIncrementRequest(String[] fieldName, boolean autoIncrement) {
            this.fieldName = fieldName;
            this.autoIncrement = autoIncrement;
        }

        public UpdateColumnAutoIncrementRequest() {
            this(null, false);
        }

        @Override
        public void validate() throws IllegalArgumentException {
            Preconditions.checkArgument((this.fieldName != null && this.fieldName.length > 0 && Arrays.stream(this.fieldName).allMatch(StringUtils::isNotBlank) ? 1 : 0) != 0, (Object)"\"fieldName\" field is required and cannot be empty");
        }

        @Override
        public TableChange tableChange() {
            return TableChange.updateColumnAutoIncrement((String[])this.fieldName, (boolean)this.autoIncrement);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof UpdateColumnAutoIncrementRequest)) {
                return false;
            }
            UpdateColumnAutoIncrementRequest other = (UpdateColumnAutoIncrementRequest)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isAutoIncrement() != other.isAutoIncrement()) {
                return false;
            }
            return Arrays.deepEquals(this.getFieldName(), other.getFieldName());
        }

        protected boolean canEqual(Object other) {
            return other instanceof UpdateColumnAutoIncrementRequest;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isAutoIncrement() ? 79 : 97);
            result = result * 59 + Arrays.deepHashCode(this.getFieldName());
            return result;
        }

        public String toString() {
            return "TableUpdateRequest.UpdateColumnAutoIncrementRequest(fieldName=" + Arrays.deepToString(this.getFieldName()) + ", autoIncrement=" + this.isAutoIncrement() + ")";
        }

        public String[] getFieldName() {
            return this.fieldName;
        }

        public boolean isAutoIncrement() {
            return this.autoIncrement;
        }
    }

    public static class DeleteTableIndexRequest
    implements TableUpdateRequest {
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="ifExists")
        private Boolean ifExists;

        public DeleteTableIndexRequest() {
        }

        public DeleteTableIndexRequest(String name, Boolean ifExists) {
            this.name = name;
            this.ifExists = ifExists;
        }

        @Override
        public void validate() throws IllegalArgumentException {
            Preconditions.checkNotNull((Object)this.name, (Object)"Index name cannot be null");
        }

        @Override
        public TableChange tableChange() {
            return TableChange.deleteIndex((String)this.name, (Boolean)this.ifExists);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DeleteTableIndexRequest)) {
                return false;
            }
            DeleteTableIndexRequest other = (DeleteTableIndexRequest)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Boolean this$ifExists = this.ifExists;
            Boolean other$ifExists = other.ifExists;
            if (this$ifExists == null ? other$ifExists != null : !((Object)this$ifExists).equals(other$ifExists)) {
                return false;
            }
            String this$name = this.name;
            String other$name = other.name;
            return !(this$name == null ? other$name != null : !this$name.equals(other$name));
        }

        protected boolean canEqual(Object other) {
            return other instanceof DeleteTableIndexRequest;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $ifExists = this.ifExists;
            result = result * 59 + ($ifExists == null ? 43 : ((Object)$ifExists).hashCode());
            String $name = this.name;
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            return result;
        }

        public String toString() {
            return "TableUpdateRequest.DeleteTableIndexRequest(name=" + this.name + ", ifExists=" + this.ifExists + ")";
        }
    }

    public static class AddTableIndexRequest
    implements TableUpdateRequest {
        @JsonProperty(value="index")
        @JsonSerialize(using=JsonUtils.IndexSerializer.class)
        @JsonDeserialize(using=JsonUtils.IndexDeserializer.class)
        private Index index;

        public AddTableIndexRequest() {
        }

        public AddTableIndexRequest(Index.IndexType type, String name, String[][] fieldNames) {
            this.index = Indexes.of((Index.IndexType)type, (String)name, (String[][])fieldNames);
        }

        @Override
        public void validate() throws IllegalArgumentException {
            Preconditions.checkNotNull((Object)this.index, (Object)"Index cannot be null");
            Preconditions.checkArgument((this.index.type() != null ? 1 : 0) != 0, (Object)"Index type cannot be null");
            Preconditions.checkArgument((this.index.fieldNames() != null && this.index.fieldNames().length > 0 ? 1 : 0) != 0, (Object)"The index must be set with corresponding column names");
        }

        @Override
        public TableChange tableChange() {
            return TableChange.addIndex((Index.IndexType)this.index.type(), (String)this.index.name(), (String[][])this.index.fieldNames());
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AddTableIndexRequest)) {
                return false;
            }
            AddTableIndexRequest other = (AddTableIndexRequest)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Index this$index = this.index;
            Index other$index = other.index;
            return !(this$index == null ? other$index != null : !this$index.equals(other$index));
        }

        protected boolean canEqual(Object other) {
            return other instanceof AddTableIndexRequest;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Index $index = this.index;
            result = result * 59 + ($index == null ? 43 : $index.hashCode());
            return result;
        }

        public String toString() {
            return "TableUpdateRequest.AddTableIndexRequest(index=" + this.index + ")";
        }
    }

    public static class DeleteTableColumnRequest
    implements TableUpdateRequest {
        @JsonProperty(value="fieldName")
        private final String[] fieldName;
        @JsonProperty(value="ifExists")
        private final boolean ifExists;

        public DeleteTableColumnRequest(String[] fieldName, boolean ifExists) {
            this.fieldName = fieldName;
            this.ifExists = ifExists;
        }

        public DeleteTableColumnRequest() {
            this(null, false);
        }

        @Override
        public void validate() throws IllegalArgumentException {
            Preconditions.checkArgument((this.fieldName != null && this.fieldName.length > 0 && Arrays.stream(this.fieldName).allMatch(StringUtils::isNotBlank) ? 1 : 0) != 0, (Object)"\"fieldName\" field is required and cannot be empty");
        }

        @Override
        public TableChange tableChange() {
            return TableChange.deleteColumn((String[])this.fieldName, (Boolean)this.ifExists);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DeleteTableColumnRequest)) {
                return false;
            }
            DeleteTableColumnRequest other = (DeleteTableColumnRequest)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isIfExists() != other.isIfExists()) {
                return false;
            }
            return Arrays.deepEquals(this.getFieldName(), other.getFieldName());
        }

        protected boolean canEqual(Object other) {
            return other instanceof DeleteTableColumnRequest;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isIfExists() ? 79 : 97);
            result = result * 59 + Arrays.deepHashCode(this.getFieldName());
            return result;
        }

        public String toString() {
            return "TableUpdateRequest.DeleteTableColumnRequest(fieldName=" + Arrays.deepToString(this.getFieldName()) + ", ifExists=" + this.isIfExists() + ")";
        }

        public String[] getFieldName() {
            return this.fieldName;
        }

        public boolean isIfExists() {
            return this.ifExists;
        }
    }

    public static class UpdateTableColumnNullabilityRequest
    implements TableUpdateRequest {
        @JsonProperty(value="fieldName")
        private final String[] fieldName;
        @JsonProperty(value="nullable")
        private final boolean nullable;

        public UpdateTableColumnNullabilityRequest(String[] fieldName, boolean nullable) {
            this.fieldName = fieldName;
            this.nullable = nullable;
        }

        public UpdateTableColumnNullabilityRequest() {
            this(null, true);
        }

        @Override
        public TableChange tableChange() {
            return TableChange.updateColumnNullability((String[])this.fieldName, (boolean)this.nullable);
        }

        @Override
        public void validate() throws IllegalArgumentException {
            Preconditions.checkArgument((this.fieldName != null && this.fieldName.length > 0 && Arrays.stream(this.fieldName).allMatch(StringUtils::isNotBlank) ? 1 : 0) != 0, (Object)"\"fieldName\" field is required and cannot be empty");
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof UpdateTableColumnNullabilityRequest)) {
                return false;
            }
            UpdateTableColumnNullabilityRequest other = (UpdateTableColumnNullabilityRequest)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isNullable() != other.isNullable()) {
                return false;
            }
            return Arrays.deepEquals(this.getFieldName(), other.getFieldName());
        }

        protected boolean canEqual(Object other) {
            return other instanceof UpdateTableColumnNullabilityRequest;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isNullable() ? 79 : 97);
            result = result * 59 + Arrays.deepHashCode(this.getFieldName());
            return result;
        }

        public String toString() {
            return "TableUpdateRequest.UpdateTableColumnNullabilityRequest(fieldName=" + Arrays.deepToString(this.getFieldName()) + ", nullable=" + this.isNullable() + ")";
        }

        public String[] getFieldName() {
            return this.fieldName;
        }

        public boolean isNullable() {
            return this.nullable;
        }
    }

    public static class UpdateTableColumnPositionRequest
    implements TableUpdateRequest {
        @JsonProperty(value="fieldName")
        private final String[] fieldName;
        @JsonProperty(value="newPosition")
        @JsonSerialize(using=JsonUtils.ColumnPositionSerializer.class)
        @JsonDeserialize(using=JsonUtils.ColumnPositionDeserializer.class)
        private final TableChange.ColumnPosition newPosition;

        public UpdateTableColumnPositionRequest(String[] fieldName, TableChange.ColumnPosition newPosition) {
            this.fieldName = fieldName;
            this.newPosition = newPosition;
        }

        public UpdateTableColumnPositionRequest() {
            this(null, null);
        }

        @Override
        public void validate() throws IllegalArgumentException {
            Preconditions.checkArgument((this.fieldName != null && this.fieldName.length > 0 && Arrays.stream(this.fieldName).allMatch(StringUtils::isNotBlank) ? 1 : 0) != 0, (Object)"\"fieldName\" field is required and cannot be empty");
            Preconditions.checkArgument((this.newPosition != null ? 1 : 0) != 0, (Object)"\"newPosition\" field is required and cannot be empty");
        }

        @Override
        public TableChange tableChange() {
            return TableChange.updateColumnPosition((String[])this.fieldName, (TableChange.ColumnPosition)this.newPosition);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof UpdateTableColumnPositionRequest)) {
                return false;
            }
            UpdateTableColumnPositionRequest other = (UpdateTableColumnPositionRequest)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!Arrays.deepEquals(this.getFieldName(), other.getFieldName())) {
                return false;
            }
            TableChange.ColumnPosition this$newPosition = this.getNewPosition();
            TableChange.ColumnPosition other$newPosition = other.getNewPosition();
            return !(this$newPosition == null ? other$newPosition != null : !this$newPosition.equals(other$newPosition));
        }

        protected boolean canEqual(Object other) {
            return other instanceof UpdateTableColumnPositionRequest;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + Arrays.deepHashCode(this.getFieldName());
            TableChange.ColumnPosition $newPosition = this.getNewPosition();
            result = result * 59 + ($newPosition == null ? 43 : $newPosition.hashCode());
            return result;
        }

        public String toString() {
            return "TableUpdateRequest.UpdateTableColumnPositionRequest(fieldName=" + Arrays.deepToString(this.getFieldName()) + ", newPosition=" + this.getNewPosition() + ")";
        }

        public String[] getFieldName() {
            return this.fieldName;
        }

        public TableChange.ColumnPosition getNewPosition() {
            return this.newPosition;
        }
    }

    public static class UpdateTableColumnCommentRequest
    implements TableUpdateRequest {
        @JsonProperty(value="fieldName")
        private final String[] fieldName;
        @JsonProperty(value="newComment")
        private final String newComment;

        public UpdateTableColumnCommentRequest(String[] fieldName, String newComment) {
            this.fieldName = fieldName;
            this.newComment = newComment;
        }

        public UpdateTableColumnCommentRequest() {
            this(null, null);
        }

        @Override
        public void validate() throws IllegalArgumentException {
            Preconditions.checkArgument((this.fieldName != null && this.fieldName.length > 0 && Arrays.stream(this.fieldName).allMatch(StringUtils::isNotBlank) ? 1 : 0) != 0, (Object)"\"fieldName\" field is required and cannot be empty");
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.newComment), (Object)"\"newComment\" field is required and cannot be empty");
        }

        @Override
        public TableChange tableChange() {
            return TableChange.updateColumnComment((String[])this.fieldName, (String)this.newComment);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof UpdateTableColumnCommentRequest)) {
                return false;
            }
            UpdateTableColumnCommentRequest other = (UpdateTableColumnCommentRequest)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!Arrays.deepEquals(this.getFieldName(), other.getFieldName())) {
                return false;
            }
            String this$newComment = this.getNewComment();
            String other$newComment = other.getNewComment();
            return !(this$newComment == null ? other$newComment != null : !this$newComment.equals(other$newComment));
        }

        protected boolean canEqual(Object other) {
            return other instanceof UpdateTableColumnCommentRequest;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + Arrays.deepHashCode(this.getFieldName());
            String $newComment = this.getNewComment();
            result = result * 59 + ($newComment == null ? 43 : $newComment.hashCode());
            return result;
        }

        public String toString() {
            return "TableUpdateRequest.UpdateTableColumnCommentRequest(fieldName=" + Arrays.deepToString(this.getFieldName()) + ", newComment=" + this.getNewComment() + ")";
        }

        public String[] getFieldName() {
            return this.fieldName;
        }

        public String getNewComment() {
            return this.newComment;
        }
    }

    public static class UpdateTableColumnTypeRequest
    implements TableUpdateRequest {
        @JsonProperty(value="fieldName")
        private final String[] fieldName;
        @JsonProperty(value="newType")
        @JsonSerialize(using=JsonUtils.TypeSerializer.class)
        @JsonDeserialize(using=JsonUtils.TypeDeserializer.class)
        private final Type newType;

        public UpdateTableColumnTypeRequest(String[] fieldName, Type newType) {
            this.fieldName = fieldName;
            this.newType = newType;
        }

        public UpdateTableColumnTypeRequest() {
            this(null, null);
        }

        @Override
        public void validate() throws IllegalArgumentException {
            Preconditions.checkArgument((this.fieldName != null && this.fieldName.length > 0 && Arrays.stream(this.fieldName).allMatch(StringUtils::isNotBlank) ? 1 : 0) != 0, (Object)"\"fieldName\" field is required and cannot be empty");
            Preconditions.checkArgument((this.newType != null ? 1 : 0) != 0, (Object)"\"newType\" field is required and cannot be empty");
        }

        @Override
        public TableChange tableChange() {
            return TableChange.updateColumnType((String[])this.fieldName, (Type)this.newType);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof UpdateTableColumnTypeRequest)) {
                return false;
            }
            UpdateTableColumnTypeRequest other = (UpdateTableColumnTypeRequest)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!Arrays.deepEquals(this.getFieldName(), other.getFieldName())) {
                return false;
            }
            Type this$newType = this.getNewType();
            Type other$newType = other.getNewType();
            return !(this$newType == null ? other$newType != null : !this$newType.equals(other$newType));
        }

        protected boolean canEqual(Object other) {
            return other instanceof UpdateTableColumnTypeRequest;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + Arrays.deepHashCode(this.getFieldName());
            Type $newType = this.getNewType();
            result = result * 59 + ($newType == null ? 43 : $newType.hashCode());
            return result;
        }

        public String toString() {
            return "TableUpdateRequest.UpdateTableColumnTypeRequest(fieldName=" + Arrays.deepToString(this.getFieldName()) + ", newType=" + this.getNewType() + ")";
        }

        public String[] getFieldName() {
            return this.fieldName;
        }

        public Type getNewType() {
            return this.newType;
        }
    }

    public static class UpdateTableColumnDefaultValueRequest
    implements TableUpdateRequest {
        @JsonProperty(value="fieldName")
        private final String[] fieldName;
        @JsonProperty(value="newDefaultValue")
        @JsonSerialize(using=JsonUtils.ColumnDefaultValueSerializer.class)
        @JsonDeserialize(using=JsonUtils.ColumnDefaultValueDeserializer.class)
        private final Expression newDefaultValue;

        public UpdateTableColumnDefaultValueRequest(String[] fieldName, Expression newDefaultValue) {
            this.fieldName = fieldName;
            this.newDefaultValue = newDefaultValue;
        }

        public UpdateTableColumnDefaultValueRequest() {
            this(null, null);
        }

        @Override
        public void validate() throws IllegalArgumentException {
            Preconditions.checkArgument((this.fieldName != null && this.fieldName.length > 0 && Arrays.stream(this.fieldName).allMatch(StringUtils::isNotBlank) ? 1 : 0) != 0, (Object)"\"fieldName\" field is required and cannot be empty");
            Preconditions.checkArgument((this.newDefaultValue != null && this.newDefaultValue != Column.DEFAULT_VALUE_NOT_SET ? 1 : 0) != 0, (Object)"\"newDefaultValue\" field is required and cannot be empty");
        }

        @Override
        public TableChange tableChange() {
            return TableChange.updateColumnDefaultValue((String[])this.fieldName, (Expression)this.newDefaultValue);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof UpdateTableColumnDefaultValueRequest)) {
                return false;
            }
            UpdateTableColumnDefaultValueRequest other = (UpdateTableColumnDefaultValueRequest)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!Arrays.deepEquals(this.getFieldName(), other.getFieldName())) {
                return false;
            }
            Expression this$newDefaultValue = this.getNewDefaultValue();
            Expression other$newDefaultValue = other.getNewDefaultValue();
            return !(this$newDefaultValue == null ? other$newDefaultValue != null : !this$newDefaultValue.equals(other$newDefaultValue));
        }

        protected boolean canEqual(Object other) {
            return other instanceof UpdateTableColumnDefaultValueRequest;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + Arrays.deepHashCode(this.getFieldName());
            Expression $newDefaultValue = this.getNewDefaultValue();
            result = result * 59 + ($newDefaultValue == null ? 43 : $newDefaultValue.hashCode());
            return result;
        }

        public String toString() {
            return "TableUpdateRequest.UpdateTableColumnDefaultValueRequest(fieldName=" + Arrays.deepToString(this.getFieldName()) + ", newDefaultValue=" + this.getNewDefaultValue() + ")";
        }

        public String[] getFieldName() {
            return this.fieldName;
        }

        public Expression getNewDefaultValue() {
            return this.newDefaultValue;
        }
    }

    public static class RenameTableColumnRequest
    implements TableUpdateRequest {
        @JsonProperty(value="oldFieldName")
        private final String[] oldFieldName;
        @JsonProperty(value="newFieldName")
        private final String newFieldName;

        public RenameTableColumnRequest(String[] oldFieldName, String newFieldName) {
            this.oldFieldName = oldFieldName;
            this.newFieldName = newFieldName;
        }

        public RenameTableColumnRequest() {
            this(null, null);
        }

        @Override
        public void validate() throws IllegalArgumentException {
            Preconditions.checkArgument((this.oldFieldName != null && this.oldFieldName.length > 0 && Arrays.stream(this.oldFieldName).allMatch(StringUtils::isNotBlank) ? 1 : 0) != 0, (Object)"\"oldFieldName\" field is required and cannot be empty");
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.newFieldName), (Object)"\"newFieldName\" field is required and cannot be empty");
        }

        @Override
        public TableChange tableChange() {
            return TableChange.renameColumn((String[])this.oldFieldName, (String)this.newFieldName);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RenameTableColumnRequest)) {
                return false;
            }
            RenameTableColumnRequest other = (RenameTableColumnRequest)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!Arrays.deepEquals(this.getOldFieldName(), other.getOldFieldName())) {
                return false;
            }
            String this$newFieldName = this.getNewFieldName();
            String other$newFieldName = other.getNewFieldName();
            return !(this$newFieldName == null ? other$newFieldName != null : !this$newFieldName.equals(other$newFieldName));
        }

        protected boolean canEqual(Object other) {
            return other instanceof RenameTableColumnRequest;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + Arrays.deepHashCode(this.getOldFieldName());
            String $newFieldName = this.getNewFieldName();
            result = result * 59 + ($newFieldName == null ? 43 : $newFieldName.hashCode());
            return result;
        }

        public String toString() {
            return "TableUpdateRequest.RenameTableColumnRequest(oldFieldName=" + Arrays.deepToString(this.getOldFieldName()) + ", newFieldName=" + this.getNewFieldName() + ")";
        }

        public String[] getOldFieldName() {
            return this.oldFieldName;
        }

        public String getNewFieldName() {
            return this.newFieldName;
        }
    }

    public static class AddTableColumnRequest
    implements TableUpdateRequest {
        @JsonProperty(value="fieldName")
        private final String[] fieldName;
        @JsonProperty(value="type")
        @JsonSerialize(using=JsonUtils.TypeSerializer.class)
        @JsonDeserialize(using=JsonUtils.TypeDeserializer.class)
        private final Type dataType;
        @JsonProperty(value="comment")
        @Nullable
        private final String comment;
        @JsonProperty(value="position")
        @JsonSerialize(using=JsonUtils.ColumnPositionSerializer.class)
        @JsonDeserialize(using=JsonUtils.ColumnPositionDeserializer.class)
        @Nullable
        private final TableChange.ColumnPosition position;
        @JsonProperty(value="nullable", defaultValue="true")
        private final boolean nullable;
        @JsonProperty(value="autoIncrement", defaultValue="false")
        private final boolean autoIncrement;
        @JsonProperty(value="defaultValue")
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        @JsonSerialize(using=JsonUtils.ColumnDefaultValueSerializer.class)
        @JsonDeserialize(using=JsonUtils.ColumnDefaultValueDeserializer.class)
        private final Expression defaultValue;

        public AddTableColumnRequest() {
            this(null, null, null, null, true, false, null);
        }

        public AddTableColumnRequest(String[] fieldName, Type dataType, String comment, TableChange.ColumnPosition position, boolean nullable, boolean autoIncrement, Expression defaultValue) {
            this.fieldName = fieldName;
            this.dataType = dataType;
            this.comment = comment;
            this.position = position == null ? TableChange.ColumnPosition.defaultPos() : position;
            this.nullable = nullable;
            this.autoIncrement = autoIncrement;
            this.defaultValue = defaultValue == null ? Column.DEFAULT_VALUE_NOT_SET : defaultValue;
        }

        public AddTableColumnRequest(String[] fieldName, Type dataType, String comment, TableChange.ColumnPosition position) {
            this(fieldName, dataType, comment, position, true, false, null);
        }

        public AddTableColumnRequest(String[] fieldName, Type dataType, String comment) {
            this(fieldName, dataType, comment, TableChange.ColumnPosition.defaultPos());
        }

        @Override
        public void validate() throws IllegalArgumentException {
            Preconditions.checkArgument((this.fieldName != null && this.fieldName.length > 0 && Arrays.stream(this.fieldName).allMatch(StringUtils::isNotBlank) ? 1 : 0) != 0, (Object)"\"fieldName\" field is required and cannot be empty");
            Preconditions.checkArgument((this.dataType != null ? 1 : 0) != 0, (Object)"\"type\" field is required and cannot be empty");
        }

        @Override
        public TableChange tableChange() {
            return TableChange.addColumn((String[])this.fieldName, (Type)this.dataType, (String)this.comment, (TableChange.ColumnPosition)this.position, (boolean)this.nullable, (boolean)this.autoIncrement, (Expression)this.defaultValue);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AddTableColumnRequest)) {
                return false;
            }
            AddTableColumnRequest other = (AddTableColumnRequest)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isNullable() != other.isNullable()) {
                return false;
            }
            if (this.isAutoIncrement() != other.isAutoIncrement()) {
                return false;
            }
            if (!Arrays.deepEquals(this.getFieldName(), other.getFieldName())) {
                return false;
            }
            Type this$dataType = this.getDataType();
            Type other$dataType = other.getDataType();
            if (this$dataType == null ? other$dataType != null : !this$dataType.equals(other$dataType)) {
                return false;
            }
            String this$comment = this.getComment();
            String other$comment = other.getComment();
            if (this$comment == null ? other$comment != null : !this$comment.equals(other$comment)) {
                return false;
            }
            TableChange.ColumnPosition this$position = this.getPosition();
            TableChange.ColumnPosition other$position = other.getPosition();
            if (this$position == null ? other$position != null : !this$position.equals(other$position)) {
                return false;
            }
            Expression this$defaultValue = this.getDefaultValue();
            Expression other$defaultValue = other.getDefaultValue();
            return !(this$defaultValue == null ? other$defaultValue != null : !this$defaultValue.equals(other$defaultValue));
        }

        protected boolean canEqual(Object other) {
            return other instanceof AddTableColumnRequest;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isNullable() ? 79 : 97);
            result = result * 59 + (this.isAutoIncrement() ? 79 : 97);
            result = result * 59 + Arrays.deepHashCode(this.getFieldName());
            Type $dataType = this.getDataType();
            result = result * 59 + ($dataType == null ? 43 : $dataType.hashCode());
            String $comment = this.getComment();
            result = result * 59 + ($comment == null ? 43 : $comment.hashCode());
            TableChange.ColumnPosition $position = this.getPosition();
            result = result * 59 + ($position == null ? 43 : $position.hashCode());
            Expression $defaultValue = this.getDefaultValue();
            result = result * 59 + ($defaultValue == null ? 43 : $defaultValue.hashCode());
            return result;
        }

        public String toString() {
            return "TableUpdateRequest.AddTableColumnRequest(fieldName=" + Arrays.deepToString(this.getFieldName()) + ", dataType=" + this.getDataType() + ", comment=" + this.getComment() + ", position=" + this.getPosition() + ", nullable=" + this.isNullable() + ", autoIncrement=" + this.isAutoIncrement() + ", defaultValue=" + this.getDefaultValue() + ")";
        }

        public String[] getFieldName() {
            return this.fieldName;
        }

        public Type getDataType() {
            return this.dataType;
        }

        @Nullable
        public String getComment() {
            return this.comment;
        }

        @Nullable
        public TableChange.ColumnPosition getPosition() {
            return this.position;
        }

        public boolean isNullable() {
            return this.nullable;
        }

        public boolean isAutoIncrement() {
            return this.autoIncrement;
        }

        public Expression getDefaultValue() {
            return this.defaultValue;
        }
    }

    public static class RemoveTablePropertyRequest
    implements TableUpdateRequest {
        @JsonProperty(value="property")
        private final String property;

        public RemoveTablePropertyRequest(String property) {
            this.property = property;
        }

        public RemoveTablePropertyRequest() {
            this(null);
        }

        @Override
        public void validate() throws IllegalArgumentException {
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.property), (Object)"\"property\" field is required and cannot be empty");
        }

        @Override
        public TableChange tableChange() {
            return TableChange.removeProperty((String)this.property);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RemoveTablePropertyRequest)) {
                return false;
            }
            RemoveTablePropertyRequest other = (RemoveTablePropertyRequest)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$property = this.getProperty();
            String other$property = other.getProperty();
            return !(this$property == null ? other$property != null : !this$property.equals(other$property));
        }

        protected boolean canEqual(Object other) {
            return other instanceof RemoveTablePropertyRequest;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $property = this.getProperty();
            result = result * 59 + ($property == null ? 43 : $property.hashCode());
            return result;
        }

        public String toString() {
            return "TableUpdateRequest.RemoveTablePropertyRequest(property=" + this.getProperty() + ")";
        }

        public String getProperty() {
            return this.property;
        }
    }

    public static class SetTablePropertyRequest
    implements TableUpdateRequest {
        @JsonProperty(value="property")
        private final String property;
        @JsonProperty(value="value")
        private final String value;

        public SetTablePropertyRequest(String property, String value) {
            this.property = property;
            this.value = value;
        }

        public SetTablePropertyRequest() {
            this(null, null);
        }

        @Override
        public void validate() throws IllegalArgumentException {
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.property), (Object)"\"property\" field is required and cannot be empty");
            Preconditions.checkArgument((this.value != null ? 1 : 0) != 0, (Object)"\"value\" field is required and cannot be null");
        }

        @Override
        public TableChange tableChange() {
            return TableChange.setProperty((String)this.property, (String)this.value);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SetTablePropertyRequest)) {
                return false;
            }
            SetTablePropertyRequest other = (SetTablePropertyRequest)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$property = this.getProperty();
            String other$property = other.getProperty();
            if (this$property == null ? other$property != null : !this$property.equals(other$property)) {
                return false;
            }
            String this$value = this.getValue();
            String other$value = other.getValue();
            return !(this$value == null ? other$value != null : !this$value.equals(other$value));
        }

        protected boolean canEqual(Object other) {
            return other instanceof SetTablePropertyRequest;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $property = this.getProperty();
            result = result * 59 + ($property == null ? 43 : $property.hashCode());
            String $value = this.getValue();
            result = result * 59 + ($value == null ? 43 : $value.hashCode());
            return result;
        }

        public String toString() {
            return "TableUpdateRequest.SetTablePropertyRequest(property=" + this.getProperty() + ", value=" + this.getValue() + ")";
        }

        public String getProperty() {
            return this.property;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static class UpdateTableCommentRequest
    implements TableUpdateRequest {
        @JsonProperty(value="newComment")
        private final String newComment;

        public UpdateTableCommentRequest(String newComment) {
            this.newComment = newComment;
        }

        public UpdateTableCommentRequest() {
            this(null);
        }

        @Override
        public void validate() throws IllegalArgumentException {
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.newComment), (Object)"\"newComment\" field is required and cannot be empty");
        }

        @Override
        public TableChange tableChange() {
            return TableChange.updateComment((String)this.newComment);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof UpdateTableCommentRequest)) {
                return false;
            }
            UpdateTableCommentRequest other = (UpdateTableCommentRequest)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$newComment = this.getNewComment();
            String other$newComment = other.getNewComment();
            return !(this$newComment == null ? other$newComment != null : !this$newComment.equals(other$newComment));
        }

        protected boolean canEqual(Object other) {
            return other instanceof UpdateTableCommentRequest;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $newComment = this.getNewComment();
            result = result * 59 + ($newComment == null ? 43 : $newComment.hashCode());
            return result;
        }

        public String toString() {
            return "TableUpdateRequest.UpdateTableCommentRequest(newComment=" + this.getNewComment() + ")";
        }

        public String getNewComment() {
            return this.newComment;
        }
    }

    public static class RenameTableRequest
    implements TableUpdateRequest {
        @JsonProperty(value="newName")
        private final String newName;

        public RenameTableRequest(String newName) {
            this.newName = newName;
        }

        public RenameTableRequest() {
            this(null);
        }

        @Override
        public void validate() throws IllegalArgumentException {
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.newName), (Object)"\"newName\" field is required and cannot be empty");
        }

        @Override
        public TableChange tableChange() {
            return TableChange.rename((String)this.newName);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RenameTableRequest)) {
                return false;
            }
            RenameTableRequest other = (RenameTableRequest)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$newName = this.getNewName();
            String other$newName = other.getNewName();
            return !(this$newName == null ? other$newName != null : !this$newName.equals(other$newName));
        }

        protected boolean canEqual(Object other) {
            return other instanceof RenameTableRequest;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $newName = this.getNewName();
            result = result * 59 + ($newName == null ? 43 : $newName.hashCode());
            return result;
        }

        public String toString() {
            return "TableUpdateRequest.RenameTableRequest(newName=" + this.getNewName() + ")";
        }

        public String getNewName() {
            return this.newName;
        }
    }
}

