/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.catalog.postgresql.operation;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.sql.DataSource;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.gravitino.catalog.jdbc.JdbcSchema;
import org.apache.gravitino.catalog.jdbc.config.JdbcConfig;
import org.apache.gravitino.catalog.jdbc.converter.JdbcExceptionConverter;
import org.apache.gravitino.catalog.jdbc.operation.JdbcDatabaseOperations;
import org.apache.gravitino.exceptions.NoSuchSchemaException;
import org.apache.gravitino.meta.AuditInfo;

public class PostgreSqlSchemaOperations
extends JdbcDatabaseOperations {
    public static final Set<String> SYS_PG_DATABASE_NAMES = Collections.unmodifiableSet(new HashSet<String>(){
        {
            this.add("pg_toast");
            this.add("pg_catalog");
            this.add("information_schema");
        }
    });
    private String database;

    public void initialize(DataSource dataSource, JdbcExceptionConverter exceptionMapper, Map<String, String> conf) {
        super.initialize(dataSource, exceptionMapper, conf);
        this.database = new JdbcConfig(conf).getJdbcDatabase();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public JdbcSchema load(String schema) throws NoSuchSchemaException {
        try (Connection connection = this.getConnection();){
            ResultSet resultSet = this.getSchema(connection, schema);
            boolean found = false;
            while (resultSet.next()) {
                if (!Objects.equals(resultSet.getString(1), schema)) continue;
                found = true;
                break;
            }
            if (!found) {
                throw new NoSuchSchemaException("No such schema: %s", new Object[]{schema});
            }
            String comment = this.getSchemaComment(schema, connection);
            JdbcSchema jdbcSchema = (JdbcSchema)((JdbcSchema.Builder)((JdbcSchema.Builder)((JdbcSchema.Builder)((JdbcSchema.Builder)JdbcSchema.builder().withName(schema)).withComment(comment)).withAuditInfo(AuditInfo.EMPTY)).withProperties(Collections.emptyMap())).build();
            return jdbcSchema;
        }
        catch (SQLException e) {
            throw this.exceptionMapper.toGravitinoException(e);
        }
    }

    public List<String> listDatabases() {
        ArrayList<String> result = new ArrayList<String>();
        try (Connection connection = this.getConnection();){
            ResultSet resultSet = this.getSchema(connection, null);
            while (resultSet.next()) {
                String schemaName = resultSet.getString(1);
                if (this.isSystemDatabase(schemaName)) continue;
                result.add(resultSet.getString(1));
            }
        }
        catch (SQLException se) {
            throw this.exceptionMapper.toGravitinoException(se);
        }
        return result;
    }

    public String generateCreateDatabaseSql(String schema, String comment, Map<String, String> properties) {
        if (MapUtils.isNotEmpty(properties)) {
            throw new UnsupportedOperationException("PostgreSQL does not support properties on database create.");
        }
        StringBuilder sqlBuilder = new StringBuilder("CREATE SCHEMA \"" + schema + "\";");
        if (StringUtils.isNotEmpty((CharSequence)comment)) {
            sqlBuilder.append("COMMENT ON SCHEMA ").append("\"").append(schema).append("\"").append(" IS '").append(comment).append("'");
        }
        return sqlBuilder.toString();
    }

    private ResultSet getSchema(Connection connection, String schemaName) throws SQLException {
        DatabaseMetaData metaData = connection.getMetaData();
        return metaData.getSchemas(this.database, schemaName);
    }

    public String generateDropDatabaseSql(String schema, boolean cascade) {
        StringBuilder sqlBuilder = new StringBuilder(String.format("DROP SCHEMA %s%s%s", "\"", schema, "\""));
        if (cascade) {
            sqlBuilder.append(" CASCADE");
        }
        return sqlBuilder.toString();
    }

    protected Connection getConnection() throws SQLException {
        Connection connection = this.dataSource.getConnection();
        connection.setCatalog(this.database);
        return connection;
    }

    protected boolean isSystemDatabase(String dbName) {
        return SYS_PG_DATABASE_NAMES.contains(dbName.toLowerCase(Locale.ROOT));
    }

    private String getShowSchemaCommentSql(String schema) {
        return String.format("SELECT obj_description(n.oid, 'pg_namespace') AS comment\nFROM pg_catalog.pg_namespace n\nWHERE n.nspname = '%s';\n", schema);
    }

    private String getSchemaComment(String schema, Connection connection) throws SQLException {
        try (PreparedStatement preparedStatement = connection.prepareStatement(this.getShowSchemaCommentSql(schema));
             ResultSet resultSet = preparedStatement.executeQuery();){
            if (resultSet.next()) {
                String string = resultSet.getString("comment");
                return string;
            }
        }
        return null;
    }
}

