/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.catalog.postgresql.converter;

import java.time.LocalDate;
import java.time.LocalTime;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.gravitino.catalog.jdbc.converter.JdbcColumnDefaultValueConverter;
import org.apache.gravitino.catalog.jdbc.converter.JdbcTypeConverter;
import org.apache.gravitino.rel.Column;
import org.apache.gravitino.rel.expressions.Expression;
import org.apache.gravitino.rel.expressions.UnparsedExpression;
import org.apache.gravitino.rel.expressions.literals.Literals;
import org.apache.gravitino.rel.types.Decimal;

public class PostgreSqlColumnDefaultValueConverter
extends JdbcColumnDefaultValueConverter {
    private static final Pattern VALUE_WITH_TYPE = Pattern.compile("'(.+?)'::\\s*(.+)");
    private static final String NULL_PREFIX = "NULL::";

    public Expression toGravitino(JdbcTypeConverter.JdbcTypeBean type, String columnDefaultValue, boolean isExpression, boolean nullable) {
        if (columnDefaultValue == null) {
            return nullable ? Literals.NULL : Column.DEFAULT_VALUE_NOT_SET;
        }
        if (isExpression) {
            return UnparsedExpression.of((String)columnDefaultValue);
        }
        try {
            return this.parseLiteral(type, columnDefaultValue);
        }
        catch (Exception e) {
            if (columnDefaultValue.equals("CURRENT_TIMESTAMP")) {
                return Column.DEFAULT_VALUE_OF_CURRENT_TIMESTAMP;
            }
            return UnparsedExpression.of((String)columnDefaultValue);
        }
    }

    private Expression parseLiteral(JdbcTypeConverter.JdbcTypeBean type, String columnDefaultValue) {
        Matcher matcher = VALUE_WITH_TYPE.matcher(columnDefaultValue);
        if (matcher.find()) {
            columnDefaultValue = matcher.group(1);
        }
        if (columnDefaultValue.startsWith(NULL_PREFIX)) {
            return Literals.NULL;
        }
        switch (type.getTypeName().toLowerCase()) {
            case "bool": {
                return Literals.booleanLiteral((Boolean)Boolean.valueOf(columnDefaultValue));
            }
            case "int2": {
                return Literals.shortLiteral((Short)Short.valueOf(columnDefaultValue));
            }
            case "int4": {
                return Literals.integerLiteral((Integer)Integer.valueOf(columnDefaultValue));
            }
            case "int8": {
                return Literals.longLiteral((Long)Long.valueOf(columnDefaultValue));
            }
            case "float4": {
                return Literals.floatLiteral((Float)Float.valueOf(columnDefaultValue));
            }
            case "float8": {
                return Literals.doubleLiteral((Double)Double.valueOf(columnDefaultValue));
            }
            case "numeric": {
                return Literals.decimalLiteral((Decimal)Decimal.of((String)columnDefaultValue, (int)Integer.parseInt(type.getColumnSize()), (int)Integer.parseInt(type.getScale())));
            }
            case "date": {
                return Literals.dateLiteral((LocalDate)LocalDate.parse(columnDefaultValue, DATE_TIME_FORMATTER));
            }
            case "timestamptz": {
                return Literals.timeLiteral((LocalTime)LocalTime.parse(columnDefaultValue, DATE_TIME_FORMATTER));
            }
            case "varchar": {
                return Literals.varcharLiteral((int)Integer.parseInt(type.getColumnSize()), (String)columnDefaultValue);
            }
            case "bpchar": 
            case "text": {
                return Literals.stringLiteral((String)columnDefaultValue);
            }
        }
        throw new IllegalArgumentException("Unknown data type for literal: " + type);
    }
}

