/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.server.web.rest;

import com.codahale.metrics.annotation.ResponseMetered;
import com.codahale.metrics.annotation.Timed;
import com.google.common.base.Preconditions;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.gravitino.NameIdentifier;
import org.apache.gravitino.catalog.PartitionDispatcher;
import org.apache.gravitino.dto.rel.partitions.PartitionDTO;
import org.apache.gravitino.dto.requests.AddPartitionsRequest;
import org.apache.gravitino.dto.responses.DropResponse;
import org.apache.gravitino.dto.responses.PartitionListResponse;
import org.apache.gravitino.dto.responses.PartitionNameListResponse;
import org.apache.gravitino.dto.responses.PartitionResponse;
import org.apache.gravitino.dto.util.DTOConverters;
import org.apache.gravitino.lock.LockType;
import org.apache.gravitino.lock.TreeLockUtils;
import org.apache.gravitino.rel.partitions.Partition;
import org.apache.gravitino.server.web.Utils;
import org.apache.gravitino.server.web.rest.ExceptionHandlers;
import org.apache.gravitino.server.web.rest.OperationType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/metalakes/{metalake}/catalogs/{catalog}/schemas/{schema}/tables/{table}/partitions")
public class PartitionOperations {
    private static final Logger LOG = LoggerFactory.getLogger(PartitionOperations.class);
    private final PartitionDispatcher dispatcher;
    @Context
    private HttpServletRequest httpRequest;

    @Inject
    public PartitionOperations(PartitionDispatcher dispatcher) {
        this.dispatcher = dispatcher;
    }

    @GET
    @Produces(value={"application/vnd.gravitino.v1+json"})
    @Timed(name="list-partition-name.http-request-duration-seconds", absolute=true)
    @ResponseMetered(name="list-partition-name", absolute=true)
    public Response listPartitionNames(@PathParam(value="metalake") String metalake, @PathParam(value="catalog") String catalog, @PathParam(value="schema") String schema, @PathParam(value="table") String table, @QueryParam(value="details") @DefaultValue(value="false") boolean verbose) {
        LOG.info("Received list partition {} request for table: {}.{}.{}.{}", new Object[]{verbose ? "infos" : "names", metalake, catalog, schema, table});
        try {
            return Utils.doAs(this.httpRequest, () -> {
                NameIdentifier tableIdent = NameIdentifier.of((String[])new String[]{metalake, catalog, schema, table});
                return (Response)TreeLockUtils.doWithTreeLock((NameIdentifier)tableIdent, (LockType)LockType.READ, () -> {
                    if (verbose) {
                        Partition[] partitions = this.dispatcher.listPartitions(tableIdent);
                        Response response = Utils.ok(new PartitionListResponse(DTOConverters.toDTOs((Partition[])partitions)));
                        LOG.info("List {} partitions in table {}.{}.{}.{}", new Object[]{partitions.length, metalake, catalog, schema, table});
                        return response;
                    }
                    String[] partitionNames = this.dispatcher.listPartitionNames(tableIdent);
                    Response response = Utils.ok(new PartitionNameListResponse(partitionNames));
                    LOG.info("List {} partition names in table {}.{}.{}.{}", new Object[]{partitionNames.length, metalake, catalog, schema, table});
                    return response;
                });
            });
        }
        catch (Exception e) {
            return ExceptionHandlers.handlePartitionException(OperationType.LIST, "", table, e);
        }
    }

    @GET
    @Path(value="{partition}")
    @Produces(value={"application/vnd.gravitino.v1+json"})
    @Timed(name="get-partition.http-request-duration-seconds", absolute=true)
    @ResponseMetered(name="get-partition", absolute=true)
    public Response getPartition(@PathParam(value="metalake") String metalake, @PathParam(value="catalog") String catalog, @PathParam(value="schema") String schema, @PathParam(value="table") String table, @PathParam(value="partition") String partition) {
        LOG.info("Received get partition request for partition[{}] of table[{}.{}.{}.{}]", new Object[]{partition, metalake, catalog, schema, table});
        try {
            return Utils.doAs(this.httpRequest, () -> {
                NameIdentifier tableIdent = NameIdentifier.of((String[])new String[]{metalake, catalog, schema, table});
                return (Response)TreeLockUtils.doWithTreeLock((NameIdentifier)tableIdent, (LockType)LockType.READ, () -> {
                    Partition p = this.dispatcher.getPartition(tableIdent, partition);
                    Response response = Utils.ok(new PartitionResponse(DTOConverters.toDTO((Partition)p)));
                    LOG.info("Got partition[{}] in table[{}.{}.{}.{}]", new Object[]{partition, metalake, catalog, schema, table});
                    return response;
                });
            });
        }
        catch (Exception e) {
            return ExceptionHandlers.handlePartitionException(OperationType.GET, "", table, e);
        }
    }

    @POST
    @Produces(value={"application/vnd.gravitino.v1+json"})
    @Timed(name="add-partitions.http-request-duration-seconds", absolute=true)
    @ResponseMetered(name="add-partitions", absolute=true)
    public Response addPartitions(@PathParam(value="metalake") String metalake, @PathParam(value="catalog") String catalog, @PathParam(value="schema") String schema, @PathParam(value="table") String table, AddPartitionsRequest request) {
        LOG.info("Received add {} partition(s) request for table {}.{}.{}.{} ", new Object[]{request.getPartitions().length, metalake, catalog, schema, table});
        Preconditions.checkArgument((request.getPartitions().length == 1 ? 1 : 0) != 0, (Object)"Only one partition is supported");
        try {
            return Utils.doAs(this.httpRequest, () -> {
                NameIdentifier tableIdent = NameIdentifier.of((String[])new String[]{metalake, catalog, schema, table});
                return (Response)TreeLockUtils.doWithTreeLock((NameIdentifier)tableIdent, (LockType)LockType.WRITE, () -> {
                    Partition p = this.dispatcher.addPartition(tableIdent, DTOConverters.fromDTO((PartitionDTO)request.getPartitions()[0]));
                    Response response = Utils.ok(new PartitionListResponse(new PartitionDTO[]{DTOConverters.toDTO((Partition)p)}));
                    LOG.info("Added {} partition(s) to table {}.{}.{}.{} ", new Object[]{1, metalake, catalog, schema, table});
                    return response;
                });
            });
        }
        catch (Exception e) {
            return ExceptionHandlers.handlePartitionException(OperationType.CREATE, "", table, e);
        }
    }

    @DELETE
    @Path(value="{partition}")
    @Produces(value={"application/vnd.gravitino.v1+json"})
    @Timed(name="drop-partition.http-request-duration-seconds", absolute=true)
    @ResponseMetered(name="drop-partition", absolute=true)
    public Response dropPartition(@PathParam(value="metalake") String metalake, @PathParam(value="catalog") String catalog, @PathParam(value="schema") String schema, @PathParam(value="table") String table, @PathParam(value="partition") String partition, @QueryParam(value="purge") @DefaultValue(value="false") boolean purge) {
        LOG.info("Received {} partition request for partition[{}] of table[{}.{}.{}.{}]", new Object[]{purge ? "purge" : "drop", partition, metalake, catalog, schema, table});
        try {
            return Utils.doAs(this.httpRequest, () -> {
                NameIdentifier tableIdent = NameIdentifier.of((String[])new String[]{metalake, catalog, schema, table});
                return (Response)TreeLockUtils.doWithTreeLock((NameIdentifier)tableIdent, (LockType)LockType.WRITE, () -> {
                    boolean dropped;
                    boolean bl = dropped = purge ? this.dispatcher.purgePartition(tableIdent, partition) : this.dispatcher.dropPartition(tableIdent, partition);
                    if (!dropped) {
                        LOG.warn("Failed to drop partition {} under table {} under schema {}", new Object[]{partition, table, schema});
                    }
                    Response response = Utils.ok(new DropResponse(dropped));
                    LOG.info("Partition {} {} in table {}.{}.{}.{}", new Object[]{partition, purge ? "purged" : "dropped", metalake, catalog, schema, table});
                    return response;
                });
            });
        }
        catch (Exception e) {
            return ExceptionHandlers.handlePartitionException(OperationType.DROP, "", table, e);
        }
    }
}

