/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.server.web.rest;

import com.codahale.metrics.annotation.ResponseMetered;
import com.codahale.metrics.annotation.Timed;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Locale;
import java.util.Optional;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.gravitino.MetadataObject;
import org.apache.gravitino.MetadataObjects;
import org.apache.gravitino.dto.requests.TagsAssociateRequest;
import org.apache.gravitino.dto.responses.NameListResponse;
import org.apache.gravitino.dto.responses.TagListResponse;
import org.apache.gravitino.dto.responses.TagResponse;
import org.apache.gravitino.dto.tag.TagDTO;
import org.apache.gravitino.dto.util.DTOConverters;
import org.apache.gravitino.exceptions.NoSuchTagException;
import org.apache.gravitino.server.web.Utils;
import org.apache.gravitino.server.web.rest.ExceptionHandlers;
import org.apache.gravitino.server.web.rest.OperationType;
import org.apache.gravitino.tag.Tag;
import org.apache.gravitino.tag.TagManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/metalakes/{metalake}/objects/{type}/{fullName}/tags")
public class MetadataObjectTagOperations {
    private static final Logger LOG = LoggerFactory.getLogger(MetadataObjectTagOperations.class);
    private final TagManager tagManager;
    @Context
    private HttpServletRequest httpRequest;

    @Inject
    public MetadataObjectTagOperations(TagManager tagManager) {
        this.tagManager = tagManager;
    }

    void setHttpRequest(HttpServletRequest httpRequest) {
        this.httpRequest = httpRequest;
    }

    @GET
    @Path(value="{tag}")
    @Produces(value={"application/vnd.gravitino.v1+json"})
    @Timed(name="get-object-tag.http-request-duration-seconds", absolute=true)
    @ResponseMetered(name="get-object-tag", absolute=true)
    public Response getTagForObject(@PathParam(value="metalake") String metalake, @PathParam(value="type") String type, @PathParam(value="fullName") String fullName, @PathParam(value="tag") String tagName) {
        LOG.info("Received get tag {} request for object type: {}, full name: {} under metalake: {}", new Object[]{tagName, type, fullName, metalake});
        try {
            return Utils.doAs(this.httpRequest, () -> {
                MetadataObject object = MetadataObjects.parse((String)fullName, (MetadataObject.Type)MetadataObject.Type.valueOf((String)type.toUpperCase(Locale.ROOT)));
                Optional<Tag> tag = this.getTagForObject(metalake, object, tagName);
                Optional<TagDTO> tagDTO = tag.map(t -> DTOConverters.toDTO((Tag)t, Optional.of(false)));
                MetadataObject parentObject = MetadataObjects.parent((MetadataObject)object);
                while (!tag.isPresent() && parentObject != null) {
                    tag = this.getTagForObject(metalake, parentObject, tagName);
                    tagDTO = tag.map(t -> DTOConverters.toDTO((Tag)t, Optional.of(true)));
                    parentObject = MetadataObjects.parent((MetadataObject)parentObject);
                }
                if (!tagDTO.isPresent()) {
                    LOG.warn("Tag {} not found for object type: {}, full name: {} under metalake: {}", new Object[]{tagName, type, fullName, metalake});
                    return Utils.notFound(NoSuchTagException.class.getSimpleName(), "Tag not found: " + tagName + " for object type: " + type + ", full name: " + fullName + " under metalake: " + metalake);
                }
                LOG.info("Get tag: {} for object type: {}, full name: {} under metalake: {}", new Object[]{tagName, type, fullName, metalake});
                return Utils.ok(new TagResponse(tagDTO.get()));
            });
        }
        catch (Exception e) {
            return ExceptionHandlers.handleTagException(OperationType.GET, tagName, fullName, e);
        }
    }

    @GET
    @Produces(value={"application/vnd.gravitino.v1+json"})
    @Timed(name="list-object-tags.http-request-duration-seconds", absolute=true)
    @ResponseMetered(name="list-object-tags", absolute=true)
    public Response listTagsForMetadataObject(@PathParam(value="metalake") String metalake, @PathParam(value="type") String type, @PathParam(value="fullName") String fullName, @QueryParam(value="details") @DefaultValue(value="false") boolean verbose) {
        LOG.info("Received list tag {} request for object type: {}, full name: {} under metalake: {}", new Object[]{verbose ? "infos" : "names", type, fullName, metalake});
        try {
            return Utils.doAs(this.httpRequest, () -> {
                MetadataObject object = MetadataObjects.parse((String)fullName, (MetadataObject.Type)MetadataObject.Type.valueOf((String)type.toUpperCase(Locale.ROOT)));
                ArrayList tags = Lists.newArrayList();
                Object[] nonInheritedTags = this.tagManager.listTagsInfoForMetadataObject(metalake, object);
                if (ArrayUtils.isNotEmpty((Object[])nonInheritedTags)) {
                    Collections.addAll(tags, (TagDTO[])Arrays.stream(nonInheritedTags).map(t -> DTOConverters.toDTO((Tag)t, Optional.of(false))).toArray(TagDTO[]::new));
                }
                MetadataObject parentObject = MetadataObjects.parent((MetadataObject)object);
                while (parentObject != null) {
                    Object[] inheritedTags = this.tagManager.listTagsInfoForMetadataObject(metalake, parentObject);
                    if (ArrayUtils.isNotEmpty((Object[])inheritedTags)) {
                        Collections.addAll(tags, (TagDTO[])Arrays.stream(inheritedTags).map(t -> DTOConverters.toDTO((Tag)t, Optional.of(true))).toArray(TagDTO[]::new));
                    }
                    parentObject = MetadataObjects.parent((MetadataObject)parentObject);
                }
                if (verbose) {
                    LOG.info("List {} tags info for object type: {}, full name: {} under metalake: {}", new Object[]{tags.size(), type, fullName, metalake});
                    return Utils.ok(new TagListResponse(tags.toArray(new TagDTO[0])));
                }
                String[] tagNames = (String[])tags.stream().map(TagDTO::name).distinct().toArray(String[]::new);
                LOG.info("List {} tags for object type: {}, full name: {} under metalake: {}", new Object[]{tagNames.length, type, fullName, metalake});
                return Utils.ok(new NameListResponse(tagNames));
            });
        }
        catch (Exception e) {
            return ExceptionHandlers.handleTagException(OperationType.LIST, "", fullName, e);
        }
    }

    @POST
    @Produces(value={"application/vnd.gravitino.v1+json"})
    @Timed(name="associate-object-tags.http-request-duration-seconds", absolute=true)
    @ResponseMetered(name="associate-object-tags", absolute=true)
    public Response associateTagsForObject(@PathParam(value="metalake") String metalake, @PathParam(value="type") String type, @PathParam(value="fullName") String fullName, TagsAssociateRequest request) {
        LOG.info("Received associate tags request for object type: {}, full name: {} under metalake: {}", new Object[]{type, fullName, metalake});
        try {
            return Utils.doAs(this.httpRequest, () -> {
                request.validate();
                MetadataObject object = MetadataObjects.parse((String)fullName, (MetadataObject.Type)MetadataObject.Type.valueOf((String)type.toUpperCase(Locale.ROOT)));
                Object[] tagNames = this.tagManager.associateTagsForMetadataObject(metalake, object, request.getTagsToAdd(), request.getTagsToRemove());
                tagNames = tagNames == null ? new String[]{} : tagNames;
                LOG.info("Associated tags: {} for object type: {}, full name: {} under metalake: {}", new Object[]{Arrays.toString(tagNames), type, fullName, metalake});
                return Utils.ok(new NameListResponse((String[])tagNames));
            });
        }
        catch (Exception e) {
            return ExceptionHandlers.handleTagException(OperationType.ASSOCIATE, "", fullName, e);
        }
    }

    private Optional<Tag> getTagForObject(String metalake, MetadataObject object, String tagName) {
        try {
            return Optional.ofNullable(this.tagManager.getTagForMetadataObject(metalake, object, tagName));
        }
        catch (NoSuchTagException e) {
            LOG.info("Tag {} not found for object: {}", (Object)tagName, (Object)object);
            return Optional.empty();
        }
    }
}

