/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.authorization.ranger;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.errorprone.annotations.FormatMethod;
import com.google.errorprone.annotations.FormatString;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.gravitino.MetadataObject;
import org.apache.gravitino.authorization.Owner;
import org.apache.gravitino.authorization.Privilege;
import org.apache.gravitino.authorization.SecurableObject;
import org.apache.gravitino.authorization.SecurableObjects;
import org.apache.gravitino.authorization.ranger.RangerAuthorizationPlugin;
import org.apache.gravitino.exceptions.AuthorizationPluginException;
import org.apache.ranger.RangerServiceException;
import org.apache.ranger.plugin.model.RangerPolicy;
import org.apache.ranger.plugin.model.RangerRole;
import org.apache.ranger.plugin.util.GrantRevokeRoleRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RangerHelper {
    private static final Logger LOG = LoggerFactory.getLogger(RangerHelper.class);
    public static final String MANAGED_BY_GRAVITINO = "MANAGED_BY_GRAVITINO";
    RangerAuthorizationPlugin rangerAuthorizationPlugin;
    protected Map<Privilege.Name, Set<String>> privilegesMapping = null;
    protected Set<String> ownerPrivileges = null;
    protected List<String> policySearchKeys = null;
    protected List<String> policyPreciseFilterKeys = null;

    public RangerHelper(RangerAuthorizationPlugin rangerAuthorizationPlugin, String catalogProvider) {
        this.rangerAuthorizationPlugin = rangerAuthorizationPlugin;
        switch (catalogProvider) {
            case "hive": {
                this.initPrivilegesMapping();
                this.initOwnerPrivileges();
                this.initPolicySearchKeys();
                this.initPreciseFilterKeys();
                break;
            }
            default: {
                throw new IllegalArgumentException("Authorization plugin unsupported catalog provider: " + catalogProvider);
            }
        }
    }

    private void initPrivilegesMapping() {
        this.privilegesMapping = ImmutableMap.builder().put((Object)Privilege.Name.CREATE_SCHEMA, (Object)ImmutableSet.of((Object)"create")).put((Object)Privilege.Name.CREATE_TABLE, (Object)ImmutableSet.of((Object)"create")).put((Object)Privilege.Name.MODIFY_TABLE, (Object)ImmutableSet.of((Object)"update", (Object)"alter", (Object)"write")).put((Object)Privilege.Name.SELECT_TABLE, (Object)ImmutableSet.of((Object)"read", (Object)"select")).build();
    }

    private void initOwnerPrivileges() {
        this.ownerPrivileges = ImmutableSet.of((Object)"all");
    }

    private void initPolicySearchKeys() {
        this.policySearchKeys = Arrays.asList("resource:database", "resource:table", "resource:column");
    }

    private void initPreciseFilterKeys() {
        this.policyPreciseFilterKeys = Arrays.asList("database", "table", "column");
    }

    void checkPolicyItemAccess(RangerPolicy.RangerPolicyItem policyItem) throws AuthorizationPluginException {
        if (policyItem.getAccesses().size() != 1) {
            throw new AuthorizationPluginException("The access type only have one in the delegate Gravitino management policy", new Object[0]);
        }
        HashSet setAccesses = new HashSet();
        policyItem.getAccesses().forEach(access -> {
            if (setAccesses.contains(access.getType())) {
                throw new AuthorizationPluginException("Contain duplicate privilege(%s) in the delegate Gravitino management policy ", new Object[]{access.getType()});
            }
            setAccesses.add(access.getType());
        });
    }

    void addPolicyItem(RangerPolicy policy, String roleName, SecurableObject securableObject) {
        this.checkPrivileges(securableObject);
        securableObject.privileges().forEach(gravitinoPrivilege -> this.rangerAuthorizationPlugin.translatePrivilege(gravitinoPrivilege.name()).forEach(mappedPrivilege -> {
            List matchPolicyItems = policy.getPolicyItems().stream().filter(policyItem -> policyItem.getAccesses().stream().anyMatch(access -> access.getType().equals(mappedPrivilege))).collect(Collectors.toList());
            if (matchPolicyItems.size() == 0) {
                RangerPolicy.RangerPolicyItem policyItem2 = new RangerPolicy.RangerPolicyItem();
                RangerPolicy.RangerPolicyItemAccess access = new RangerPolicy.RangerPolicyItemAccess();
                access.setType(mappedPrivilege);
                policyItem2.getAccesses().add(access);
                policyItem2.getRoles().add(roleName);
                if (Privilege.Condition.ALLOW == gravitinoPrivilege.condition()) {
                    policy.getPolicyItems().add(policyItem2);
                } else {
                    policy.getDenyPolicyItems().add(policyItem2);
                }
            } else {
                matchPolicyItems.stream().forEach(policyItem -> {
                    if (!policyItem.getRoles().contains(roleName)) {
                        policyItem.getRoles().add(roleName);
                    }
                });
            }
        }));
    }

    void removePolicyItem(RangerPolicy policy, String roleName, SecurableObject securableObject) {
        this.checkPrivileges(securableObject);
        policy.getPolicyItems().stream().forEach(policyItem -> policyItem.getAccesses().forEach(access -> {
            boolean matchPrivilege = securableObject.privileges().stream().filter(Objects::nonNull).flatMap(privilege -> this.rangerAuthorizationPlugin.translatePrivilege(privilege.name()).stream()).filter(Objects::nonNull).anyMatch(privilege -> access.getType().equals(privilege));
            if (matchPrivilege) {
                policyItem.getRoles().removeIf(roleName::equals);
            }
        }));
        policy.getPolicyItems().removeIf(policyItem -> policyItem.getRoles().isEmpty() && policyItem.getUsers().isEmpty() && policyItem.getGroups().isEmpty());
    }

    private boolean checkPrivileges(SecurableObject securableObject) {
        securableObject.privileges().forEach(privilege -> RangerHelper.check(this.privilegesMapping.containsKey(privilege.name()), "This privilege %s is not supported in the Ranger hive authorization", privilege.name()));
        return true;
    }

    public RangerPolicy findManagedPolicy(MetadataObject metadataObject) throws AuthorizationPluginException {
        List<String> nsMetadataObj = this.getMetadataObjectNames(metadataObject);
        HashMap<String, String> searchFilters = new HashMap<String, String>();
        HashMap<String, String> preciseFilters = new HashMap<String, String>();
        searchFilters.put("serviceName", this.rangerAuthorizationPlugin.rangerServiceName);
        searchFilters.put("policyLabelsPartial", MANAGED_BY_GRAVITINO);
        for (int i = 0; i < nsMetadataObj.size(); ++i) {
            searchFilters.put(this.policySearchKeys.get(i), nsMetadataObj.get(i));
            preciseFilters.put(this.policyPreciseFilterKeys.get(i), nsMetadataObj.get(i));
        }
        try {
            List policies = this.rangerAuthorizationPlugin.rangerClient.findPolicies(searchFilters);
            if (!policies.isEmpty()) {
                policies = policies.stream().filter(policy -> policy.getResources().entrySet().stream().allMatch(entry -> preciseFilters.containsKey(entry.getKey()) && ((RangerPolicy.RangerPolicyResource)entry.getValue()).getValues().size() == 1 && ((RangerPolicy.RangerPolicyResource)entry.getValue()).getValues().contains(preciseFilters.get(entry.getKey())))).collect(Collectors.toList());
            }
            if (policies.size() > 1) {
                throw new AuthorizationPluginException("Every metadata object has only a Gravitino managed policy.", new Object[0]);
            }
            if (policies.isEmpty()) {
                return null;
            }
            RangerPolicy policy2 = (RangerPolicy)policies.get(0);
            policy2.getPolicyItems().forEach(this::checkPolicyItemAccess);
            policy2.getDenyPolicyItems().forEach(this::checkPolicyItemAccess);
            policy2.getRowFilterPolicyItems().forEach(this::checkPolicyItemAccess);
            policy2.getDataMaskPolicyItems().forEach(this::checkPolicyItemAccess);
            return policy2;
        }
        catch (RangerServiceException e) {
            throw new AuthorizationPluginException((Throwable)e);
        }
    }

    protected boolean checkRangerRole(String roleName) throws AuthorizationPluginException {
        try {
            this.rangerAuthorizationPlugin.rangerClient.getRole(roleName, this.rangerAuthorizationPlugin.rangerAdminName, this.rangerAuthorizationPlugin.rangerServiceName);
        }
        catch (RangerServiceException e) {
            throw new AuthorizationPluginException((Throwable)e);
        }
        return true;
    }

    protected GrantRevokeRoleRequest createGrantRevokeRoleRequest(String roleName, String userName, String groupName) {
        HashSet users = StringUtils.isEmpty((String)userName) ? Sets.newHashSet() : Sets.newHashSet((Object[])new String[]{userName});
        HashSet groups = StringUtils.isEmpty((String)groupName) ? Sets.newHashSet() : Sets.newHashSet((Object[])new String[]{groupName});
        GrantRevokeRoleRequest roleRequest = new GrantRevokeRoleRequest();
        roleRequest.setUsers((Set)users);
        roleRequest.setGroups((Set)groups);
        roleRequest.setGrantor(this.rangerAuthorizationPlugin.rangerAdminName);
        roleRequest.setTargetRoles((Set)Sets.newHashSet((Object[])new String[]{roleName}));
        return roleRequest;
    }

    protected RangerRole createRangerRoleIfNotExists(String roleName) {
        RangerRole rangerRole = null;
        try {
            rangerRole = this.rangerAuthorizationPlugin.rangerClient.getRole(roleName, this.rangerAuthorizationPlugin.rangerAdminName, this.rangerAuthorizationPlugin.rangerServiceName);
        }
        catch (RangerServiceException e) {
            LOG.warn("The role({}) does not exist in the Ranger!", (Object)roleName);
        }
        try {
            if (rangerRole == null) {
                rangerRole = new RangerRole(roleName, MANAGED_BY_GRAVITINO, null, null, null);
                this.rangerAuthorizationPlugin.rangerClient.createRole(this.rangerAuthorizationPlugin.rangerServiceName, rangerRole);
            }
        }
        catch (RangerServiceException e) {
            throw new RuntimeException(e);
        }
        return rangerRole;
    }

    protected void updatePolicyOwner(RangerPolicy policy, Owner preOwner, Owner newOwner) {
        List<RangerPolicy.RangerPolicyItem> matchPolicyItems = policy.getPolicyItems().stream().filter(policyItem -> policyItem.getAccesses().stream().allMatch(policyItemAccess -> this.ownerPrivileges.contains(policyItemAccess.getType()))).collect(Collectors.toList());
        matchPolicyItems.forEach(policyItem -> {
            if (preOwner != null) {
                if (preOwner.type() == Owner.Type.USER) {
                    policyItem.getUsers().removeIf(preOwner.name()::equals);
                } else {
                    policyItem.getGroups().removeIf(preOwner.name()::equals);
                }
            }
            if (newOwner != null) {
                if (newOwner.type() == Owner.Type.USER) {
                    if (!policyItem.getUsers().contains(newOwner.name())) {
                        policyItem.getUsers().add(newOwner.name());
                    }
                } else if (!policyItem.getGroups().contains(newOwner.name())) {
                    policyItem.getGroups().add(newOwner.name());
                }
            }
        });
        this.ownerPrivileges.stream().filter(ownerPrivilege -> matchPolicyItems.stream().noneMatch(policyItem -> policyItem.getAccesses().stream().anyMatch(policyItemAccess -> ownerPrivilege.equals(policyItemAccess.getType())))).forEach(ownerPrivilege -> {
            RangerPolicy.RangerPolicyItem policyItem = new RangerPolicy.RangerPolicyItem();
            policyItem.getAccesses().add(new RangerPolicy.RangerPolicyItemAccess(ownerPrivilege));
            if (newOwner != null) {
                if (newOwner.type() == Owner.Type.USER) {
                    policyItem.getUsers().add(newOwner.name());
                } else {
                    policyItem.getGroups().add(newOwner.name());
                }
            }
            policy.getPolicyItems().add(policyItem);
        });
    }

    private List<String> getMetadataObjectNames(MetadataObject metadataObject) {
        ArrayList nsMetadataObject = Lists.newArrayList((Iterable)SecurableObjects.DOT_SPLITTER.splitToList((CharSequence)metadataObject.fullName()));
        if (nsMetadataObject.size() > 4) {
            throw new RuntimeException("The length of the securable object should not be greater than 4");
        }
        nsMetadataObject.remove(0);
        return nsMetadataObject;
    }

    protected RangerPolicy createPolicyAddResources(MetadataObject metadataObject) {
        RangerPolicy policy = new RangerPolicy();
        policy.setService(this.rangerAuthorizationPlugin.rangerServiceName);
        policy.setName(metadataObject.fullName());
        policy.setPolicyLabels((List)Lists.newArrayList((Object[])new String[]{MANAGED_BY_GRAVITINO}));
        List<String> nsMetadataObject = this.getMetadataObjectNames(metadataObject);
        for (int i = 0; i < nsMetadataObject.size(); ++i) {
            RangerPolicy.RangerPolicyResource policyResource = new RangerPolicy.RangerPolicyResource(nsMetadataObject.get(i));
            policy.getResources().put(this.policyPreciseFilterKeys.get(i), policyResource);
        }
        return policy;
    }

    protected RangerPolicy addOwnerToNewPolicy(MetadataObject metadataObject, Owner newOwner) {
        RangerPolicy policy = this.createPolicyAddResources(metadataObject);
        this.ownerPrivileges.forEach(ownerPrivilege -> {
            RangerPolicy.RangerPolicyItem policyItem = new RangerPolicy.RangerPolicyItem();
            policyItem.getAccesses().add(new RangerPolicy.RangerPolicyItemAccess(ownerPrivilege));
            if (newOwner != null) {
                if (newOwner.type() == Owner.Type.USER) {
                    policyItem.getUsers().add(newOwner.name());
                } else {
                    policyItem.getGroups().add(newOwner.name());
                }
            }
            policy.getPolicyItems().add(policyItem);
        });
        return policy;
    }

    @FormatMethod
    protected static void check(boolean condition, @FormatString String message, Object ... args) {
        if (!condition) {
            throw new AuthorizationPluginException(message, args);
        }
    }
}

