/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.authorization.ranger;

import com.google.common.collect.ImmutableMap;
import com.sun.jersey.api.client.GenericType;
import com.sun.jersey.api.client.UniformInterfaceException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import javax.ws.rs.core.Response;
import org.apache.gravitino.authorization.ranger.reference.VXGroup;
import org.apache.gravitino.authorization.ranger.reference.VXGroupList;
import org.apache.gravitino.authorization.ranger.reference.VXUser;
import org.apache.gravitino.authorization.ranger.reference.VXUserList;
import org.apache.ranger.RangerClient;
import org.apache.ranger.RangerServiceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RangerClientExtend
extends RangerClient {
    private static final Logger LOG = LoggerFactory.getLogger(RangerClientExtend.class);
    private static final String URI_USER_BASE = "/service/xusers/users";
    private static final String URI_USER_BY_ID = "/service/xusers/users/%d";
    private static final String URI_GROUP_BASE = "/service/xusers/groups";
    private static final String URI_GROUP_BY_ID = "/service/xusers/groups/%d";
    private static final String URI_CREATE_EXTERNAL_USER = "/service/xusers/users/external";
    private static final RangerClient.API SEARCH_USER = new RangerClient.API("/service/xusers/users", "GET", Response.Status.OK);
    private static final RangerClient.API CREATE_EXTERNAL_USER = new RangerClient.API("/service/xusers/users/external", "POST", Response.Status.OK);
    private static final RangerClient.API DELETE_USER = new RangerClient.API("/service/xusers/users/%d", "DELETE", Response.Status.NO_CONTENT);
    private static final RangerClient.API CREATE_GROUP = new RangerClient.API("/service/xusers/groups", "POST", Response.Status.OK);
    private static final RangerClient.API SEARCH_GROUP = new RangerClient.API("/service/xusers/groups", "GET", Response.Status.OK);
    private static final RangerClient.API DELETE_GROUP = new RangerClient.API("/service/xusers/groups/%d", "DELETE", Response.Status.NO_CONTENT);
    private Method callAPIMethodGenericResponseType;
    private Method callAPIMethodClassResponseType;
    private Method callAPIMethodNonResponse;

    public RangerClientExtend(String hostName, String authType, String username, String password) {
        super(hostName, authType, username, password, null);
        try {
            this.callAPIMethodGenericResponseType = RangerClient.class.getDeclaredMethod("callAPI", RangerClient.API.class, Map.class, Object.class, GenericType.class);
            this.callAPIMethodGenericResponseType.setAccessible(true);
            this.callAPIMethodNonResponse = RangerClient.class.getDeclaredMethod("callAPI", RangerClient.API.class, Map.class);
            this.callAPIMethodNonResponse.setAccessible(true);
            this.callAPIMethodClassResponseType = RangerClient.class.getDeclaredMethod("callAPI", RangerClient.API.class, Map.class, Object.class, Class.class);
            this.callAPIMethodClassResponseType.setAccessible(true);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    public Boolean createUser(VXUser user) throws RuntimeException {
        try {
            this.callAPIMethodClassResponseType.invoke((Object)this, CREATE_EXTERNAL_USER, null, user, VXUser.class);
        }
        catch (UniformInterfaceException e) {
            LOG.error("Failed to create user: " + (String)e.getResponse().getEntity(String.class));
            return Boolean.FALSE;
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause instanceof UniformInterfaceException) {
                UniformInterfaceException uniformException = (UniformInterfaceException)cause;
                int statusCode = uniformException.getResponse().getStatus();
                if (statusCode == 204) {
                    VXUserList userList = this.searchUser((Map<String, String>)ImmutableMap.of((Object)"name", (Object)user.getName()));
                    if (userList.getListSize() == 0) {
                        throw new RuntimeException("Failed to create user: " + user.getName(), cause);
                    }
                    return Boolean.TRUE;
                }
                throw new RuntimeException(e);
            }
            throw new RuntimeException(e);
        }
        return Boolean.TRUE;
    }

    public VXUserList searchUser(Map<String, String> filter) throws RuntimeException {
        try {
            return (VXUserList)this.callAPIMethodClassResponseType.invoke((Object)this, SEARCH_USER, filter, null, VXUserList.class);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean deleteUser(Long userId) throws RuntimeException {
        try {
            ImmutableMap params = ImmutableMap.of((Object)"forceDelete", (Object)"true");
            this.callAPIMethodNonResponse.invoke((Object)this, DELETE_USER.applyUrlFormat(new Object[]{userId}), params);
        }
        catch (IllegalAccessException | InvocationTargetException | RangerServiceException e) {
            throw new RuntimeException(e);
        }
        return true;
    }

    public Boolean createGroup(VXGroup group) throws RuntimeException {
        try {
            this.callAPIMethodClassResponseType.invoke((Object)this, CREATE_GROUP, null, group, VXGroup.class);
        }
        catch (UniformInterfaceException e) {
            LOG.error("Failed to create user: " + (String)e.getResponse().getEntity(String.class));
            return Boolean.FALSE;
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        return Boolean.TRUE;
    }

    public VXGroupList searchGroup(Map<String, String> filter) throws RuntimeException {
        try {
            return (VXGroupList)this.callAPIMethodClassResponseType.invoke((Object)this, SEARCH_GROUP, filter, null, VXGroupList.class);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean deleteGroup(Long groupId) throws RuntimeException {
        try {
            ImmutableMap params = ImmutableMap.of((Object)"forceDelete", (Object)"true");
            this.callAPIMethodNonResponse.invoke((Object)this, DELETE_GROUP.applyUrlFormat(new Object[]{groupId}), params);
        }
        catch (IllegalAccessException | InvocationTargetException | RangerServiceException e) {
            throw new RuntimeException(e);
        }
        return true;
    }
}

