/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.authorization.ranger;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.time.Instant;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.gravitino.MetadataObject;
import org.apache.gravitino.authorization.Group;
import org.apache.gravitino.authorization.Owner;
import org.apache.gravitino.authorization.Privilege;
import org.apache.gravitino.authorization.Role;
import org.apache.gravitino.authorization.RoleChange;
import org.apache.gravitino.authorization.SecurableObject;
import org.apache.gravitino.authorization.User;
import org.apache.gravitino.authorization.ranger.RangerClientExtend;
import org.apache.gravitino.authorization.ranger.RangerHelper;
import org.apache.gravitino.authorization.ranger.reference.VXGroup;
import org.apache.gravitino.authorization.ranger.reference.VXGroupList;
import org.apache.gravitino.authorization.ranger.reference.VXUser;
import org.apache.gravitino.authorization.ranger.reference.VXUserList;
import org.apache.gravitino.connector.authorization.AuthorizationPlugin;
import org.apache.gravitino.meta.AuditInfo;
import org.apache.gravitino.meta.GroupEntity;
import org.apache.gravitino.meta.UserEntity;
import org.apache.gravitino.utils.PrincipalUtils;
import org.apache.ranger.RangerServiceException;
import org.apache.ranger.plugin.model.RangerPolicy;
import org.apache.ranger.plugin.util.GrantRevokeRoleRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RangerAuthorizationPlugin
implements AuthorizationPlugin {
    private static final Logger LOG = LoggerFactory.getLogger(RangerAuthorizationPlugin.class);
    protected String catalogProvider;
    protected String rangerServiceName;
    protected RangerClientExtend rangerClient;
    private RangerHelper rangerHelper;
    @VisibleForTesting
    public final String rangerAdminName;

    public RangerAuthorizationPlugin(String catalogProvider, Map<String, String> config) {
        this.catalogProvider = catalogProvider;
        String rangerUrl = config.get("authorization.ranger.admin.url");
        String authType = config.get("authorization.ranger.auth.type");
        this.rangerAdminName = config.get("authorization.ranger.username");
        String password = config.get("authorization.ranger.password");
        this.rangerServiceName = config.get("authorization.ranger.service.name");
        RangerHelper.check(rangerUrl != null, "Ranger admin URL is required", new Object[0]);
        RangerHelper.check(authType != null, "Ranger auth type is required", new Object[0]);
        RangerHelper.check(this.rangerAdminName != null, "Ranger username is required", new Object[0]);
        RangerHelper.check(password != null, "Ranger password is required", new Object[0]);
        RangerHelper.check(this.rangerServiceName != null, "Ranger service name is required", new Object[0]);
        this.rangerClient = new RangerClientExtend(rangerUrl, authType, this.rangerAdminName, password);
        this.rangerHelper = new RangerHelper(this, catalogProvider);
    }

    public Set<String> translatePrivilege(Privilege.Name name) {
        return this.rangerHelper.privilegesMapping.get(name);
    }

    @VisibleForTesting
    public List<String> getOwnerPrivileges() {
        return Lists.newArrayList(this.rangerHelper.ownerPrivileges);
    }

    public Boolean onRoleCreated(Role role) throws RuntimeException {
        this.rangerHelper.createRangerRoleIfNotExists(role.name());
        return this.onRoleUpdated(role, (RoleChange[])role.securableObjects().stream().map(securableObject -> RoleChange.addSecurableObject((String)role.name(), (SecurableObject)securableObject)).toArray(RoleChange[]::new));
    }

    public Boolean onRoleAcquired(Role role) throws RuntimeException {
        return this.rangerHelper.checkRangerRole(role.name());
    }

    public Boolean onRoleDeleted(Role role) throws RuntimeException {
        this.onRoleUpdated(role, (RoleChange[])role.securableObjects().stream().map(securableObject -> RoleChange.removeSecurableObject((String)role.name(), (SecurableObject)securableObject)).toArray(RoleChange[]::new));
        try {
            this.rangerClient.deleteRole(role.name(), this.rangerAdminName, this.rangerServiceName);
        }
        catch (RangerServiceException e) {
            LOG.warn("Ranger delete role: {} failed!", (Object)role, (Object)e);
        }
        return Boolean.TRUE;
    }

    public Boolean onRoleUpdated(Role role, RoleChange ... changes) throws RuntimeException {
        for (RoleChange change : changes) {
            boolean execResult;
            if (change instanceof RoleChange.AddSecurableObject) {
                execResult = this.doAddSecurableObject((RoleChange.AddSecurableObject)change);
            } else if (change instanceof RoleChange.RemoveSecurableObject) {
                execResult = this.doRemoveSecurableObject((RoleChange.RemoveSecurableObject)change);
            } else if (change instanceof RoleChange.UpdateSecurableObject) {
                execResult = this.doUpdateSecurableObject((RoleChange.UpdateSecurableObject)change);
            } else {
                throw new IllegalArgumentException("Unsupported role change type: " + (change == null ? "null" : change.getClass().getSimpleName()));
            }
            if (execResult) continue;
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public Boolean onOwnerSet(MetadataObject metadataObject, Owner preOwner, Owner newOwner) throws RuntimeException {
        RangerHelper.check(newOwner != null, "The newOwner must be not null", new Object[0]);
        AuditInfo auditInfo = AuditInfo.builder().withCreator(PrincipalUtils.getCurrentPrincipal().getName()).withCreateTime(Instant.now()).build();
        if (newOwner.type() == Owner.Type.USER) {
            UserEntity userEntity = UserEntity.builder().withId(Long.valueOf(1L)).withName(newOwner.name()).withRoleNames(Collections.emptyList()).withRoleIds(Collections.emptyList()).withAuditInfo(auditInfo).build();
            this.onUserAdded((User)userEntity);
        } else {
            GroupEntity groupEntity = GroupEntity.builder().withId(Long.valueOf(1L)).withName(newOwner.name()).withRoleNames(Collections.emptyList()).withRoleIds(Collections.emptyList()).withAuditInfo(auditInfo).build();
            this.onGroupAdded((Group)groupEntity);
        }
        RangerPolicy policy = this.rangerHelper.findManagedPolicy(metadataObject);
        try {
            if (policy == null) {
                policy = this.rangerHelper.addOwnerToNewPolicy(metadataObject, newOwner);
                this.rangerClient.createPolicy(policy);
            } else {
                this.rangerHelper.updatePolicyOwner(policy, preOwner, newOwner);
                this.rangerClient.updatePolicy(policy.getId(), policy);
            }
        }
        catch (RangerServiceException e) {
            throw new RuntimeException(e);
        }
        return Boolean.TRUE;
    }

    public Boolean onGrantedRolesToUser(List<Role> roles, User user) throws RuntimeException {
        this.onUserAdded(user);
        roles.stream().forEach(role -> {
            this.rangerHelper.createRangerRoleIfNotExists(role.name());
            GrantRevokeRoleRequest grantRevokeRoleRequest = this.rangerHelper.createGrantRevokeRoleRequest(role.name(), user.name(), null);
            try {
                this.rangerClient.grantRole(this.rangerServiceName, grantRevokeRoleRequest);
            }
            catch (RangerServiceException e) {
                LOG.warn("Grant role: {} to user: {} failed!", new Object[]{role, user, e});
            }
        });
        return Boolean.TRUE;
    }

    public Boolean onRevokedRolesFromUser(List<Role> roles, User user) throws RuntimeException {
        this.onUserAdded(user);
        roles.stream().forEach(role -> {
            this.rangerHelper.checkRangerRole(role.name());
            GrantRevokeRoleRequest grantRevokeRoleRequest = this.rangerHelper.createGrantRevokeRoleRequest(role.name(), user.name(), null);
            try {
                this.rangerClient.revokeRole(this.rangerServiceName, grantRevokeRoleRequest);
            }
            catch (RangerServiceException e) {
                LOG.warn("Revoke role: {} from user: {} failed!", new Object[]{role, user, e});
            }
        });
        return Boolean.TRUE;
    }

    public Boolean onGrantedRolesToGroup(List<Role> roles, Group group) throws RuntimeException {
        this.onGroupAdded(group);
        roles.stream().forEach(role -> {
            this.rangerHelper.createRangerRoleIfNotExists(role.name());
            GrantRevokeRoleRequest grantRevokeRoleRequest = this.rangerHelper.createGrantRevokeRoleRequest(role.name(), null, group.name());
            try {
                this.rangerClient.grantRole(this.rangerServiceName, grantRevokeRoleRequest);
            }
            catch (RangerServiceException e) {
                LOG.warn("Grant role: {} to group: {} failed!", new Object[]{role, group, e});
            }
        });
        return Boolean.TRUE;
    }

    public Boolean onRevokedRolesFromGroup(List<Role> roles, Group group) throws RuntimeException {
        this.onGroupAdded(group);
        roles.stream().forEach(role -> {
            this.rangerHelper.checkRangerRole(role.name());
            GrantRevokeRoleRequest grantRevokeRoleRequest = this.rangerHelper.createGrantRevokeRoleRequest(role.name(), null, group.name());
            try {
                this.rangerClient.revokeRole(this.rangerServiceName, grantRevokeRoleRequest);
            }
            catch (RangerServiceException e) {
                LOG.warn("Revoke role: {} from group: {} failed!", new Object[]{role, group, e});
            }
        });
        return Boolean.TRUE;
    }

    public Boolean onUserAdded(User user) throws RuntimeException {
        VXUserList list = this.rangerClient.searchUser((Map<String, String>)ImmutableMap.of((Object)"name", (Object)user.name()));
        if (list.getListSize() > 0) {
            LOG.warn("The user({}) already exists in the Ranger!", (Object)user.name());
            return Boolean.FALSE;
        }
        VXUser rangerUser = VXUser.builder().withName(user.name()).withDescription(user.name()).build();
        return this.rangerClient.createUser(rangerUser);
    }

    public Boolean onUserRemoved(User user) throws RuntimeException {
        VXUserList list = this.rangerClient.searchUser((Map<String, String>)ImmutableMap.of((Object)"name", (Object)user.name()));
        if (list.getListSize() == 0) {
            LOG.warn("The user({}) doesn't exist in the Ranger!", (Object)user);
            return Boolean.FALSE;
        }
        this.rangerClient.deleteUser(list.getList().get(0).getId());
        return Boolean.TRUE;
    }

    public Boolean onUserAcquired(User user) throws RuntimeException {
        VXUserList list = this.rangerClient.searchUser((Map<String, String>)ImmutableMap.of((Object)"name", (Object)user.name()));
        if (list.getListSize() == 0) {
            LOG.warn("The user({}) doesn't exist in the Ranger!", (Object)user);
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public Boolean onGroupAdded(Group group) throws RuntimeException {
        return this.rangerClient.createGroup(VXGroup.builder().withName(group.name()).withDescription(group.name()).build());
    }

    public Boolean onGroupRemoved(Group group) throws RuntimeException {
        VXGroupList list = this.rangerClient.searchGroup((Map<String, String>)ImmutableMap.of((Object)"name", (Object)group.name()));
        if (list.getListSize() == 0) {
            LOG.warn("The group({}) doesn't exist in the Ranger!", (Object)group);
            return Boolean.FALSE;
        }
        return this.rangerClient.deleteGroup(list.getList().get(0).getId());
    }

    public Boolean onGroupAcquired(Group group) {
        VXGroupList vxGroupList = this.rangerClient.searchGroup((Map<String, String>)ImmutableMap.of((Object)"name", (Object)group.name()));
        if (vxGroupList.getListSize() == 0) {
            LOG.warn("The group({}) doesn't exist in the Ranger!", (Object)group);
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    private boolean doAddSecurableObject(RoleChange.AddSecurableObject change) {
        RangerPolicy policy = this.rangerHelper.findManagedPolicy((MetadataObject)change.getSecurableObject());
        if (policy != null) {
            Set newPrivileges;
            Set policyPrivileges = policy.getPolicyItems().stream().filter(policyItem -> policyItem.getRoles().contains(change.getRoleName())).flatMap(policyItem -> policyItem.getAccesses().stream()).map(RangerPolicy.RangerPolicyItemAccess::getType).collect(Collectors.toSet());
            if (policyPrivileges.containsAll(newPrivileges = change.getSecurableObject().privileges().stream().filter(Objects::nonNull).flatMap(privilege -> this.translatePrivilege(privilege.name()).stream()).filter(Objects::nonNull).collect(Collectors.toSet()))) {
                LOG.info("The privilege({}) already added to Ranger policy({})!", (Object)policy.getName(), (Object)change.getSecurableObject().fullName());
                return true;
            }
        } else {
            policy = this.rangerHelper.createPolicyAddResources((MetadataObject)change.getSecurableObject());
        }
        this.rangerHelper.addPolicyItem(policy, change.getRoleName(), change.getSecurableObject());
        try {
            if (policy.getId() == null) {
                this.rangerClient.createPolicy(policy);
            } else {
                this.rangerClient.updatePolicy(policy.getId(), policy);
            }
        }
        catch (RangerServiceException e) {
            throw new RuntimeException(e);
        }
        return true;
    }

    private boolean doRemoveSecurableObject(RoleChange.RemoveSecurableObject change) {
        RangerPolicy policy = this.rangerHelper.findManagedPolicy((MetadataObject)change.getSecurableObject());
        if (policy == null) {
            LOG.warn("Cannot find the Ranger policy({}) for the Gravitino securable object({})!", (Object)change.getRoleName(), (Object)change.getSecurableObject().fullName());
            return true;
        }
        policy.getPolicyItems().forEach(policyItem -> {
            boolean match = policyItem.getAccesses().stream().allMatch(access -> {
                boolean matchPrivilege = change.getSecurableObject().privileges().stream().filter(Objects::nonNull).flatMap(privilege -> this.translatePrivilege(privilege.name()).stream()).filter(Objects::nonNull).anyMatch(privilege -> privilege.equals(access.getType()));
                return matchPrivilege;
            });
            if (match) {
                policyItem.getRoles().removeIf(change.getRoleName()::equals);
            }
        });
        policy.getPolicyItems().removeIf(policyItem -> policyItem.getRoles().isEmpty() && policyItem.getUsers().isEmpty() && policyItem.getGroups().isEmpty());
        try {
            if (policy.getPolicyItems().isEmpty()) {
                this.rangerClient.deletePolicy(policy.getId());
            } else {
                this.rangerClient.updatePolicy(policy.getId(), policy);
            }
        }
        catch (RangerServiceException e) {
            LOG.error("Failed to remove the policy item from the Ranger policy {}!", (Object)policy);
            throw new RuntimeException(e);
        }
        return true;
    }

    private boolean doUpdateSecurableObject(RoleChange.UpdateSecurableObject change) {
        RangerPolicy policy = this.rangerHelper.findManagedPolicy((MetadataObject)change.getSecurableObject());
        if (policy == null) {
            LOG.warn("Cannot find the Ranger policy({}) for the Gravitino securable object({})!", (Object)change.getRoleName(), (Object)change.getSecurableObject().fullName());
            return false;
        }
        this.rangerHelper.removePolicyItem(policy, change.getRoleName(), change.getSecurableObject());
        this.rangerHelper.addPolicyItem(policy, change.getRoleName(), change.getNewSecurableObject());
        try {
            if (policy.getId() == null) {
                this.rangerClient.createPolicy(policy);
            } else {
                this.rangerClient.updatePolicy(policy.getId(), policy);
            }
        }
        catch (RangerServiceException e) {
            throw new RuntimeException(e);
        }
        return true;
    }

    public void close() throws IOException {
    }
}

