/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.baserpc.client.util;

import io.reactivex.rxjava3.core.Observer;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.internal.util.AppendOnlyLinkedArrayList;
import io.reactivex.rxjava3.internal.util.ExceptionHelper;
import io.reactivex.rxjava3.internal.util.NotificationLite;
import io.reactivex.rxjava3.plugins.RxJavaPlugins;
import io.reactivex.rxjava3.subjects.Subject;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public final class FastBehaviorSubject<T>
extends Subject<T> {
    private final Set<BehaviorObserver<T>> terminated = Collections.emptySet();
    private final AtomicReference<Object> currentValue;
    private final AtomicReference<Set<BehaviorObserver<T>>> observerSet;
    private final Lock readLock;
    private final Lock writeLock;
    private final AtomicReference<Throwable> terminalThrowable;
    private long version;

    FastBehaviorSubject(T defaultVal) {
        ReentrantReadWriteLock rwLock = new ReentrantReadWriteLock();
        this.readLock = rwLock.readLock();
        this.writeLock = rwLock.writeLock();
        this.observerSet = new AtomicReference(ConcurrentHashMap.newKeySet());
        this.currentValue = new AtomicReference<T>(defaultVal);
        this.terminalThrowable = new AtomicReference();
    }

    public static <T> FastBehaviorSubject<T> create() {
        return new FastBehaviorSubject<Object>(null);
    }

    protected void subscribeActual(Observer<? super T> observer) {
        BehaviorObserver<T> bo = new BehaviorObserver<T>(observer, this);
        observer.onSubscribe(bo);
        if (this.registerObserver(bo)) {
            if (bo.cancelled) {
                this.unregisterObserver(bo);
            } else {
                bo.emitInitial();
            }
        } else {
            Throwable ex = this.terminalThrowable.get();
            if (ex == ExceptionHelper.TERMINATED) {
                observer.onComplete();
            } else {
                observer.onError(ex);
            }
        }
    }

    public void onSubscribe(Disposable d) {
        if (this.terminalThrowable.get() != null) {
            d.dispose();
        }
    }

    public void onNext(T t) {
        if (this.terminalThrowable.get() != null) {
            return;
        }
        Object notification = NotificationLite.next(t);
        this.updateCurrent(notification);
        for (BehaviorObserver<T> bo : this.observerSet.get()) {
            bo.emitNext(notification, this.version);
        }
    }

    public void onError(Throwable t) {
        if (!this.terminalThrowable.compareAndSet(null, t)) {
            RxJavaPlugins.onError((Throwable)t);
            return;
        }
        Object errNotification = NotificationLite.error((Throwable)t);
        for (BehaviorObserver<T> bo : this.terminateObservers(errNotification)) {
            bo.emitNext(errNotification, this.version);
        }
    }

    public void onComplete() {
        if (!this.terminalThrowable.compareAndSet(null, ExceptionHelper.TERMINATED)) {
            return;
        }
        Object completeNotification = NotificationLite.complete();
        for (BehaviorObserver<T> bo : this.terminateObservers(completeNotification)) {
            bo.emitNext(completeNotification, this.version);
        }
    }

    public boolean hasObservers() {
        return !this.observerSet.get().isEmpty();
    }

    public Throwable getThrowable() {
        Object val = this.currentValue.get();
        if (NotificationLite.isError((Object)val)) {
            return NotificationLite.getError((Object)val);
        }
        return null;
    }

    public T getValue() {
        Object val = this.currentValue.get();
        if (NotificationLite.isComplete((Object)val) || NotificationLite.isError((Object)val)) {
            return null;
        }
        return (T)NotificationLite.getValue((Object)val);
    }

    public boolean hasComplete() {
        return NotificationLite.isComplete((Object)this.currentValue.get());
    }

    public boolean hasThrowable() {
        return NotificationLite.isError((Object)this.currentValue.get());
    }

    private boolean registerObserver(BehaviorObserver<T> observer) {
        Set<BehaviorObserver<T>> currentSet = this.observerSet.get();
        if (currentSet == this.terminated) {
            return false;
        }
        currentSet.add(observer);
        return true;
    }

    private void unregisterObserver(BehaviorObserver<T> observer) {
        this.observerSet.get().remove(observer);
    }

    private Set<BehaviorObserver<T>> terminateObservers(Object terminalNotification) {
        this.updateCurrent(terminalNotification);
        return this.observerSet.getAndSet(this.terminated);
    }

    private void updateCurrent(Object newValue) {
        this.writeLock.lock();
        try {
            ++this.version;
            this.currentValue.lazySet(newValue);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private static final class BehaviorObserver<T>
    implements Disposable,
    AppendOnlyLinkedArrayList.NonThrowingPredicate<Object> {
        private final Observer<? super T> downstream;
        private final FastBehaviorSubject<T> parent;
        private boolean started;
        private boolean isEmitting;
        private AppendOnlyLinkedArrayList<Object> pendingQueue;
        private boolean fastPathEnabled;
        private volatile boolean cancelled;
        private long localVersion;

        BehaviorObserver(Observer<? super T> actual, FastBehaviorSubject<T> parent) {
            this.downstream = actual;
            this.parent = parent;
        }

        public void dispose() {
            if (!this.cancelled) {
                this.cancelled = true;
                this.parent.unregisterObserver(this);
            }
        }

        public boolean isDisposed() {
            return this.cancelled;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void emitInitial() {
            Object initial;
            if (this.cancelled) {
                return;
            }
            BehaviorObserver behaviorObserver = this;
            synchronized (behaviorObserver) {
                if (this.cancelled || this.started) {
                    return;
                }
                FastBehaviorSubject<T> src = this.parent;
                Lock readLock = src.readLock;
                readLock.lock();
                try {
                    this.localVersion = src.version;
                    initial = src.currentValue.get();
                }
                finally {
                    readLock.unlock();
                }
                this.isEmitting = initial != null;
                this.started = true;
            }
            if (initial != null && !this.test(initial)) {
                this.processQueue();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void emitNext(Object notification, long newVersion) {
            if (this.cancelled) {
                return;
            }
            if (!this.fastPathEnabled) {
                BehaviorObserver behaviorObserver = this;
                synchronized (behaviorObserver) {
                    if (this.cancelled) {
                        return;
                    }
                    if (this.localVersion == newVersion) {
                        return;
                    }
                    if (this.isEmitting) {
                        if (this.pendingQueue == null) {
                            this.pendingQueue = new AppendOnlyLinkedArrayList(4);
                        }
                        this.pendingQueue.add(notification);
                        return;
                    }
                    this.started = true;
                }
                this.fastPathEnabled = true;
            }
            this.test(notification);
        }

        public boolean test(Object notification) {
            return this.cancelled || NotificationLite.accept((Object)notification, this.downstream);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void processQueue() {
            while (!this.cancelled) {
                AppendOnlyLinkedArrayList<Object> q;
                BehaviorObserver behaviorObserver = this;
                synchronized (behaviorObserver) {
                    q = this.pendingQueue;
                    if (q == null) {
                        this.isEmitting = false;
                        return;
                    }
                    this.pendingQueue = null;
                }
                q.forEachWhile((AppendOnlyLinkedArrayList.NonThrowingPredicate)this);
            }
            return;
        }
    }
}

