/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.basekv.balance.impl;

import com.google.common.collect.Sets;
import java.time.Duration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import org.apache.bifromq.basehlc.HLC;
import org.apache.bifromq.basekv.balance.BalanceNow;
import org.apache.bifromq.basekv.balance.BalanceResult;
import org.apache.bifromq.basekv.balance.NoNeedBalance;
import org.apache.bifromq.basekv.balance.StoreBalancer;
import org.apache.bifromq.basekv.balance.command.BalanceCommand;
import org.apache.bifromq.basekv.balance.command.ChangeConfigCommand;
import org.apache.bifromq.basekv.proto.KVRangeDescriptor;
import org.apache.bifromq.basekv.proto.KVRangeId;
import org.apache.bifromq.basekv.proto.KVRangeStoreDescriptor;
import org.apache.bifromq.basekv.proto.State;
import org.apache.bifromq.basekv.raft.proto.ClusterConfig;
import org.apache.bifromq.basekv.raft.proto.RaftNodeStatus;
import org.apache.bifromq.basekv.raft.proto.RaftNodeSyncState;
import org.apache.bifromq.basekv.utils.KVRangeIdUtil;

public final class UnreachableReplicaRemovalBalancer
extends StoreBalancer {
    private final Supplier<Long> millisSource;
    private final Duration suspicionDuration;
    private final Map<KVRangeId, Map<String, Long>> replicaSuspicionTimeMap = new ConcurrentHashMap<KVRangeId, Map<String, Long>>();
    private volatile Map<String, Map<KVRangeId, KVRangeDescriptor>> latestDescriptorMap = new HashMap<String, Map<KVRangeId, KVRangeDescriptor>>();

    public UnreachableReplicaRemovalBalancer(String clusterId, String localStoreId) {
        this(clusterId, localStoreId, Duration.ofSeconds(15L), () -> ((HLC)HLC.INST).getPhysical());
    }

    public UnreachableReplicaRemovalBalancer(String clusterId, String localStoreId, Duration suspectDuration) {
        this(clusterId, localStoreId, suspectDuration, () -> ((HLC)HLC.INST).getPhysical());
    }

    UnreachableReplicaRemovalBalancer(String clusterId, String localStoreId, Duration suspicionDuration, Supplier<Long> millisSource) {
        super(clusterId, localStoreId);
        this.millisSource = millisSource;
        this.suspicionDuration = suspicionDuration;
    }

    public void update(Set<KVRangeStoreDescriptor> landscape) {
        Map<String, Map<KVRangeId, KVRangeDescriptor>> descriptorMap = this.build(landscape);
        this.latestDescriptorMap = descriptorMap;
        if (!descriptorMap.containsKey(this.localStoreId)) {
            this.replicaSuspicionTimeMap.clear();
            return;
        }
        HashSet<KVRangeId> currentLeaders = new HashSet<KVRangeId>();
        for (Map.Entry<KVRangeId, KVRangeDescriptor> rangeEntry : descriptorMap.get(this.localStoreId).entrySet()) {
            KVRangeId rangeId = rangeEntry.getKey();
            KVRangeDescriptor rangeDescriptor = rangeEntry.getValue();
            if (rangeDescriptor.getRole() != RaftNodeStatus.Leader) continue;
            currentLeaders.add(rangeId);
            Map probingReplicas = this.replicaSuspicionTimeMap.computeIfAbsent(rangeId, k -> new ConcurrentHashMap());
            Set currentReplicas = rangeDescriptor.getSyncStateMap().keySet();
            probingReplicas.keySet().removeIf(replicaId -> !currentReplicas.contains(replicaId));
            for (Map.Entry entry : rangeDescriptor.getSyncStateMap().entrySet()) {
                String replicaId2 = (String)entry.getKey();
                RaftNodeSyncState syncState = (RaftNodeSyncState)entry.getValue();
                if (syncState.equals((Object)RaftNodeSyncState.Probing)) {
                    probingReplicas.putIfAbsent(replicaId2, this.millisSource.get());
                    continue;
                }
                probingReplicas.remove(replicaId2);
            }
        }
        this.replicaSuspicionTimeMap.keySet().removeIf(kvRangeId -> !currentLeaders.contains(kvRangeId));
    }

    public BalanceResult balance() {
        long currentTime = this.millisSource.get();
        Map<String, Map<KVRangeId, KVRangeDescriptor>> storeDescriptors = this.latestDescriptorMap;
        for (KVRangeId rangeId : this.replicaSuspicionTimeMap.keySet()) {
            Map<String, Long> probingReplicas = this.replicaSuspicionTimeMap.get(rangeId);
            if (probingReplicas == null || probingReplicas.isEmpty()) continue;
            for (Map.Entry<String, Long> entry : probingReplicas.entrySet()) {
                String replicaId = entry.getKey();
                long suspicionTime = entry.getValue();
                HashSet<String> unhealthyReplicas = new HashSet<String>();
                if (Duration.ofMillis(currentTime - suspicionTime).compareTo(this.suspicionDuration) > 0 && this.isMissingInStore(rangeId, replicaId, storeDescriptors)) {
                    unhealthyReplicas.add(replicaId);
                }
                KVRangeDescriptor rangeDescriptor = storeDescriptors.get(this.localStoreId).get(rangeId);
                if (unhealthyReplicas.isEmpty() || rangeDescriptor.getState() != State.StateType.Normal) continue;
                ClusterConfig clusterConfig = rangeDescriptor.getConfig();
                this.log.debug("Remove unhealthy replicas: rangeId={}, replicas={}", (Object)KVRangeIdUtil.toString((KVRangeId)rangeId), unhealthyReplicas);
                return BalanceNow.of((BalanceCommand)((ChangeConfigCommand.ChangeConfigCommandBuilder)((ChangeConfigCommand.ChangeConfigCommandBuilder)((ChangeConfigCommand.ChangeConfigCommandBuilder)ChangeConfigCommand.builder().toStore(this.localStoreId)).kvRangeId(rangeId)).expectedVer(rangeDescriptor.getVer())).voters((Set)Sets.difference((Set)Sets.newHashSet((Iterable)clusterConfig.getVotersList()), unhealthyReplicas)).learners((Set)Sets.difference((Set)Sets.newHashSet((Iterable)clusterConfig.getLearnersList()), unhealthyReplicas)).build());
            }
        }
        return NoNeedBalance.INSTANCE;
    }

    private Map<String, Map<KVRangeId, KVRangeDescriptor>> build(Set<KVRangeStoreDescriptor> descriptors) {
        HashMap<String, Map<KVRangeId, KVRangeDescriptor>> descriptorMap = new HashMap<String, Map<KVRangeId, KVRangeDescriptor>>();
        for (KVRangeStoreDescriptor storeDescriptor : descriptors) {
            HashMap<KVRangeId, KVRangeDescriptor> rangeDescriptorMap = new HashMap<KVRangeId, KVRangeDescriptor>();
            for (KVRangeDescriptor rangeDescriptor : storeDescriptor.getRangesList()) {
                rangeDescriptorMap.put(rangeDescriptor.getId(), rangeDescriptor);
            }
            descriptorMap.put(storeDescriptor.getId(), rangeDescriptorMap);
        }
        return descriptorMap;
    }

    private boolean isMissingInStore(KVRangeId rangeId, String storeId, Map<String, Map<KVRangeId, KVRangeDescriptor>> descriptorMap) {
        return descriptorMap.containsKey(storeId) && !descriptorMap.get(storeId).containsKey(rangeId);
    }
}

