/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.apache.bifromq.basekv.localengine.memory;

import com.google.protobuf.Struct;
import java.util.concurrent.CompletableFuture;
import org.apache.bifromq.basekv.localengine.IKVSpaceWriter;
import org.apache.bifromq.basekv.localengine.IWALableKVSpace;
import org.apache.bifromq.basekv.localengine.metrics.KVSpaceOpMeters;
import org.slf4j.Logger;

class InMemWALableKVSpace extends InMemKVSpace<InMemWALableKVEngine, InMemWALableKVSpace>
    implements IWALableKVSpace {
    private final InMemKVSpaceEpoch epoch;

    InMemWALableKVSpace(String id,
                        Struct conf,
                        InMemWALableKVEngine engine,
                        Runnable onDestroy,
                        KVSpaceOpMeters opMeters,
                        Logger logger,
                        String... tags) {
        super(id, conf, engine, onDestroy, opMeters, logger, tags);
        epoch = new InMemKVSpaceEpoch();
    }

    @Override
    public CompletableFuture<Long> flush() {
        return CompletableFuture.completedFuture(System.nanoTime());
    }

    @Override
    public IKVSpaceWriter toWriter() {
        return new InMemKVSpaceWriter<>(id, epoch, engine, syncContext, metadataUpdated -> {
            if (metadataUpdated) {
                this.loadMetadata();
            }
        }, impact -> {
            tracker.updateOnWrite(impact, epoch.dataMap());
        }, opMeters, logger);
    }

    @Override
    protected void doClose() {

    }

    @Override
    protected InMemKVSpaceEpoch handle() {
        return epoch;
    }

    @Override
    protected void doOpen() {

    }
}
