/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.geoparquet;

import java.util.List;
import org.apache.baremaps.geoparquet.GeoParquetGroup;
import org.apache.baremaps.geoparquet.GeoParquetMetadata;
import org.apache.baremaps.geoparquet.GeoParquetSchema;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.LogicalTypeAnnotation;
import org.apache.parquet.schema.PrimitiveType;

class GeoParquetGroupFactory {
    private final GroupType schema;
    private final GeoParquetMetadata metadata;
    private final GeoParquetSchema geoParquetSchema;

    public GeoParquetGroupFactory(GroupType schema, GeoParquetMetadata metadata) {
        this.schema = schema;
        this.metadata = metadata;
        this.geoParquetSchema = GeoParquetGroupFactory.createGeoParquetSchema(schema, metadata);
    }

    public static GeoParquetSchema createGeoParquetSchema(GroupType schema, GeoParquetMetadata metadata) {
        List<GeoParquetSchema.Field> fields = schema.getFields().stream().map(field -> {
            GeoParquetSchema.Cardinality cardinality;
            switch (field.getRepetition()) {
                default: {
                    throw new IncompatibleClassChangeError();
                }
                case REQUIRED: {
                    GeoParquetSchema.Cardinality cardinality2 = GeoParquetSchema.Cardinality.REQUIRED;
                    break;
                }
                case OPTIONAL: {
                    GeoParquetSchema.Cardinality cardinality2 = GeoParquetSchema.Cardinality.OPTIONAL;
                    break;
                }
                case REPEATED: {
                    GeoParquetSchema.Cardinality cardinality2 = cardinality = GeoParquetSchema.Cardinality.REPEATED;
                }
            }
            if (field.isPrimitive() && metadata.columns().containsKey(field.getName())) {
                return new GeoParquetSchema.GeometryField(field.getName(), cardinality);
            }
            if (!field.isPrimitive() && field.getName().equals("bbox")) {
                GroupType groupType = field.asGroupType();
                GeoParquetSchema geoParquetSchema = GeoParquetGroupFactory.createGeoParquetSchema(groupType, metadata);
                return new GeoParquetSchema.EnvelopeField(field.getName(), cardinality, geoParquetSchema);
            }
            if (!field.isPrimitive()) {
                GroupType groupType = field.asGroupType();
                GeoParquetSchema geoParquetSchema = GeoParquetGroupFactory.createGeoParquetSchema(groupType, metadata);
                return new GeoParquetSchema.GroupField(groupType.getName(), cardinality, geoParquetSchema);
            }
            if (field.getLogicalTypeAnnotation() != null && field.getLogicalTypeAnnotation().equals(LogicalTypeAnnotation.stringType())) {
                return new GeoParquetSchema.StringField(field.getName(), cardinality);
            }
            PrimitiveType primitiveType = field.asPrimitiveType();
            PrimitiveType.PrimitiveTypeName primitiveTypeName = primitiveType.getPrimitiveTypeName();
            String columnName = primitiveType.getName();
            return switch (primitiveTypeName) {
                default -> throw new IncompatibleClassChangeError();
                case PrimitiveType.PrimitiveTypeName.INT32 -> new GeoParquetSchema.IntegerField(columnName, cardinality);
                case PrimitiveType.PrimitiveTypeName.INT64 -> new GeoParquetSchema.LongField(columnName, cardinality);
                case PrimitiveType.PrimitiveTypeName.INT96 -> new GeoParquetSchema.Int96Field(columnName, cardinality);
                case PrimitiveType.PrimitiveTypeName.FLOAT -> new GeoParquetSchema.FloatField(columnName, cardinality);
                case PrimitiveType.PrimitiveTypeName.DOUBLE -> new GeoParquetSchema.DoubleField(columnName, cardinality);
                case PrimitiveType.PrimitiveTypeName.BOOLEAN -> new GeoParquetSchema.BooleanField(columnName, cardinality);
                case PrimitiveType.PrimitiveTypeName.BINARY -> new GeoParquetSchema.BinaryField(columnName, cardinality);
                case PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY -> new GeoParquetSchema.BinaryField(columnName, cardinality);
            };
        }).toList();
        return new GeoParquetSchema(schema.getName(), fields);
    }

    public GeoParquetGroup newGroup() {
        return new GeoParquetGroup(this.schema, this.metadata, this.geoParquetSchema);
    }
}

