/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.geoparquet;

import java.net.URI;
import java.util.Iterator;
import java.util.Spliterator;
import java.util.stream.Stream;
import org.apache.baremaps.geoparquet.GeoParquetException;
import org.apache.baremaps.geoparquet.GeoParquetReader;
import org.apache.baremaps.geoparquet.GeoParquetTypeConversion;
import org.apache.baremaps.store.DataRow;
import org.apache.baremaps.store.DataRowImpl;
import org.apache.baremaps.store.DataSchema;
import org.apache.baremaps.store.DataTable;
import org.apache.hadoop.fs.Path;

public class GeoParquetDataTable
implements DataTable {
    private final URI path;
    private DataSchema schema;
    private GeoParquetReader reader;

    public GeoParquetDataTable(URI path) {
        this.path = path;
        this.reader = new GeoParquetReader(new Path(path));
    }

    public long size() {
        return this.reader.size();
    }

    public Iterator<DataRow> iterator() {
        return this.parallelStream().iterator();
    }

    public Spliterator<DataRow> spliterator() {
        return this.parallelStream().spliterator();
    }

    public Stream<DataRow> stream() {
        return (Stream)this.parallelStream().sequential();
    }

    public Stream<DataRow> parallelStream() {
        return this.reader.readParallel().map(group -> new DataRowImpl(GeoParquetTypeConversion.asSchema(this.path.toString(), group.getGeoParquetSchema()), GeoParquetTypeConversion.asRowValues(group)));
    }

    public void clear() {
        if (this.reader != null) {
            this.reader = null;
        }
        if (this.schema != null) {
            this.schema = null;
        }
    }

    public DataSchema schema() {
        if (this.schema == null) {
            this.schema = GeoParquetTypeConversion.asSchema(this.path.toString(), this.reader.getGeoParquetSchema());
            return this.schema;
        }
        return this.schema;
    }

    public int srid(String column) {
        try {
            return this.reader.getGeoParquetMetadata().getSrid(column);
        }
        catch (Exception e) {
            throw new GeoParquetException("Fail to read the SRID from the GeoParquet metadata", e);
        }
    }
}

