/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS.config;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.LinkProperties;
import android.net.Network;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xbill.DNS.config.BaseResolverConfigProvider;
import org.xbill.DNS.config.InitializationException;

public class AndroidResolverConfigProvider
extends BaseResolverConfigProvider {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AndroidResolverConfigProvider.class);
    private static Context context = null;

    public static void setContext(Context ctx) {
        context = ctx;
    }

    @Override
    public void initialize() throws InitializationException {
        if (context == null) {
            throw new InitializationException("Context must be initialized by calling setContext");
        }
        ConnectivityManager cm = (ConnectivityManager)context.getSystemService(ConnectivityManager.class);
        Network network = cm.getActiveNetwork();
        if (network == null) {
            return;
        }
        LinkProperties lp = cm.getLinkProperties(network);
        if (lp == null) {
            return;
        }
        for (InetAddress address : lp.getDnsServers()) {
            this.addNameserver(new InetSocketAddress(address, 53));
        }
        this.parseSearchPathList(lp.getDomains(), ",");
    }

    @Override
    public boolean isEnabled() {
        return System.getProperty("java.vendor").contains("Android");
    }
}

