/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.sql;

import java.lang.reflect.Method;
import java.sql.Connection;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Optional;
import javax.sql.DataSource;
import org.apache.sis.setup.GeometryLibrary;
import org.apache.sis.setup.OptionKey;
import org.apache.sis.storage.Aggregate;
import org.apache.sis.storage.DataStore;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.DataStoreProvider;
import org.apache.sis.storage.FeatureSet;
import org.apache.sis.storage.IllegalNameException;
import org.apache.sis.storage.StorageConnector;
import org.apache.sis.storage.base.MetadataBuilder;
import org.apache.sis.storage.event.StoreEvent;
import org.apache.sis.storage.event.StoreListener;
import org.apache.sis.storage.event.WarningEvent;
import org.apache.sis.storage.sql.ResourceDefinition;
import org.apache.sis.storage.sql.SQLStoreProvider;
import org.apache.sis.storage.sql.feature.Database;
import org.apache.sis.storage.sql.feature.Resources;
import org.apache.sis.storage.sql.feature.SchemaModifier;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.Exceptions;
import org.apache.sis.util.internal.Strings;
import org.opengis.metadata.Metadata;
import org.opengis.metadata.spatial.SpatialRepresentationType;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.util.GenericName;

public class SQLStore
extends DataStore
implements Aggregate {
    private static final String[] NAME_GETTERS = new String[]{"getDescription", "getDataSourceName", "getDatabaseName", "getUrl", "getURL"};
    private final DataSource source;
    private final GeometryLibrary geomLibrary;
    private Database<?> model;
    private final GenericName[] tableNames;
    private final ResourceDefinition[] queries;
    private Metadata metadata;
    private final SchemaModifier customizer;

    public SQLStore(SQLStoreProvider provider, StorageConnector connector, ResourceDefinition ... resources) throws DataStoreException {
        super((DataStoreProvider)provider, connector);
        ArgumentChecks.ensureNonEmpty((String)"resources", (Object[])resources);
        this.source = (DataSource)connector.getStorageAs(DataSource.class);
        this.geomLibrary = (GeometryLibrary)connector.getOption(OptionKey.GEOMETRY_LIBRARY);
        this.customizer = (SchemaModifier)connector.getOption(SchemaModifier.OPTION);
        Object[] tableNames = new GenericName[resources.length];
        Object[] queries = new ResourceDefinition[resources.length];
        int tableCount = 0;
        int queryCount = 0;
        for (int i = 0; i < resources.length; ++i) {
            ResourceDefinition resource = resources[i];
            ArgumentChecks.ensureNonNullElement((String)"resources", (int)i, (Object)resource);
            GenericName name = resource.getName();
            int depth = name.depth();
            if (depth < 1 || depth > 3) {
                throw new IllegalNameException(Resources.format((short)3, name));
            }
            if (resource.query == null) {
                tableNames[tableCount++] = name;
                continue;
            }
            queries[queryCount++] = resource;
        }
        this.tableNames = (GenericName[])ArraysExt.resize((Object[])tableNames, (int)tableCount);
        this.queries = (ResourceDefinition[])ArraysExt.resize((Object[])queries, (int)queryCount);
        if (((Object)((Object)this)).getClass() == SQLStore.class) {
            this.listeners.useReadOnlyEvents();
        }
    }

    public Optional<ParameterValueGroup> getOpenParameters() {
        if (this.provider == null) {
            return Optional.empty();
        }
        ParameterValueGroup pg = this.provider.getOpenParameters().createValue();
        pg.parameter("location").setValue((Object)this.source);
        if (this.tableNames != null) {
            pg.parameter("tables").setValue((Object)this.tableNames);
        }
        if (this.queries != null) {
            LinkedHashMap<GenericName, String> m = new LinkedHashMap<GenericName, String>();
            for (ResourceDefinition query : this.queries) {
                m.put(query.getName(), query.query);
            }
            pg.parameter("queries").setValue(m);
        }
        return Optional.of(pg);
    }

    public Optional<GenericName> getIdentifier() throws DataStoreException {
        return Optional.empty();
    }

    private synchronized Database<?> model() throws DataStoreException {
        if (this.model == null) {
            try (Connection c = this.source.getConnection();){
                this.model = Database.create(this, this.source, c, this.geomLibrary, this.tableNames, this.queries, this.customizer, this.listeners);
            }
            catch (DataStoreException e) {
                throw e;
            }
            catch (Exception e) {
                throw new DataStoreException((Throwable)Exceptions.unwrap((Exception)e));
            }
        }
        return this.model;
    }

    private Database<?> model(Connection c) throws Exception {
        if (this.model == null) {
            this.model = Database.create(this, this.source, c, this.geomLibrary, this.tableNames, this.queries, this.customizer, this.listeners);
        }
        return this.model;
    }

    public synchronized Metadata getMetadata() throws DataStoreException {
        if (this.metadata == null) {
            MetadataBuilder builder = new MetadataBuilder();
            builder.addSpatialRepresentation(SpatialRepresentationType.TEXT_TABLE);
            try (Connection c = this.source.getConnection();){
                Database<?> model = this.model(c);
                if (model.hasGeometry()) {
                    builder.addSpatialRepresentation(SpatialRepresentationType.VECTOR);
                }
                if (model.hasRaster()) {
                    builder.addSpatialRepresentation(SpatialRepresentationType.GRID);
                }
                model.listTables(c.getMetaData(), builder);
            }
            catch (DataStoreException e) {
                throw e;
            }
            catch (Exception e) {
                throw new DataStoreException((Throwable)Exceptions.unwrap((Exception)e));
            }
            for (String c : NAME_GETTERS) {
                try {
                    String name;
                    Method method = this.source.getClass().getMethod(c, new Class[0]);
                    if (method.getReturnType() != String.class || (name = Strings.trimOrNull((String)((String)method.invoke((Object)this.source, new Object[0])))) == null) continue;
                    builder.addTitle((CharSequence)name);
                    break;
                }
                catch (NoSuchMethodException | SecurityException method) {
                }
                catch (ReflectiveOperationException e) {
                    throw new DataStoreException((Throwable)Exceptions.unwrap((Exception)e));
                }
            }
            this.metadata = builder.buildAndFreeze();
        }
        return this.metadata;
    }

    public Collection<FeatureSet> components() throws DataStoreException {
        return this.model().tables();
    }

    public FeatureSet findResource(String identifier) throws DataStoreException {
        return this.model().findTable(this, identifier);
    }

    public <T extends StoreEvent> void addListener(Class<T> eventType, StoreListener<? super T> listener) {
        if (listener == null || eventType == null || eventType.isAssignableFrom(WarningEvent.class)) {
            super.addListener(eventType, listener);
        }
    }

    public synchronized void close() throws DataStoreException {
        this.listeners.close();
        this.model = null;
    }
}

