/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.openstreetmap.stream;

import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProgressLogger<T>
implements Consumer<T> {
    private static final Logger logger = LoggerFactory.getLogger(ProgressLogger.class);
    private final AtomicLong position = new AtomicLong(0L);
    private final long size;
    private final int tick;
    private volatile long timestamp;

    public ProgressLogger(Long size, Integer tick) {
        this.size = size;
        this.tick = tick;
        this.timestamp = System.currentTimeMillis();
    }

    @Override
    public void accept(T e) {
        double p;
        long progress = this.position.incrementAndGet();
        long t = System.currentTimeMillis();
        long l = this.timestamp;
        if (this.size >= 0L && t - l >= (long)this.tick) {
            this.timestamp = t;
            p = (double)Math.round((double)progress * 10000.0 / (double)this.size) / 100.0;
            logger.info("{}%", (Object)p);
        }
        if (this.size >= 0L && progress == this.size) {
            p = 100.0;
            logger.info("{}%", (Object)p);
        }
    }
}

