/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.openstreetmap.model;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import org.apache.baremaps.openstreetmap.model.Element;
import org.apache.baremaps.openstreetmap.model.Info;
import org.apache.baremaps.openstreetmap.model.Member;
import org.locationtech.jts.geom.Geometry;

public final class Relation
extends Element {
    private List<Member> members;

    public Relation() {
    }

    public Relation(Long id, Info info, Map<String, Object> tags, List<Member> members) {
        super(id, info, tags);
        this.members = members;
    }

    public Relation(Long id, Info info, Map<String, Object> tags, List<Member> members, Geometry geometry) {
        super(id, info, tags, geometry);
        this.members = members;
    }

    public List<Member> getMembers() {
        return this.members;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Relation)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Relation relation = (Relation)o;
        return Objects.equals(this.members, relation.members);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.members);
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", Relation.class.getSimpleName() + "[", "]").add("members=" + String.valueOf(this.members)).add("id=" + this.id).toString();
    }
}

